/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.geotools.map.MapLayer;
import org.geotools.styling.Style;
import org.geotools.swing.JMapPane;
import org.geotools.swing.MapLayerTableCellRenderer;
import org.geotools.swing.control.DnDList;
import org.geotools.swing.control.DnDListModel;
import org.geotools.swing.styling.JSimpleStyleDialog;

public class MapLayerTable
extends JPanel {
    private static final long serialVersionUID = -8461593609237317561L;
    private static final ResourceBundle stringRes = ResourceBundle.getBundle("org/geotools/swing/Text");
    private JMapPane pane;
    private DnDListModel<MapLayer> listModel;
    private DnDList<MapLayer> list;
    private JScrollPane scrollPane;
    private static final long DOUBLE_CLICK_TIME = 500L;
    private long lastClickTime = 0L;
    private boolean confirmRemove = true;

    public MapLayerTable() {
        this.init();
    }

    public MapLayerTable(JMapPane pane) {
        this.init();
        this.setMapPane(pane);
    }

    public void setMapPane(JMapPane pane) {
        this.pane = pane;
        pane.setMapLayerTable(this);
    }

    public void onAddLayer(MapLayer layer) {
        this.listModel.insertItem(0, layer);
    }

    void onRemoveLayer(MapLayer layer) {
        this.listModel.removeItem(layer);
    }

    public void repaint(MapLayer layer) {
        int index = this.listModel.indexOf(layer);
        this.list.repaint(this.list.getCellBounds(index, index));
    }

    public void clear() {
        this.listModel.clear();
    }

    private void init() {
        this.listModel = new DnDListModel();
        this.list = new DnDList<MapLayer>(this.listModel){
            private static final long serialVersionUID = 1289744440656016412L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Rectangle r;
                int item = MapLayerTable.this.list.locationToIndex(e.getPoint());
                if (item >= 0 && (r = MapLayerTable.this.list.getCellBounds(item, item)).contains(e.getPoint())) {
                    Point p = new Point(e.getPoint().x, e.getPoint().y - r.y);
                    if (MapLayerTableCellRenderer.hitSelectionLabel(p)) {
                        return stringRes.getString("select_layer");
                    }
                    if (MapLayerTableCellRenderer.hitVisibilityLabel(p)) {
                        return stringRes.getString("show_layer");
                    }
                    if (MapLayerTableCellRenderer.hitStyleLabel(p)) {
                        return stringRes.getString("style_layer");
                    }
                    if (MapLayerTableCellRenderer.hitRemoveLabel(p)) {
                        return stringRes.getString("remove_layer");
                    }
                    if (MapLayerTableCellRenderer.hitNameLabel(p)) {
                        return stringRes.getString("rename_layer");
                    }
                }
                return null;
            }
        };
        this.listModel.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent e) {
            }

            public void intervalRemoved(ListDataEvent e) {
            }

            public void contentsChanged(ListDataEvent e) {
                MapLayerTable.this.onReorderLayers(e);
            }
        });
        this.list.setCellRenderer(new MapLayerTableCellRenderer());
        this.list.setFixedCellHeight(MapLayerTableCellRenderer.getCellHeight());
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                long clickTime = System.currentTimeMillis();
                boolean doubleClick = clickTime - MapLayerTable.this.lastClickTime < 500L;
                MapLayerTable.this.lastClickTime = clickTime;
                MapLayerTable.this.onLayerItemClicked(e, doubleClick);
            }
        });
        this.scrollPane = new JScrollPane(this.list, 20, 32);
        this.scrollPane.setBorder(BorderFactory.createTitledBorder(stringRes.getString("layers_list_title")));
        JPanel btnPanel = new JPanel();
        Icon showIcon = MapLayerTableCellRenderer.LayerControlItem.VISIBLE.getIcon();
        JButton showAllBtn = new JButton(showIcon);
        showAllBtn.setToolTipText(stringRes.getString("show_all_layers"));
        showAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapLayerTable.this.onShowAllLayers();
            }
        });
        btnPanel.add(showAllBtn);
        Icon hideIcon = MapLayerTableCellRenderer.LayerControlItem.VISIBLE.getOffIcon();
        JButton hideAllBtn = new JButton(hideIcon);
        hideAllBtn.setToolTipText(stringRes.getString("hide_all_layers"));
        hideAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapLayerTable.this.onHideAllLayers();
            }
        });
        btnPanel.add(hideAllBtn);
        Icon onIcon = MapLayerTableCellRenderer.LayerControlItem.SELECTED.getIcon();
        JButton selAllBtn = new JButton(onIcon);
        selAllBtn.setToolTipText(stringRes.getString("select_all_layers"));
        selAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapLayerTable.this.onSelectAllLayers();
            }
        });
        btnPanel.add(selAllBtn);
        Icon offIcon = MapLayerTableCellRenderer.LayerControlItem.SELECTED.getOffIcon();
        JButton unselAllBtn = new JButton(offIcon);
        unselAllBtn.setToolTipText(stringRes.getString("unselect_all_layers"));
        unselAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MapLayerTable.this.onUnselectAllLayers();
            }
        });
        btnPanel.add(unselAllBtn);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)btnPanel, "South");
    }

    private void onLayerItemClicked(MouseEvent ev, boolean doubleClick) {
        Rectangle r;
        int item = this.list.locationToIndex(ev.getPoint());
        if (item >= 0 && (r = this.list.getCellBounds(item, item)).contains(ev.getPoint())) {
            MapLayer layer = this.listModel.getElementAt(item);
            Point p = new Point(ev.getPoint().x, ev.getPoint().y - r.y);
            if (MapLayerTableCellRenderer.hitSelectionLabel(p)) {
                layer.setSelected(!layer.isSelected());
            } else if (MapLayerTableCellRenderer.hitVisibilityLabel(p)) {
                layer.setVisible(!layer.isVisible());
            } else if (MapLayerTableCellRenderer.hitStyleLabel(p)) {
                this.doSetStyle(layer);
            } else if (MapLayerTableCellRenderer.hitRemoveLabel(p)) {
                this.doRemoveLayer(layer);
            } else if (MapLayerTableCellRenderer.hitNameLabel(p) && doubleClick) {
                this.doSetLayerName(layer);
            }
        }
    }

    private void doSetStyle(MapLayer layer) {
        Style style = JSimpleStyleDialog.showDialog((Component)this, layer);
        if (style != null) {
            layer.setStyle(style);
        }
    }

    private void doSetLayerName(MapLayer layer) {
        String name = JOptionPane.showInputDialog(stringRes.getString("new_layer_name_message"));
        if (name != null && name.trim().length() > 0) {
            layer.setTitle(name.trim());
        }
    }

    private void doRemoveLayer(MapLayer layer) {
        int confirm;
        if (this.confirmRemove && (confirm = JOptionPane.showConfirmDialog(null, stringRes.getString("confirm_remove_layer_message"), stringRes.getString("confirm_remove_layer_title"), 0)) != 0) {
            return;
        }
        this.pane.getMapContext().removeLayer(layer);
    }

    private void onReorderLayers(ListDataEvent ev) {
        this.pane.setRepaint(false);
        for (int pos = ev.getIndex0(); pos <= ev.getIndex1(); ++pos) {
            MapLayer layer = this.listModel.getElementAt(pos);
            int newContextPos = this.listModel.getSize() - pos - 1;
            int curContextPos = this.pane.getMapContext().indexOf(layer);
            if (curContextPos == newContextPos) continue;
            this.pane.getMapContext().moveLayer(curContextPos, newContextPos);
        }
        this.pane.setRepaint(true);
        this.pane.repaint();
    }

    private void onShowAllLayers() {
        if (this.pane != null && this.pane.getMapContext() != null) {
            for (MapLayer layer : this.pane.getMapContext().getLayers()) {
                if (layer.isVisible()) continue;
                layer.setVisible(true);
            }
        }
    }

    private void onHideAllLayers() {
        if (this.pane != null && this.pane.getMapContext() != null) {
            for (MapLayer layer : this.pane.getMapContext().getLayers()) {
                if (!layer.isVisible()) continue;
                layer.setVisible(false);
            }
        }
    }

    private void onSelectAllLayers() {
        if (this.pane != null && this.pane.getMapContext() != null) {
            for (MapLayer layer : this.pane.getMapContext().getLayers()) {
                if (layer.isSelected()) continue;
                layer.setSelected(true);
            }
        }
    }

    private void onUnselectAllLayers() {
        if (this.pane != null && this.pane.getMapContext() != null) {
            for (MapLayer layer : this.pane.getMapContext().getLayers()) {
                if (!layer.isSelected()) continue;
                layer.setSelected(false);
            }
        }
    }
}

