/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogUtils {
    public static void showCentred(Window dialog) {
        DialogUtils.showCentredOnParent(null, dialog);
    }

    public static void showCentredOnParent(final Window parent, final Window dialog) {
        if (EventQueue.isDispatchThread()) {
            DialogUtils.doShowCentred(parent, dialog);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    DialogUtils.doShowCentred(parent, dialog);
                }
            });
        }
    }

    public static <T extends JComponent> List<T> getChildComponents(Class<T> clazz, Container parent, boolean includeNested) {
        ArrayList<T> children = new ArrayList<T>();
        for (Component c : parent.getComponents()) {
            boolean isClazz = clazz.isAssignableFrom(c.getClass());
            if (isClazz) {
                children.add(clazz.cast(c));
            }
            if (!includeNested || !(c instanceof Container)) continue;
            children.addAll(DialogUtils.getChildComponents(clazz, (Container)c, includeNested));
        }
        return children;
    }

    private static void doShowCentred(Window parent, Window dialog) {
        if (parent == null) {
            DialogUtils.doCentre(dialog, Toolkit.getDefaultToolkit().getScreenSize());
        } else {
            DialogUtils.doCentre(dialog, parent.getSize());
        }
        dialog.setVisible(true);
    }

    private static void doCentre(Window dialog, Dimension parentDim) {
        Dimension dialogDim = dialog.getSize();
        int x = Math.max(0, parentDim.width / 2 - dialogDim.width / 2);
        int y = Math.max(0, parentDim.height / 2 - dialogDim.height / 2);
        dialog.setLocation(x, y);
    }
}

