/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.tdk.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.Assert;

public class PrivateAccessor {
    public static Field getAccessiblePrivateField(Class<?> clazz, String fieldName) {
        Assert.assertNotNull(clazz);
        Assert.assertNotNull((Object)fieldName);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fieldName.equals(fields[i].getName())) continue;
            fields[i].setAccessible(true);
            return fields[i];
        }
        for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
            Field[] superFields = superClazz.getDeclaredFields();
            for (int i = 0; i < superFields.length; ++i) {
                if (!fieldName.equals(superFields[i].getName())) continue;
                superFields[i].setAccessible(true);
                return superFields[i];
            }
        }
        Assert.fail((String)("Field '" + fieldName + "' not found"));
        return null;
    }

    public static Object getPrivateFieldValue(Object object, String fieldName) {
        Assert.assertNotNull((Object)object);
        Assert.assertNotNull((Object)fieldName);
        Field field = PrivateAccessor.getAccessiblePrivateField(object.getClass(), fieldName);
        Assert.assertNotNull((String)("Field '" + fieldName + "' not found"), (Object)field);
        try {
            return field.get(object);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("IllegalArgumentException accessing " + fieldName + " at object " + object.toString()));
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)("IllegalAccessException accessing " + fieldName + " at object " + object.toString()));
        }
        return null;
    }

    public static void setPrivateFieldValue(Object object, String fieldName, Object value) {
        Assert.assertNotNull((Object)object);
        Assert.assertNotNull((Object)fieldName);
        Field field = PrivateAccessor.getAccessiblePrivateField(object.getClass(), fieldName);
        Assert.assertNotNull((String)("Field '" + fieldName + "' not found"), (Object)field);
        try {
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("IllegalArgumentException accessing " + fieldName + " at object " + object.toString()));
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)("IllegalAccessException accessing " + fieldName + " at object " + object.toString()));
        }
    }

    private static boolean argumentsHasType(Class<?> type, Object ... arguments) {
        for (Object methodArgument : arguments) {
            if (!type.isAssignableFrom(methodArgument.getClass())) continue;
            return true;
        }
        return false;
    }

    private static boolean isSameArgumentsType(Class<?>[] types, Object ... arguments) {
        for (Class<?> type : types) {
            if (PrivateAccessor.argumentsHasType(type, arguments)) continue;
            return false;
        }
        return true;
    }

    public static Method getAccessiblePrivateMethod(Class<?> clazz, String methodName, Object ... arguments) {
        Assert.assertNotNull(clazz);
        Assert.assertNotNull((Object)methodName);
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName()) || !PrivateAccessor.isSameArgumentsType(methods[i].getParameterTypes(), arguments)) continue;
            methods[i].setAccessible(true);
            return methods[i];
        }
        Class<?> superClazz = clazz.getSuperclass();
        return PrivateAccessor.getAccessiblePrivateMethod(superClazz, methodName, arguments);
    }

    public static Object callPrivateMethod(Object object, String methodName, Object ... arguments) {
        Assert.assertNotNull((Object)object);
        Method method = PrivateAccessor.getAccessiblePrivateMethod(object.getClass(), methodName, arguments);
        Assert.assertNotNull((String)("Method '" + methodName + "' not found"), (Object)method);
        try {
            return method.invoke(object, arguments);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("IllegalArgumentException accessing " + methodName + " at object " + object.toString()));
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)("IllegalAccessException accessing " + methodName + " at object " + object.toString()));
        }
        catch (InvocationTargetException e) {
            Assert.fail((String)("InvocationTargetException accessing " + methodName + " at object " + object.toString()));
        }
        return null;
    }
}

