package org.geotools.data.terralib.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import org.apache.log4j.Logger;
import org.geotools.data.terralib.NativeLibraryLoader;
import org.geotools.data.terralib.swig.DBConnectionFactoryNative;

public class DBConnectionFactory extends DBConnectionFactoryNative
{
    private static final Logger _logger = Logger.getLogger(DBConnectionFactory.class);

    private final String ACCESS_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
    
    static
    {
        _logger.info("Loading the provider DLLs...");

        boolean dllsLoaded = NativeLibraryLoader.loadLibraries();

        if (dllsLoaded)
        {
            _logger.info("Terralib provider DLLs loaded successfully.");
        }
        else
        {
            _logger.error("Failed to load the terralib provider DLLs!");
        }
    }

    public DBConnectionFactory()
    {
    }
    
    public Connection createJDBCAccessConnection(String path)
    {
        try 
        {
            final String URL = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + path + ";}";
            Class.forName(ACCESS_DRIVER);
            return DriverManager.getConnection(URL);
        } 
        catch (SQLException e) 
        {
            _logger.error("Error connecting to Access database.",e);
            return null;
        }
        catch (ClassNotFoundException e)
        {
            _logger.error("Error connecting to Access database.",e);
            return null;
        }        
    }
    
    public Connection createJDBCSqlServerConnection(String host, String userName, String password, String databaseName, int portNumber)
    {
        try
        {
            String connectionString = "jdbc:jtds:sqlserver://" + fixHost(host) + ":" + portNumber + "/" + databaseName;
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
            Connection conn = DriverManager.getConnection(connectionString, userName, password);
            return conn;
        }
        catch (ClassNotFoundException e)
        {
            _logger.error("Error connecting to SqlServer database.",e);
            return null;
        }
        catch (SQLException e)
        {
            _logger.error("Error connecting to SqlServer database.",e);
            return null;
        }
        
    }

    /**
     * For Terralib C++, sometimes the host need to be something like servername\devsql01.
     * For JTDS connection, is must be only servername (with \??? it doesn't connect).
     * This method removes /anything or \anything 
     * @param host The host informed by the user
     * @return The host fixed for JTDS connection
     */
    private String fixHost(String host)
    {
        String jtdsHost;
        if (host.contains("\\"))
            jtdsHost = host.substring(0, host.indexOf("\\"));
        else if (host.contains("/"))
            jtdsHost = host.substring(0, host.indexOf("/"));
        else if (host.contains(","))
            jtdsHost = host.substring(0, host.indexOf(","));
        else
            jtdsHost = host;
        return jtdsHost;
    }    
}
