/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: GeometryFactory.java
 * created: 19/03/2009
 */
package org.geotools.data.terralib.geometry;

import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

/**
 * @author fmoura
 *
 */
public class GeometryBuilder
{
    static GeometryFactory _defaultGeometryFactory = new GeometryFactory(new LiteCoordinateSequenceFactory());
    static LiteCoordinateSequenceFactory _sequenceFactory = new LiteCoordinateSequenceFactory();

    public static GeometryFactory getGeometryFactory()
    {
    	return _defaultGeometryFactory;
    }
      
    static double[] getPolygonExternalRing(Polygon polygon)
    {
        LineString lineString = polygon.getExteriorRing();
        return getLineVertices(lineString);
    }

/**
 * @param lineString
 * @return
 * @since
 */
    static public double[] getLineVertices(LineString lineString)
    {
        Coordinate[] coordinates = lineString.getCoordinates(); 
        double[] vertices = new double[coordinates.length*2];
        
        Coordinate currentCoord;
        int index = 0;
        for(int i = 0; i < coordinates.length; i++)
        {            
            currentCoord = coordinates[i]; 
            vertices[index] = currentCoord.x;
            vertices[index+1] = currentCoord.y;
            index = index + 2;
        }
        
        return vertices;
    }
    
    static public LineString buildLineString(double[] vertices)
    {
        
        Coordinate[] coordinates = new Coordinate[vertices.length/2];
        
        int index = 0;
        for(int i = 0 ; i < coordinates.length; i++)
        {
            Coordinate coord = new Coordinate(vertices[index],vertices[index+1]);
            coordinates[i] = coord;
            index = index + 2;
        }
        
        return _defaultGeometryFactory.createLineString(coordinates );
    }
    
    static public LinearRing buildLinearRing(double[] vertices)
    {
   
        CoordinateSequence coordinateSequence = _sequenceFactory.create(vertices);//new PackedCoordinateSequence.Double(vertices,2);

        return _defaultGeometryFactory.createLinearRing(coordinateSequence);
    }
    
    public static Point buildPoint(double x, double y) 
	{
		return _defaultGeometryFactory.createPoint(new Coordinate(x,y));
	}
    
    public static Polygon buildPolygon(double[] shellVertices, double[][] holesVertices)
    {
    	LinearRing shell = buildLinearRing(shellVertices);
    	LinearRing[] holes = new LinearRing[holesVertices.length];
    	int i = 0 ;
    	for(double[] holeVertices : holesVertices)
    	{
    		LinearRing hole = buildLinearRing(holeVertices);
    		holes[i] = hole;
    		i++;
    	}
    	
    	return _defaultGeometryFactory.createPolygon(shell, holes);
    }
    
    /**
     * Creates a MultiPoint from a given Point.
     * 
     * @param point Point object
     * @return a MultiPoint containing only the Point object 
     */
    static public MultiPoint buildMultiPoint(Point point)
    {
        return _defaultGeometryFactory.createMultiPoint(new Point[]{point});
    }

    /**
     * Creates a MultiLineString from a given line.
     * 
     * @param line LineString object
     * @return a MultiLineString containing only the LineString object 
     */
    static public MultiLineString buildMultiLineString(LineString line)
    {
        return _defaultGeometryFactory.createMultiLineString(new LineString[]{line});
    }
    
    /**
     * Creates a MultiPolygon from a given Polygon.
     * 
     * @param polygon Polygon object
     * @return a MultiPolygon containing only the Polygon object 
     */
    static public MultiPolygon buildMultiPolygon(Polygon polygon)
    {
        return _defaultGeometryFactory.createMultiPolygon(new Polygon[]{polygon});
    }

	

}
