/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: Querier.java
 * created: 15/01/2009
 */
package org.geotools.data.terralib.query;

import java.io.IOException;

import org.geotools.data.terralib.DefaultTerralibService;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.exception.TypeNotFoundException;
import org.geotools.data.terralib.query.portal.CppPortal;
import org.geotools.data.terralib.query.portal.Portal;
import org.geotools.data.terralib.swig.QuerierNative;

/**
 * @author fmoura
 *
 */
public class Querier extends QuerierNative
{
	
    private DefaultTerralibService _terralibService;
    
    /**
     * @param terralibService
     */
    public Querier(DefaultTerralibService terralibService)
    {
        super(terralibService);
        _terralibService = terralibService;
    }
    
    /**
     * 
     * @param params
     * @return
     * @throws IOException
     * @throws TypeNotFoundException 
     * @since
     */
    public QueryData execute(QuerierParams params) throws IOException, TypeNotFoundException
    {
    	
    	String uuid = _terralibService.getLock();
    	try
    	{
    		Portal portal = new CppPortal(super.execute(params),_terralibService,uuid);
    		return new TerralibQueryData(_terralibService, portal, params.getFeatureTypeInfo()/*,uuid*/);
    	}
    	catch(IOException e)
    	{
    		_terralibService.releaseLock(uuid);
    		throw e;
    	}
    	catch(TypeNotFoundException e)
    	{
    		_terralibService.releaseLock(uuid);
    		throw e;
    	}
    	catch(NullArgumentException e)
    	{
    		_terralibService.releaseLock(uuid);
    		throw e;
    	}
    	catch(Throwable e)
    	{
    		_terralibService.releaseLock(uuid);
    		throw new RuntimeException(e);
    	}
    }

}
