/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2010(c).
 * 
 * file: QueryChecker.java
 * created: May 10, 2010
 */
package org.geotools.data.terralib.query.check;

import org.geotools.data.Query;

/**
 * QueryCheckers are responsible to check if the query parameters are compatible with
 * each Database supported by TerralibProvider 
 * @author fabiomano
 * @since TDK 3.1
 */
public interface QueryChecker
{
    /**
     * Checks if the given query is supported.
     * If it's not, throw UnsupportedOperationException saying which parameter
     * is not supported.
     * @param query The query to check
     */
    public void checkQuery(Query query) throws UnsupportedOperationException;
}
