/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.connection;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.util.SimpleInternationalString;
import org.opengis.util.InternationalString;

public class DBConnectionParamUtils {
    public static final String DATABASE_DRIVER_ACCESS = "Access";
    public static final String DATABASE_DRIVER_SQL_SERVER = "SQLServer";
    public static final String TERRALIB_DATABASE_TYPE = "terralib";
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "must be 'terralib'", true, (Object)"terralib");
    public static final DataAccessFactory.Param DBDRIVER = new DataAccessFactory.Param("dbdriver", String.class, "database driver to use (Access or SQLServer)", true, (Object)"Access");
    public static final DataAccessFactory.Param DBPATH = new DataAccessFactory.Param("dbpath", String.class, "terralib access database path", false);
    public static final DataAccessFactory.Param HOST = new DataAccessFactory.Param("host", String.class, "terralib host machine", false, (Object)"localhost");
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param("user", String.class, "user name to login as", false, (Object)"admin");
    public static final DataAccessFactory.Param PASSWD = new DataAccessFactory.Param("passwd", String.class, (InternationalString)new SimpleInternationalString("password used to login"), false, null, Collections.singletonMap("isPassword", Boolean.TRUE));
    public static final DataAccessFactory.Param DBNAME = new DataAccessFactory.Param("dbname", String.class, "database name", false);
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "terralib connection port (default is 5432)", false, (Object)5432);
    public static final Integer DEFAULT_PORT_NUMBER = -1;
    private static final List<String> _validDatabaseTypes = Collections.unmodifiableList(Arrays.asList("Access", "SQLServer"));

    public static Map<String, ? extends Serializable> createAccessParametersMap(String path) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        parameterMap.put(DBConnectionParamUtils.DBDRIVER.key, DATABASE_DRIVER_ACCESS);
        parameterMap.put(DBConnectionParamUtils.DBPATH.key, path);
        parameterMap.put(DBConnectionParamUtils.DBTYPE.key, TERRALIB_DATABASE_TYPE);
        DBConnectionParamUtils.checkParams(parameterMap);
        return parameterMap;
    }

    public static Map<String, ? extends Serializable> createParametersMap(String dataBaseType, String host, String dataBaseName, String userName, String password) {
        return DBConnectionParamUtils.createParametersMap(dataBaseType, host, DEFAULT_PORT_NUMBER, dataBaseName, userName, password);
    }

    public static Map<String, ? extends Serializable> createParametersMap(String dataBaseDriver, String host, Integer portNumber, String dataBaseName, String userName, String password) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put(DBConnectionParamUtils.DBDRIVER.key, dataBaseDriver);
        parameterMap.put(DBConnectionParamUtils.HOST.key, host);
        parameterMap.put(DBConnectionParamUtils.DBNAME.key, dataBaseName);
        parameterMap.put(DBConnectionParamUtils.PORT.key, portNumber);
        parameterMap.put(DBConnectionParamUtils.USER.key, userName);
        parameterMap.put(DBConnectionParamUtils.PASSWD.key, password);
        parameterMap.put(DBConnectionParamUtils.DBTYPE.key, TERRALIB_DATABASE_TYPE);
        DBConnectionParamUtils.checkParams(parameterMap);
        return parameterMap;
    }

    public static void checkParams(Map<String, ? extends Serializable> paramMap) {
        String databaseTypeName = (String)((Object)paramMap.get(DBConnectionParamUtils.DBDRIVER.key));
        DBConnectionParamUtils.checkParamIsNotNull(DBConnectionParamUtils.DBTYPE.key, (String)((Object)paramMap.get(DBConnectionParamUtils.DBTYPE.key)));
        if (!TERRALIB_DATABASE_TYPE.equalsIgnoreCase((String)((Object)paramMap.get(DBConnectionParamUtils.DBTYPE.key)))) {
            throw new IllegalArgumentException("The database type must be terralib.");
        }
        if (null == databaseTypeName) {
            throw new IllegalArgumentException("The database driver can't be null.");
        }
        if (!_validDatabaseTypes.contains(databaseTypeName)) {
            throw new IllegalArgumentException("Unknown database driver: " + databaseTypeName);
        }
        if (DATABASE_DRIVER_ACCESS.equalsIgnoreCase(databaseTypeName)) {
            DBConnectionParamUtils.checkAccessParams(paramMap);
        } else {
            DBConnectionParamUtils.checkRegularParams(paramMap);
        }
    }

    private static void checkRegularParams(Map<String, ? extends Serializable> paramMap) {
        String host = (String)((Object)paramMap.get(DBConnectionParamUtils.HOST.key));
        DBConnectionParamUtils.checkParamIsNotNull(DBConnectionParamUtils.HOST.key, host);
        DBConnectionParamUtils.checkParamIsNotEmpty(DBConnectionParamUtils.HOST.key, host);
        String user = (String)((Object)paramMap.get(DBConnectionParamUtils.USER.key));
        DBConnectionParamUtils.checkParamIsNotNull(DBConnectionParamUtils.USER.key, user);
        DBConnectionParamUtils.checkParamIsNotEmpty(DBConnectionParamUtils.USER.key, user);
        String password = (String)((Object)paramMap.get(DBConnectionParamUtils.PASSWD.key));
        DBConnectionParamUtils.checkParamIsNotNull(DBConnectionParamUtils.PASSWD.key, password);
        DBConnectionParamUtils.checkParamIsNotEmpty(DBConnectionParamUtils.PASSWD.key, password);
        String databaseName = (String)((Object)paramMap.get(DBConnectionParamUtils.DBNAME.key));
        DBConnectionParamUtils.checkParamIsNotNull(DBConnectionParamUtils.DBNAME.key, databaseName);
        DBConnectionParamUtils.checkParamIsNotEmpty(DBConnectionParamUtils.DBNAME.key, databaseName);
        Serializable port = paramMap.get(DBConnectionParamUtils.PORT.key);
        DBConnectionParamUtils.checkParamIsNotNull(DBConnectionParamUtils.PORT.key, port);
        Integer portNumber = Integer.parseInt(port.toString());
        if (portNumber.compareTo(DEFAULT_PORT_NUMBER) != 0) {
            DBConnectionParamUtils.checkParamIsNotNegative(DBConnectionParamUtils.PORT.key, portNumber);
        }
    }

    private static void checkAccessParams(Map<String, ? extends Serializable> paramMap) {
        String path = (String)((Object)paramMap.get(DBConnectionParamUtils.DBPATH.key));
        DBConnectionParamUtils.checkParamIsNotNull(DBConnectionParamUtils.DBPATH.key, path);
        DBConnectionParamUtils.checkParamIsNotEmpty(DBConnectionParamUtils.DBPATH.key, path);
        File databaseFile = new File(path);
        if (!databaseFile.exists() || !databaseFile.isFile()) {
            throw new IllegalArgumentException("Path doesn't point to a valid file.");
        }
        String fileName = databaseFile.getName();
        if (!fileName.toLowerCase().endsWith(".mdb")) {
            throw new IllegalArgumentException("The referenced file hasn't an access file extension.");
        }
    }

    private static void checkParamIsNotNull(String parameterName, Object parameterValue) {
        assert (parameterName != null);
        if (null == parameterValue) {
            throw new IllegalArgumentException("Parameter \"" + parameterName + "\" cannot be empty.");
        }
    }

    private static void checkParamIsNotEmpty(String parameterName, String parameterValue) {
        assert (parameterName != null);
        if (parameterValue.isEmpty()) {
            throw new IllegalArgumentException("Parameter \"" + parameterName + "\" cannot be empty.");
        }
    }

    private static void checkParamIsNotNegative(String parameterName, Number parameterValue) {
        assert (parameterName != null);
        if (parameterValue.doubleValue() < 0.0) {
            throw new IllegalArgumentException("Parameter \"" + parameterName + "\" cannot be negative.");
        }
    }
}

