/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.feature;

import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.terralib.TerralibFeatureType;
import org.geotools.data.terralib.TerralibService;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.exception.TypeNotFoundException;
import org.geotools.data.terralib.feature.TerralibFeatureReader;
import org.geotools.data.terralib.feature.attribute.TerralibAttributePersistenceHandler;
import org.geotools.data.terralib.feature.attribute.TerralibAttributePersistenceHandlerTypeOperation;
import org.geotools.data.terralib.persistence.exception.MissingRequiredGeometryException;
import org.geotools.data.terralib.query.QueryData;
import org.geotools.data.terralib.util.TypeAttributeMap;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;

public class TerralibFeatureReaderWriter
implements FeatureReader<SimpleFeatureType, SimpleFeature>,
FeatureWriter<SimpleFeatureType, SimpleFeature> {
    protected QueryData _queryData;
    protected TerralibFeatureReader _featureReader;
    protected FeatureListenerManager _listenerManager;
    protected Transaction _transaction;
    private static Logger _logger = Logger.getLogger(TerralibFeatureReaderWriter.class);
    protected SimpleFeature _live = null;
    protected SimpleFeature _current = null;
    protected TerralibService _service;
    protected int featureIdIndex = -1;
    private TerralibAttributePersistenceHandler _persistenceHandler;

    public TerralibFeatureReaderWriter(FeatureListenerManager listenerManager, TerralibService service, QueryData queryData, TerralibFeatureType schema, Transaction transaction, TerralibAttributePersistenceHandler persistenceHandler) throws SchemaException {
        if (listenerManager == null) {
            throw new NullArgumentException("listenerManager");
        }
        if (service == null) {
            throw new NullArgumentException("service");
        }
        if (queryData == null) {
            throw new NullArgumentException("queryData");
        }
        if (schema == null) {
            throw new NullArgumentException("schema");
        }
        if (transaction == null) {
            throw new NullArgumentException("transaction");
        }
        if (persistenceHandler == null) {
            throw new NullArgumentException("persistenceHandler");
        }
        if (transaction != Transaction.AUTO_COMMIT) {
            _logger.warn((Object)"Transaction for the TerraLibFeatureReaderWriter is not set to AUTO_COMMIT. For now, TerralibFeatureReaderWriter only implements changes as AUTO_COMMIT. Your transaction will be ignored until we implement support for transaction.");
        }
        this._listenerManager = listenerManager;
        this._queryData = queryData;
        this._transaction = transaction;
        this._service = service;
        this._featureReader = new TerralibFeatureReader(queryData, (SimpleFeatureType)schema);
        this._persistenceHandler = persistenceHandler;
    }

    public TerralibFeatureType getFeatureType() {
        return (TerralibFeatureType)this._featureReader.getFeatureType();
    }

    public void close() throws IOException {
        if (!this._queryData.isClosed()) {
            this._featureReader.close();
        } else {
            _logger.warn((Object)"Feature writer calling close when queryData is already closed");
        }
    }

    private void checkClosedQueryData() {
        if (this._queryData.isClosed()) {
            throw new IllegalStateException("Terralib query data is closed");
        }
    }

    public boolean hasNext() throws IOException {
        this.checkClosedQueryData();
        return this._featureReader.hasNext();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        this.checkClosedQueryData();
        TerralibFeatureType featureType = this.getFeatureType();
        if (this.hasNext()) {
            this._live = this._featureReader.next();
            this._current = SimpleFeatureBuilder.copy((SimpleFeature)this._live);
            _logger.trace((Object)"Calling next on writer");
        } else {
            this._live = null;
            SimpleFeature temp = SimpleFeatureBuilder.template((SimpleFeatureType)featureType, null);
            this._current = new TerralibSimpleFeature(temp.getAttributes(), (SimpleFeatureType)featureType, null);
            this._queryData.next();
        }
        return this._current;
    }

    public void remove() throws IOException {
        this.checkClosedQueryData();
        if (this._live != null) {
            _logger.debug((Object)("Removing " + this._live));
            String featureId = this.getFeatureId();
            ReferencedEnvelope bounds = ReferencedEnvelope.reference((BoundingBox)this._live.getBounds());
            this._live = null;
            this._current = null;
            try {
                boolean removeOnlyGeometries = this._persistenceHandler != null && this._persistenceHandler.canProcess(this.getFeatureType().getTypeName(), TerralibAttributePersistenceHandlerTypeOperation.REMOVE);
                this._service.remove(this.getFeatureType().getTypeName(), featureId, removeOnlyGeometries);
                if (removeOnlyGeometries) {
                    this._persistenceHandler.removeFeatureAttributes(featureId);
                }
                this.fireFeaturesRemoved(bounds, false);
            }
            catch (org.geotools.data.terralib.exception.IllegalStateException e) {
                throw new DataSourceException("Error removing row", (Throwable)e);
            }
            catch (TypeNotFoundException e) {
                throw new DataSourceException("Error removing row", (Throwable)e);
            }
        } else {
            throw new IOException("No feature available to be removed.");
        }
    }

    protected String getFeatureId() throws DataSourceException, IOException {
        String featureId = this._queryData.getObjectId();
        return featureId;
    }

    public void write() throws IOException {
        this.checkClosedQueryData();
        _logger.debug((Object)("write called, live is " + this._live + " and current is " + this._current));
        if (this._live != null) {
            if (this._live.equals(this._current)) {
                this._live = null;
                this._current = null;
            } else {
                try {
                    this.doUpdate(this._live, this._current);
                    ReferencedEnvelope bounds = new ReferencedEnvelope(this._live.getType().getCoordinateReferenceSystem());
                    bounds.include(this._live.getBounds());
                    bounds.include(this._current.getBounds());
                    this.fireFeaturesChanged(bounds, false);
                }
                catch (DataSourceException dsException) {
                    this._queryData.close();
                    throw dsException;
                }
                this._live = null;
                this._current = null;
            }
        } else {
            _logger.debug((Object)"doing insert in terralib featurewriter");
            this.doInsert((TerralibSimpleFeature)this._current);
            this.fireFeaturesAdded(ReferencedEnvelope.reference((BoundingBox)this._current.getBounds()), false);
            this._current = null;
        }
    }

    public FeatureListenerManager getListenerManager() {
        return this._listenerManager;
    }

    protected void fireFeaturesRemoved(ReferencedEnvelope bounds, boolean isCommit) {
        String typeName = this._featureReader.getFeatureType().getTypeName();
        this._listenerManager.fireFeaturesRemoved(typeName, this._transaction, bounds, isCommit);
    }

    protected void fireFeaturesChanged(ReferencedEnvelope bounds, boolean isCommit) {
        String typeName = this._featureReader.getFeatureType().getTypeName();
        this._listenerManager.fireFeaturesChanged(typeName, this._transaction, bounds, isCommit);
    }

    protected void fireFeaturesAdded(ReferencedEnvelope bounds, boolean isCommit) {
        String typeName = this._featureReader.getFeatureType().getTypeName();
        this._listenerManager.fireFeaturesAdded(typeName, this._transaction, bounds, isCommit);
    }

    protected void doUpdate(SimpleFeature live, SimpleFeature current) throws IOException {
        for (int i = 0; i < current.getAttributeCount(); ++i) {
            Object currAtt = current.getAttribute(i);
            Object liveAtt = null;
            if (live != null) {
                liveAtt = live.getAttribute(i);
            }
            if (live != null && DataUtilities.attributesEqual((Object)liveAtt, (Object)currAtt)) continue;
            this._queryData.write(i, currAtt);
        }
        boolean writeOnlyGeometries = this._persistenceHandler != null && this._persistenceHandler.canProcess(current.getType().getTypeName(), TerralibAttributePersistenceHandlerTypeOperation.UPDATE);
        this._queryData.flush(writeOnlyGeometries);
        if (writeOnlyGeometries) {
            this._persistenceHandler.updateFeatureAttributes((Feature)current);
        }
    }

    protected void doInsert(TerralibSimpleFeature mutable) throws IOException {
        boolean writeOnlyGeometries = this._persistenceHandler != null && this._persistenceHandler.canProcess(mutable.getType().getTypeName(), TerralibAttributePersistenceHandlerTypeOperation.INSERT);
        int insertIndex = 1;
        int geometryIndex = -1;
        for (int i = 0; i < mutable.getAttributeCount(); ++i) {
            Object attributeValue = mutable.getAttribute(i);
            TypeAttributeMap type = null;
            if (attributeValue != null) {
                type = TypeAttributeMap.fromBindingClass(attributeValue.getClass());
            }
            if (type != null && type.isGeometry()) {
                geometryIndex = i;
                continue;
            }
            if (writeOnlyGeometries) continue;
            this._queryData.write(insertIndex, attributeValue);
            ++insertIndex;
        }
        if (geometryIndex == -1) {
            throw new MissingRequiredGeometryException("The geometry attribute is missing");
        }
        this._queryData.write(0, mutable.getAttribute(geometryIndex));
        if (mutable.hasSpecifiedID()) {
            this._queryData.setObjectId(mutable.getID());
        }
        this._queryData.flush(writeOnlyGeometries);
        String id = this.getFeatureId();
        mutable.setID(id);
        if (writeOnlyGeometries) {
            this._persistenceHandler.insertFeatureAttributes((Feature)mutable);
        }
    }

    public static class TerralibSimpleFeature
    extends SimpleFeatureImpl {
        boolean _hasSpecifiedID = false;

        public TerralibSimpleFeature(List<Object> values, SimpleFeatureType ft, String fid) {
            super(values, ft, (FeatureId)TerralibSimpleFeature.createDefaultFID(fid));
            this._hasSpecifiedID = fid != null;
        }

        private static FeatureIdImpl createDefaultFID(String id) {
            if (id == null) {
                id = SimpleFeatureBuilder.createDefaultFeatureId();
            }
            return new FeatureIdImpl(id){

                public void setID(String id) {
                    if (this.fid == null) {
                        throw new NullArgumentException("fid must not be null");
                    }
                    if (this.origionalFid == null) {
                        this.origionalFid = this.fid;
                    }
                    this.fid = id;
                }
            };
        }

        public void setID(String fid) {
            ((FeatureIdImpl)this.id).setID(fid);
            this._hasSpecifiedID = true;
        }

        public boolean hasSpecifiedID() {
            return this._hasSpecifiedID;
        }
    }
}

