/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.query;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.geotools.data.terralib.FeatureTypeInfo;
import org.geotools.data.terralib.TerralibService;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.exception.TerralibProviderRuntimeException;
import org.geotools.data.terralib.geometry.GeometryBuilder;
import org.geotools.data.terralib.geometry.MultiTextGeometry;
import org.geotools.data.terralib.geometry.TextGeometry;
import org.geotools.data.terralib.query.QueryData;
import org.geotools.data.terralib.query.portal.Portal;
import org.geotools.data.terralib.swig.PersistenceTransferenceObject;
import org.geotools.data.terralib.swig.TerralibServiceNative;
import org.geotools.data.terralib.util.TypeAttributeMap;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class TerralibQueryData
implements QueryData {
    private static final Logger _logger = Logger.getLogger(TerralibQueryData.class);
    private static final int NO_GEOMETRY_FIELD_FOUND = -1;
    private WriteMode _currentWriteMode = WriteMode.UPDATE;
    private TerralibService _terralibService;
    private Portal _portal;
    private List<AttributeDescriptor> _attributeDescriptors;
    private FeatureTypeInfo _featureTypeInfo;
    private int _numFields = 0;
    private Object[] _currentFieldsValues = null;
    private Object[] _writeBuffer = null;
    private int _geometryAttributeIndex = -1;
    private int _textValueAttributeIndex = -1;
    private int _angleAttributeIndex = -1;
    private boolean _closed = false;

    protected TerralibQueryData(TerralibService terralibService, Portal portal, FeatureTypeInfo featureTypeInfo) throws IOException {
        if (terralibService == null) {
            throw new NullArgumentException("terralibService");
        }
        if (portal == null) {
            throw new NullArgumentException("portal");
        }
        if (featureTypeInfo == null) {
            throw new NullArgumentException("featureTypeInfo");
        }
        this._terralibService = terralibService;
        this._portal = portal;
        this._attributeDescriptors = featureTypeInfo.getTypeAttributeList();
        this._numFields = featureTypeInfo.getTypeAttributeList().size();
        for (int i = 0; i < this._numFields; ++i) {
            if (this._attributeDescriptors.get(i) instanceof GeometryDescriptor && this._geometryAttributeIndex == -1) {
                this._geometryAttributeIndex = i;
            }
            if (this._attributeDescriptors.get(i).getLocalName().equals("textAttr__")) {
                this._textValueAttributeIndex = i;
            }
            if (!this._attributeDescriptors.get(i).getLocalName().equals("angleAttr__")) continue;
            this._angleAttributeIndex = i;
        }
        this._featureTypeInfo = featureTypeInfo;
    }

    private void readRowValues() throws IOException {
        this._currentFieldsValues = new Object[this._numFields + 1];
        this._currentFieldsValues[this._numFields] = this._portal.getString(TerralibServiceNative.getFEATURE_ID_COMPLETE_ATTRIBUTE_NAME());
        for (int i = 0; i < this._numFields; ++i) {
            Object value;
            if (i == this._geometryAttributeIndex || i == this._textValueAttributeIndex || i == this._angleAttributeIndex) continue;
            this._currentFieldsValues[i] = value = this.getAttributeValue(i);
        }
        if (this._geometryAttributeIndex != -1) {
            this._currentFieldsValues[this._geometryAttributeIndex] = this.getGeometryValue();
            if (this._currentFieldsValues[this._geometryAttributeIndex] instanceof MultiTextGeometry) {
                MultiTextGeometry multiText = (MultiTextGeometry)((Object)this._currentFieldsValues[this._geometryAttributeIndex]);
                TextGeometry text = (TextGeometry)multiText.getGeometryN(0);
                this._currentFieldsValues[this._textValueAttributeIndex] = text.getText();
                this._currentFieldsValues[this._angleAttributeIndex] = text.getAngle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Portal portal = this._portal;
        synchronized (portal) {
            this._portal.finalizePortal();
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Portal portal = this._portal;
        synchronized (portal) {
            if (this._closed) {
                return;
            }
            this._portal.close();
            this._closed = true;
        }
    }

    public int getAttributeCount() {
        return this._numFields;
    }

    public AttributeDescriptor getAttributeType(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= this._numFields || index < 0) {
            throw new ArrayIndexOutOfBoundsException("Field index should be between 0 and " + this._attributeDescriptors.size() + ". Index = " + index);
        }
        return this._attributeDescriptors.get(index);
    }

    public boolean hasNext() throws IOException {
        return this._portal.hasNext();
    }

    public void next() throws IOException {
        this._writeBuffer = null;
        if (this.hasNext()) {
            this.readRowValues();
        } else {
            this._currentFieldsValues = new Object[this._numFields + 1];
            this._currentWriteMode = WriteMode.INSERT;
        }
    }

    public Object read(int index) throws IOException, ArrayIndexOutOfBoundsException {
        if (index >= this._numFields || index < 0) {
            throw new ArrayIndexOutOfBoundsException("Field index should be between 0 and " + this._attributeDescriptors.size() + ". Index = " + index);
        }
        return this._currentFieldsValues[index];
    }

    private Object getGeometryValue() throws IOException {
        TypeAttributeMap typeMap = TypeAttributeMap.fromGeometryType(this._featureTypeInfo.getDefaultGeometryType());
        switch (typeMap) {
            case TA_MULTILINE: {
                return this._portal.fetchLine();
            }
            case TA_MULTIPOINT: {
                return this._portal.fetchPoint();
            }
            case TA_MULTIPOLYGON: {
                return this._portal.fetchPolygon();
            }
            case TA_MULITEXT: {
                return this._portal.fetchText();
            }
        }
        throw new IOException("Binding type not recognized : " + this._featureTypeInfo.getDefaultGeometryType().getBinding().getCanonicalName());
    }

    private Object getAttributeValue(int index) throws IOException {
        AttributeDescriptor attribute = this._attributeDescriptors.get(index);
        String attributeName = attribute.getLocalName();
        String attributeFullName = this._featureTypeInfo.getAttributeTableName(attributeName) + "." + attributeName;
        TypeAttributeMap typeMap = TypeAttributeMap.fromAttributeType(attribute.getType());
        switch (typeMap) {
            case TA_INTEGER: {
                return this._portal.getInt(attributeFullName);
            }
            case TA_STRING: {
                return this._portal.getString(attributeFullName);
            }
            case TA_REAL: {
                return this._portal.getDouble(attributeFullName);
            }
            case TA_DATE: {
                Date date;
                String data = this._portal.getDate(attributeFullName);
                try {
                    date = this.buildDateFormat().parse(data);
                }
                catch (ParseException e) {
                    throw new IOException("Error parsing date field (" + data + ") to Java Date.", e);
                }
                return date;
            }
        }
        throw new TerralibProviderRuntimeException("Error reading attribute value. Unsupported data type: " + (Object)((Object)typeMap));
    }

    public void write(int position, Object attribute) throws IOException {
        if (position < 0 || position >= this._numFields) {
            throw new IllegalArgumentException("The position should be in the current row's range [0," + this._numFields + ").");
        }
        if (this._writeBuffer == null) {
            assert (this._currentFieldsValues != null && this._currentFieldsValues.length == this._numFields);
            this._writeBuffer = new Object[this._numFields + 1];
        }
        this._writeBuffer[position] = attribute;
    }

    @Override
    public void flush(boolean writeOnlyGeometries) throws IOException {
        if (this._writeBuffer == null) {
            return;
        }
        Object attributeToWrite = null;
        int attributeIndex = 0;
        PersistenceTransferenceObject transferenceObject = new PersistenceTransferenceObject();
        for (AttributeDescriptor attrDesc : this._attributeDescriptors) {
            attributeToWrite = this._writeBuffer[attributeIndex];
            if (attributeToWrite != null) {
                this.setTransferenceValue(attrDesc, attributeToWrite, transferenceObject);
            }
            ++attributeIndex;
        }
        String typeName = this._featureTypeInfo.getTypeName();
        try {
            if (this._currentWriteMode == WriteMode.UPDATE) {
                this.addCurrentFeatureId(transferenceObject);
                this._terralibService.update(typeName, transferenceObject, writeOnlyGeometries);
            } else {
                if (this.getObjectId() != null) {
                    this.addCurrentFeatureId(transferenceObject);
                }
                String newFeatureId = this._terralibService.insert(typeName, transferenceObject, writeOnlyGeometries);
                this.setObjectId(newFeatureId);
            }
        }
        catch (Throwable t) {
            _logger.error((Object)("Attribute " + (Object)((Object)this._currentWriteMode) + " failed."), t);
            throw new IOException("Attribute " + (Object)((Object)this._currentWriteMode) + " failed.", t);
        }
        this.updateReadBufferFromWriteBuffer();
        this._writeBuffer = null;
    }

    private void addCurrentFeatureId(PersistenceTransferenceObject transferenceObject) {
        String featureIdCompleteAttributeName = TerralibServiceNative.getFEATURE_ID_COMPLETE_ATTRIBUTE_NAME();
        transferenceObject.setStringAttribute(featureIdCompleteAttributeName, this.getObjectId());
    }

    private void updateReadBufferFromWriteBuffer() {
        Object updatedAttribute = null;
        for (int attributeIndex = 0; attributeIndex < this._writeBuffer.length; ++attributeIndex) {
            updatedAttribute = this._writeBuffer[attributeIndex];
            if (updatedAttribute == null) continue;
            this._currentFieldsValues[attributeIndex] = updatedAttribute;
        }
    }

    private SimpleDateFormat buildDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    private void setTransferenceValue(AttributeDescriptor attributeDescription, Object attributeValue, PersistenceTransferenceObject transferenceObject) {
        Class bindingClass = attributeDescription.getType().getBinding();
        String attributeName = attributeDescription.getLocalName();
        String attributeTableName = this._featureTypeInfo.getAttributeTableName(attributeName);
        String completeAttributeName = attributeTableName + "." + attributeName;
        if (attributeTableName == "TE_TEXT_ATTRIBUTE_TABLE") {
            return;
        }
        TypeAttributeMap typeMap = TypeAttributeMap.fromAttributeType(attributeDescription.getType());
        switch (typeMap) {
            case TA_INTEGER: {
                Integer integerAttribute = attributeValue instanceof Long ? Integer.valueOf(((Long)attributeValue).intValue()) : (Integer)attributeValue;
                transferenceObject.setIntegerAttribute(completeAttributeName, integerAttribute);
                break;
            }
            case TA_REAL: {
                Double doubleAttribute = (Double)attributeValue;
                transferenceObject.setDoubleAttribute(completeAttributeName, doubleAttribute);
                break;
            }
            case TA_STRING: {
                String stringAttribute = (String)attributeValue;
                transferenceObject.setStringAttribute(completeAttributeName, stringAttribute);
                break;
            }
            case TA_DATE: {
                Date dateAttribute = (Date)attributeValue;
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                transferenceObject.setDateAttribute(completeAttributeName, format.format(dateAttribute));
                break;
            }
            case TA_MULTIPOINT: {
                MultiPoint pointGeometries = attributeValue instanceof Point ? GeometryBuilder.buildMultiPoint((Point)attributeValue) : (MultiPoint)attributeValue;
                transferenceObject.setPointGeometries(pointGeometries);
                break;
            }
            case TA_MULTILINE: {
                MultiLineString lineGeometries = attributeValue instanceof LineString ? GeometryBuilder.buildMultiLineString((LineString)attributeValue) : (MultiLineString)attributeValue;
                transferenceObject.setLineGeometries(lineGeometries);
                break;
            }
            case TA_MULTIPOLYGON: {
                MultiPolygon polygonGeometries = attributeValue instanceof Polygon ? GeometryBuilder.buildMultiPolygon((Polygon)attributeValue) : (MultiPolygon)attributeValue;
                transferenceObject.setPolygonGeometries(polygonGeometries);
                break;
            }
            case TA_MULITEXT: {
                MultiTextGeometry textGeometries;
                if (attributeValue instanceof TextGeometry) {
                    TextGeometry textGeometry = (TextGeometry)((Object)attributeValue);
                    textGeometry.setText((String)this._writeBuffer[this._textValueAttributeIndex]);
                    textGeometry.setAngle((Double)this._writeBuffer[this._angleAttributeIndex]);
                    textGeometries = new MultiTextGeometry(new TextGeometry[]{(TextGeometry)((Object)attributeValue)}, ((TextGeometry)((Object)attributeValue)).getFactory());
                } else {
                    textGeometries = (MultiTextGeometry)((Object)attributeValue);
                    for (int i = 0; i < textGeometries.getNumGeometries(); ++i) {
                        TextGeometry currentTextGeometry = (TextGeometry)textGeometries.getGeometryN(i);
                        currentTextGeometry.setText((String)this._writeBuffer[this._textValueAttributeIndex]);
                        currentTextGeometry.setAngle((Double)this._writeBuffer[this._angleAttributeIndex]);
                    }
                }
                transferenceObject.setTextGeometries(textGeometries);
                break;
            }
            default: {
                String message = "Unrecognized attribute class: \"" + bindingClass.getName() + "\".";
                _logger.error((Object)("Failed to set the transference attribute. Reason: " + message));
                throw new IllegalArgumentException(message);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this._portal.isClosed();
    }

    @Override
    public String getObjectId() {
        return (String)this._currentFieldsValues[this._numFields];
    }

    @Override
    public void setObjectId(String objectId) {
        this._currentFieldsValues[this._numFields] = objectId;
    }

    private static enum WriteMode {
        UPDATE,
        INSERT;

    }
}

