/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.query.portal;

import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.io.IOException;
import org.geotools.data.terralib.TerralibService;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.geometry.MultiTextGeometry;
import org.geotools.data.terralib.query.portal.Portal;
import org.geotools.data.terralib.swig.DatabasePortal;

public class CppPortal
implements Portal {
    private DatabasePortal _target;
    private TerralibService _terralibService;
    private String _lockUUID;
    private boolean _lockReleased;

    public CppPortal(DatabasePortal target, TerralibService service, String lockUUID) {
        if (target == null) {
            throw new NullArgumentException("target");
        }
        if (service == null) {
            throw new NullArgumentException("service");
        }
        this._target = target;
        this._terralibService = service;
        this._lockUUID = lockUUID;
        this._lockReleased = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        CppPortal cppPortal = this;
        synchronized (cppPortal) {
            this._terralibService.releaseLock(this._lockUUID);
            this._lockReleased = true;
        }
        this._target.freeResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizePortal() {
        CppPortal cppPortal = this;
        synchronized (cppPortal) {
            if (!this._lockReleased) {
                this._terralibService.releaseLock(this._lockUUID);
            }
        }
        this._target.setToFreeNativeTarget(true);
        this._target.delete();
    }

    @Override
    public MultiLineString fetchLine() throws IOException {
        return this._target.fetchLine();
    }

    @Override
    public MultiPoint fetchPoint() throws IOException {
        return this._target.fetchPoint();
    }

    @Override
    public MultiPolygon fetchPolygon() throws IOException {
        return this._target.fetchPolygon();
    }

    @Override
    public MultiTextGeometry fetchText() throws IOException {
        return this._target.fetchText();
    }

    @Override
    public String getDate(String fieldName) {
        return this._target.getDate(fieldName);
    }

    @Override
    public double getDouble(String fieldName) {
        return this._target.getDouble(fieldName);
    }

    @Override
    public int getInt(String fieldName) {
        return this._target.getInt(fieldName);
    }

    @Override
    public String getString(String fieldName) {
        return this._target.getString(fieldName);
    }

    @Override
    public boolean hasNext() {
        return this._target.hasNext();
    }

    @Override
    public boolean isClosed() {
        return this._target.isClosed();
    }
}

