/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.util;

import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.geotools.data.terralib.TerralibService;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.geometry.MultiTextGeometry;
import org.geotools.data.terralib.persistence.exception.InvalidAttributeException;
import org.geotools.data.terralib.swig.TeGeomRep;
import org.geotools.data.terralib.swig.TerralibAttributeDescriptor;
import org.geotools.data.terralib.swig.TerralibServiceNative;
import org.geotools.data.terralib.util.TypeAttributeMap;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureTypes;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class TerralibAttributeDescriptorTranslator {
    private static final String DEFAULT_GEOMETRY_POLYGON_NAME = "default_geometry_polygon";
    private static final String DEFAULT_GEOMETRY_LINE_NAME = "default_geometry_line";
    private static final String DEFAULT_GEOMETRY_POINT_NAME = "default_geometry_point";
    private static final String DEFAULT_GEOMETRY_TEXT_NAME = "default_geometry_text";
    private static final String POLYGON_TYPE_NAME = "polygon";
    private static final String LINE_TYPE_NAME = "line";
    private static final String POINT_TYPE_NAME = "point";
    private static final String TEXT_TYPE_NAME = "text";
    private static final Logger _logger = Logger.getLogger(TerralibAttributeDescriptorTranslator.class);

    public static AttributeDescriptor terralibDescriptorToGeotoolsDescriptor(AttributeTypeBuilder attributeTypeBuilder, TerralibAttributeDescriptor attribute) {
        if (attributeTypeBuilder == null) {
            throw new NullArgumentException("attributeTypeBuilder");
        }
        if (attribute == null) {
            throw new NullArgumentException("attribute");
        }
        String attributeName = attribute.getName();
        TypeAttributeMap typeMap = TypeAttributeMap.fromTeAttrDataType(attribute.getDataType());
        if (typeMap == null) {
            throw new InvalidAttributeException("The attribute binding class for \"" + attribute.getName() + "\" is not implemented at the Terralib Provider");
        }
        int length = attribute.getLength() == -1 ? TerralibServiceNative.getANY_LENGHT() : attribute.getLength();
        AttributeType attributeType = TerralibAttributeDescriptorTranslator.terralibToGeotoolsAttributeType(attributeTypeBuilder, typeMap.getBindingClass(), attribute.isPrimaryKey(), attribute.isNullable(), attributeName, length);
        int pointIndex = attributeName.indexOf(46);
        if (pointIndex != -1) {
            attributeName = attributeName.substring(pointIndex + 1);
        }
        AttributeDescriptor attributeDescriptor = attributeTypeBuilder.buildDescriptor(attributeName, attributeType);
        return attributeDescriptor;
    }

    public static TerralibAttributeDescriptor geotoolsDescriptorToTerralibDescriptor(TerralibService service, AttributeDescriptor gtDescriptor) {
        if (service == null) {
            throw new NullArgumentException("service");
        }
        if (gtDescriptor == null) {
            throw new NullArgumentException("gtDescriptor");
        }
        TypeAttributeMap typeMap = TypeAttributeMap.fromAttributeType(gtDescriptor.getType());
        if (typeMap == null) {
            throw new InvalidAttributeException("The attribute binding class for \"" + gtDescriptor.getLocalName() + "\" is not implemented at the Terralib Provider");
        }
        boolean primaryKey = gtDescriptor.getType().isIdentified();
        if (gtDescriptor.isNillable() && primaryKey) {
            throw new InvalidAttributeException("The attribute \"" + gtDescriptor.getLocalName() + "\" is a primary key, it can't accept null");
        }
        int length = typeMap.isGeometry() ? TerralibServiceNative.getANY_LENGHT() : (FeatureTypes.getFieldLength((AttributeDescriptor)gtDescriptor) == -1 ? TerralibServiceNative.getANY_LENGHT() : FeatureTypes.getFieldLength((AttributeDescriptor)gtDescriptor));
        return service.buildTerralibAttributeDescriptor(gtDescriptor.getName().getLocalPart(), gtDescriptor.isNillable(), primaryKey, length, typeMap.getTeAttributeType());
    }

    public static Set<GeometryDescriptor> buildGeometryDescriptorSet(Set<TeGeomRep> geomTypeSet, CoordinateReferenceSystem crs) {
        HashSet<GeometryDescriptor> geometryDescriptorSet = new HashSet<GeometryDescriptor>();
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
        block6: for (TeGeomRep geomRep : geomTypeSet) {
            switch (geomRep) {
                case TePOINTS: {
                    attributeTypeBuilder.setBinding(MultiPoint.class);
                    attributeTypeBuilder.setName(POINT_TYPE_NAME);
                    attributeTypeBuilder.setCRS(crs);
                    GeometryType geometryType = attributeTypeBuilder.buildGeometryType();
                    GeometryDescriptor geometryDescriptor = attributeTypeBuilder.buildDescriptor(DEFAULT_GEOMETRY_POINT_NAME, geometryType);
                    geometryDescriptorSet.add(geometryDescriptor);
                    continue block6;
                }
                case TeLINES: {
                    attributeTypeBuilder.setBinding(MultiLineString.class);
                    attributeTypeBuilder.setName(LINE_TYPE_NAME);
                    attributeTypeBuilder.setCRS(crs);
                    GeometryType geometryType = attributeTypeBuilder.buildGeometryType();
                    GeometryDescriptor geometryDescriptor = attributeTypeBuilder.buildDescriptor(DEFAULT_GEOMETRY_LINE_NAME, geometryType);
                    geometryDescriptorSet.add(geometryDescriptor);
                    continue block6;
                }
                case TePOLYGONS: {
                    attributeTypeBuilder.setBinding(MultiPolygon.class);
                    attributeTypeBuilder.setName(POLYGON_TYPE_NAME);
                    attributeTypeBuilder.setCRS(crs);
                    GeometryType geometryType = attributeTypeBuilder.buildGeometryType();
                    GeometryDescriptor geometryDescriptor = attributeTypeBuilder.buildDescriptor(DEFAULT_GEOMETRY_POLYGON_NAME, geometryType);
                    geometryDescriptorSet.add(geometryDescriptor);
                    continue block6;
                }
                case TeTEXT: {
                    attributeTypeBuilder.setBinding(MultiTextGeometry.class);
                    attributeTypeBuilder.setName(TEXT_TYPE_NAME);
                    attributeTypeBuilder.setCRS(crs);
                    GeometryType geometryType = attributeTypeBuilder.buildGeometryType();
                    GeometryDescriptor geometryDescriptor = attributeTypeBuilder.buildDescriptor(DEFAULT_GEOMETRY_TEXT_NAME, geometryType);
                    geometryDescriptorSet.add(geometryDescriptor);
                    continue block6;
                }
            }
            _logger.warn((Object)(geomRep.name() + " geometry representation is not supported."));
        }
        return geometryDescriptorSet;
    }

    protected static AttributeType terralibToGeotoolsAttributeType(AttributeTypeBuilder attributeTypeBuilder, Class<?> bindingClass, boolean isIdentifiable, boolean isNillable, String name, int length) {
        if (attributeTypeBuilder == null) {
            throw new NullArgumentException("attributeTypeBuilder");
        }
        attributeTypeBuilder.setBinding(bindingClass);
        attributeTypeBuilder.setIdentifiable(isIdentifiable);
        attributeTypeBuilder.setNillable(isNillable);
        attributeTypeBuilder.setName(name);
        attributeTypeBuilder.setLength(length);
        return attributeTypeBuilder.buildType();
    }
}

