/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.util.thread;

import org.apache.log4j.Logger;

class TerralibWatchdogTask
implements Runnable {
    private static final int MAX_STACK_LEVELS = 15;
    private long _threadId;
    private StackTraceElement[] _lockedStack;
    private StackTraceElement[] _lockerStack;
    private String _id;
    private long _lockerThreadID;
    private static Logger _logger = Logger.getLogger(TerralibWatchdogTask.class);

    public TerralibWatchdogTask(String uuid, long threadId, StackTraceElement[] lockedMethod, long lockerThreadID, StackTraceElement[] lockerMethod) {
        this._id = uuid;
        this._threadId = threadId;
        this._lockedStack = lockedMethod;
        this._lockerThreadID = lockerThreadID;
        this._lockerStack = lockerMethod;
    }

    public String getId() {
        return this._id;
    }

    @Override
    public void run() {
        StringBuilder message = new StringBuilder();
        message.append("Thread ").append(this._threadId).append(" seems to be stuck\n");
        this.printStackTrace(message, this._lockedStack);
        message.append("Last lock aquired by Thread ").append(this._lockerThreadID).append("\n");
        this.printStackTrace(message, this._lockerStack);
        _logger.warn((Object)message);
    }

    private void printStackTrace(StringBuilder message, StackTraceElement[] stackTrace) {
        int min = Math.min(2, stackTrace.length);
        int max = Math.min(15, stackTrace.length);
        for (int i = min; i < max; ++i) {
            StackTraceElement call = stackTrace[i];
            message.append("\t at ").append(call).append("\n");
        }
        if (stackTrace.length > 15) {
            message.append("\t ...").append("\n");
        }
    }

    public long getThreadId() {
        return this._threadId;
    }
}

