/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class NativeLibraryLoader {
    private static final String PROPERTIES_FILENAME = "loader.properties";
    private static final String RELEASE_DIR = "release";
    private static final String DEBUG_DIRECTORY = "debug";
    private static final String DEBUG_MODE = "debug";
    private static final String FORCE_OVERWRITE = "forceoverwrite";
    private static final String VERSION_NUMBER = "version";
    private static final Logger _logger;
    private static String _library_dir;
    private static final boolean isWindows;
    private static final boolean isLinux;
    private static final String PROVIDER_TEMP_DIR_NAME = "TerralibProviderLibraries";
    private static String _libraryExtension;
    private static String _systemTemporaryDirName;
    private static boolean _loaded;
    private static boolean _debugModeOn;
    private static boolean _forceOverwrite;
    private static String _version;

    public static synchronized boolean loadLibraries() {
        if (!_loaded) {
            if (_debugModeOn) {
                _logger.info((Object)"Using libraries in debug mode.");
                System.out.println("Using libraries in debug mode.");
            } else {
                _logger.info((Object)"Using libraries in release mode.");
                System.out.println("Using libraries in release mode.");
            }
            if (_forceOverwrite) {
                _logger.info((Object)"Forcing library overwrite.");
                System.out.println("Forcing library overwrite.");
            } else {
                _logger.info((Object)"Not forcing library overwrite.");
                System.out.println("Not forcing library overwrite.");
            }
            try {
                NativeLibraryLoader.initializeTemporaryDir();
            }
            catch (Throwable t) {
                _logger.warn((Object)"Error preparing temp dir.", t);
            }
            _logger.info((Object)("Using '" + _systemTemporaryDirName + "' as temporary dir"));
            try {
                NativeLibraryLoader.loadLibraryFromJar("zlib1");
                if (_debugModeOn) {
                    NativeLibraryLoader.loadLibraryFromJar("tiff_d");
                } else {
                    NativeLibraryLoader.loadLibraryFromJar("tiff");
                }
                NativeLibraryLoader.loadLibraryFromJar("terralib");
                NativeLibraryLoader.loadLibraryFromJar("teadodriver");
                NativeLibraryLoader.loadLibraryFromJar("terralibprovider");
                _loaded = true;
            }
            catch (Throwable t) {
                _logger.error((Object)"Error loading terralib provider dlls.", t);
                t.printStackTrace();
            }
        }
        return _loaded;
    }

    private static void initializeTemporaryDir() throws IOException {
        _systemTemporaryDirName = NativeLibraryLoader.getTemporaryDirPath();
        File file = new File(_systemTemporaryDirName);
        if (file.exists()) {
            if (file.isFile()) {
                if (!file.delete()) {
                    throw new IOException("Error trying to delete file " + _systemTemporaryDirName);
                }
            } else if (!(!file.isDirectory() || file.canRead() && file.canWrite())) {
                throw new IOException("No read/write permission on dir " + _systemTemporaryDirName);
            }
        } else if (!file.mkdirs()) {
            throw new IOException("Error trying to create dir " + _systemTemporaryDirName);
        }
    }

    private static String getTemporaryDirPath() {
        String currentTempDir = System.getProperty("java.io.tmpdir");
        if (!currentTempDir.endsWith(File.separator)) {
            currentTempDir = currentTempDir + File.separator;
        }
        return currentTempDir + PROVIDER_TEMP_DIR_NAME + File.separator + _library_dir + File.separator + _version + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileToTempDir(String libraryName, File tempLibraryFile) throws IOException {
        try {
            if (!tempLibraryFile.createNewFile()) {
                _logger.warn((Object)"Temporary file used to load libraries already exists.");
            }
        }
        catch (IOException e1) {
            throw new IOException("unable to create temporary file for " + libraryName);
        }
        InputStream in = NativeLibraryLoader.class.getResourceAsStream(NativeLibraryLoader.getLibraryResourcePath(libraryName));
        if (in == null) {
            throw new IOException("Could not find '" + libraryName + "'");
        }
        byte[] buffer = new byte[0x1000000];
        FilterOutputStream out = null;
        try {
            int readed;
            out = new BufferedOutputStream(new FileOutputStream(tempLibraryFile));
            while ((readed = in.read(buffer)) > -1) {
                ((BufferedOutputStream)out).write(buffer, 0, readed);
            }
            _logger.debug((Object)("Wrote " + tempLibraryFile));
        }
        catch (Exception e) {
            _logger.warn((Object)("Can't write to " + libraryName + ". It's probably being used by another process. Will try to load it from the existing file."), (Throwable)e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static void loadLibraryFromJar(String libraryName) {
        File tempLibraryFile = null;
        tempLibraryFile = new File(_systemTemporaryDirName + libraryName + NativeLibraryLoader.getLibraryExtension());
        if (!_forceOverwrite && tempLibraryFile.exists()) {
            _logger.info((Object)("Library " + libraryName + " already exists. It won't be copied."));
        } else {
            try {
                NativeLibraryLoader.copyFileToTempDir(libraryName, tempLibraryFile);
            }
            catch (IOException e) {
                _logger.warn((Object)("Error trying to copy '" + tempLibraryFile.getName() + "' to temp dir"), (Throwable)e);
            }
        }
        System.load(tempLibraryFile.getAbsolutePath());
    }

    private static String getLibraryResourcePath(String library) {
        return "/" + _library_dir + "/" + library + NativeLibraryLoader.getLibraryExtension();
    }

    private static String getLibraryExtension() {
        if (_libraryExtension == null) {
            if (isWindows) {
                _libraryExtension = ".dll";
            } else if (isLinux) {
                _libraryExtension = ".so";
            } else {
                throw new UnsatisfiedLinkError("unsupported O.S.");
            }
        }
        return _libraryExtension;
    }

    public static void main(String[] args) {
        if (NativeLibraryLoader.loadLibraries()) {
            System.out.println("Done...");
        } else {
            System.out.println("Error loading dlls...");
        }
        System.out.println(NativeLibraryLoader.getTemporaryDirPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String version;
        String overwrite;
        _logger = Logger.getLogger(NativeLibraryLoader.class);
        _library_dir = RELEASE_DIR;
        isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
        isLinux = System.getProperty("os.name").toLowerCase().indexOf("linux") != -1;
        _libraryExtension = null;
        _systemTemporaryDirName = null;
        _loaded = false;
        _debugModeOn = false;
        _forceOverwrite = true;
        _version = "1_0";
        Properties properties = new Properties();
        InputStream stream = null;
        stream = NativeLibraryLoader.class.getResourceAsStream("/loader.properties");
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            _logger.error((Object)"Could not open loader.properties file. Starting loader with release dlls", (Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    _logger.error((Object)"Error closing properties file input stream.", (Throwable)e);
                }
            }
        }
        String value = properties.getProperty("debug");
        if (value != null && value.equalsIgnoreCase("true")) {
            _debugModeOn = true;
            _library_dir = "debug";
        }
        if ((overwrite = properties.getProperty(FORCE_OVERWRITE)) != null && overwrite.equalsIgnoreCase("false")) {
            _forceOverwrite = false;
        }
        if ((version = properties.getProperty(VERSION_NUMBER)) != null) {
            _version = version.replace(".", "_").replace(",", "_");
        } else {
            _logger.warn((Object)"Could not find version number for the library's dlls. Using 1.0.");
        }
    }
}

