/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.LinePolygonAbstractValidation;
import org.opengis.feature.simple.SimpleFeature;

public class LineNotTouchingPolygonInteriorValidation
extends LinePolygonAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        boolean r = true;
        FeatureSource fsLine = (FeatureSource)layers.get(this.getLineTypeRef());
        if (fsLine == null) {
            return true;
        }
        FeatureCollection fcLine = fsLine.getFeatures();
        FeatureIterator fLine = fcLine.features();
        FeatureSource fsPoly = (FeatureSource)layers.get(this.getRestrictedPolygonTypeRef());
        if (fsPoly == null) {
            return true;
        }
        FeatureCollection fcPoly = fsPoly.getFeatures();
        while (fLine.hasNext()) {
            SimpleFeature line = (SimpleFeature)fLine.next();
            FeatureIterator fPoly = fcPoly.features();
            Geometry lineGeom = (Geometry)line.getDefaultGeometry();
            if (!envelope.contains(lineGeom.getEnvelopeInternal())) continue;
            if (LineString.class.isAssignableFrom(lineGeom.getClass())) {
                while (fPoly.hasNext()) {
                    SimpleFeature poly = (SimpleFeature)fPoly.next();
                    Geometry polyGeom = (Geometry)poly.getDefaultGeometry();
                    if (envelope.contains(polyGeom.getEnvelopeInternal())) {
                        if (Polygon.class.isAssignableFrom(polyGeom.getClass())) {
                            Polygon p = (Polygon)polyGeom;
                            for (int i = 0; i < p.getNumInteriorRing(); ++i) {
                                if (p.getInteriorRingN(i).touches(lineGeom)) continue;
                                results.error(poly, "Polygon interior touches the specified Line.");
                            }
                            continue;
                        }
                        fcPoly.remove((Object)poly);
                        results.warning(poly, "Invalid type: this feature is not a derivative of a Polygon");
                        continue;
                    }
                    fcPoly.remove((Object)poly);
                }
                continue;
            }
            results.warning(line, "Invalid type: this feature is not a derivative of a LineString");
        }
        return r;
    }
}

