/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2004-2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.validation.network;

import java.util.Map;

import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.graph.build.line.LineStringGraphGenerator;
import org.geotools.graph.structure.Graph;
import org.geotools.validation.DefaultIntegrityValidation;
import org.geotools.validation.ValidationResults;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;


/**
 * OrphanNodeValidation purpose.
 * 
 * <p>
 * Builds a network, and looks for orphaned nodes.
 * </p>
 *
 * @author dzwiers, Refractions Research, Inc.
 * @author $Author: dmzwiers $ (last modification)
 * @source $URL: http://svn.osgeo.org/geotools/tags/2.6-M2/modules/extension/validation/src/main/java/org/geotools/validation/network/OrphanNodeValidation.java $
 * @version $Id: OrphanNodeValidation.java 30662 2008-06-12 21:44:16Z acuster $
 */
public class OrphanNodeValidation extends DefaultIntegrityValidation {
    /** the FeatureSource<SimpleFeatureType, SimpleFeature> name datastoreId:typename */
    private String typeName;

    /**
     * StarNodeValidation constructor.
     * 
     * <p>
     * Description
     * </p>
     */
    public OrphanNodeValidation() {
        super();
    }
    
    /**
     * Implementation of getTypeRefs.
     * 
     * @see org.geotools.validation.Validation#getTypeRefs()
     * 
     */
    public String[] getTypeRefs() {
    	return new String[] {typeName};
    }

    /**
     * Check FeatureType for ...
     * 
     * <p>
     * Detailed description...
     * </p>
     *
     * @param layers Map of FeatureSource<SimpleFeatureType, SimpleFeature> by "dataStoreID:typeName"
     * @param envelope The bounding box that encloses the unvalidated data
     * @param results Used to coallate results information
     *
     * @return <code>true</code> if all the features pass this test.
     *
     * @throws Exception DOCUMENT ME!
     */
    public boolean validate(Map layers, ReferencedEnvelope envelope,
        final ValidationResults results) throws Exception {
    	
      LineStringGraphGenerator lgb = new LineStringGraphGenerator();
      FeatureSource<SimpleFeatureType, SimpleFeature> fs = (FeatureSource<SimpleFeatureType, SimpleFeature>) layers.get(typeName);
      FeatureCollection<SimpleFeatureType, SimpleFeature> fr = fs.getFeatures();
      FeatureCollection<SimpleFeatureType, SimpleFeature> fc = fr;
      FeatureIterator<SimpleFeature> f = fc.features();

      while (f.hasNext()) {
          SimpleFeature ft = f.next();

          if (envelope.contains(ft.getBounds())) {
              //lgb.add(ft);
          	lgb.add(ft.getDefaultGeometry());
          }
      }

      // lgb is loaded
      Graph g = lgb.getGraph();
			
      return(g.getNodesOfDegree(0).size() == 0);
      
    }
    
//    public boolean validate_old(Map layers, Envelope envelope,
//        final ValidationResults results) throws Exception {
//        LineGraphBuilder lgb = new LineGraphBuilder();
//        FeatureSource<SimpleFeatureType, SimpleFeature> fs = (FeatureSource<SimpleFeatureType, SimpleFeature>) layers.get(typeName);
//        FeatureResults fr = fs.getFeatures();
//        FeatureCollection<SimpleFeatureType, SimpleFeature> fc = fr.collection();
//        FeatureIterator<SimpleFeature> f = fc.features();
//
//        while (f.hasNext()) {
//            Feature ft = f.next();
//
//            if (envelope.contains(ft.getBounds())) {
//                lgb.add(ft);
//            }
//        }
//
//        // lgb is loaded
//        org.geotools.graph.structure.Graph g = lgb.build();
//
//        class OrphanVisitor implements GraphVisitor {
//            private int count = 0;
//
//            public int getCount() {
//                return count;
//            }
//
//            public int visit(GraphComponent element) {
//                if (element.getAdjacentElements().size() == 0) {
//                    count++;
//                }
//
//                results.error(element.getFeature(), "Orphaned");
//
//                return GraphTraversal.CONTINUE;
//            }
//        }
//
//        OrphanVisitor ov = new OrphanVisitor();
//        SimpleGraphWalker sgv = new SimpleGraphWalker(ov);
//        BasicGraphTraversal bgt = new BasicGraphTraversal(g, sgv);
//        bgt.walkNodes();
//
//        if (ov.getCount() == 0) {
//            return true;
//        } else {
//            return false;
//        }
//    }

    /**
     * Access typeName property.
     *
     * @return Returns the typeName.
     */
    public String getTypeName() {
        return typeName;
    }

    /**
     * Set typeName to typeName.
     *
     * @param typeName The typeName to set.
     */
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
}
