/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.geotools.data.vpf.VPFLibrary;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.data.vpf.ifc.FileConstants;
import org.geotools.feature.SchemaException;
import org.opengis.feature.simple.SimpleFeature;

public class VPFDataBase
implements FileConstants {
    private final List libraries = new Vector();

    public VPFDataBase(File directory) throws IOException, SchemaException {
        String vpfTableName = new File(directory, "lat").toString();
        VPFFile vpfTable = VPFFileFactory.getInstance().getFile(vpfTableName);
        for (SimpleFeature feature : vpfTable.readAllRows()) {
            try {
                VPFLibrary library = new VPFLibrary(feature, directory);
                this.libraries.add(library);
            }
            catch (FileNotFoundException ex) {}
        }
    }

    public List getLibraries() {
        return this.libraries;
    }

    public double getMinX() {
        VPFLibrary library;
        double result = Double.NaN;
        Iterator iter = this.libraries.iterator();
        if (iter.hasNext()) {
            library = (VPFLibrary)iter.next();
            result = library.getXmin();
        }
        while (iter.hasNext()) {
            library = (VPFLibrary)iter.next();
            result = Math.min(result, library.getXmin());
        }
        return result;
    }

    public double getMinY() {
        VPFLibrary library;
        double result = Double.NaN;
        Iterator iter = this.libraries.iterator();
        if (iter.hasNext()) {
            library = (VPFLibrary)iter.next();
            result = library.getYmin();
        }
        while (iter.hasNext()) {
            library = (VPFLibrary)iter.next();
            result = Math.min(result, library.getYmin());
        }
        return result;
    }

    public double getMaxX() {
        VPFLibrary library;
        double result = Double.NaN;
        Iterator iter = this.libraries.iterator();
        if (iter.hasNext()) {
            library = (VPFLibrary)iter.next();
            result = library.getXmax();
        }
        while (iter.hasNext()) {
            library = (VPFLibrary)iter.next();
            result = Math.max(result, library.getXmax());
        }
        return result;
    }

    public double getMaxY() {
        VPFLibrary library;
        double result = Double.NaN;
        Iterator iter = this.libraries.iterator();
        if (iter.hasNext()) {
            library = (VPFLibrary)iter.next();
            result = library.getYmax();
        }
        while (iter.hasNext()) {
            library = (VPFLibrary)iter.next();
            result = Math.max(result, library.getYmax());
        }
        return result;
    }

    public String toString() {
        return "VPF database with the following extents: \n" + this.getMinX() + " " + this.getMinY() + " - " + this.getMaxX() + " " + this.getMinY() + "\n";
    }
}

