/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.readers;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Vector;
import org.geotools.data.vpf.VPFFeatureType;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.data.vpf.ifc.FileConstants;
import org.geotools.data.vpf.io.TripletId;
import org.geotools.data.vpf.readers.VPFGeometryFactory;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;

public class AreaGeometryFactory
extends VPFGeometryFactory
implements FileConstants {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createGeometry(VPFFeatureType featureType, SimpleFeature values) throws SQLException, IOException, IllegalAttributeException {
        boolean isLeft = false;
        Coordinate previousCoordinate = null;
        Coordinate coordinate = null;
        LinkedList<Object> coordinates = null;
        Polygon result = null;
        GeometryFactory geometryFactory = new GeometryFactory();
        LinearRing outerRing = null;
        Vector<LinearRing> innerRings = new Vector<LinearRing>();
        int faceId = Integer.parseInt(values.getAttribute("fac_id").toString());
        String baseDirectory = featureType.getFeatureClass().getDirectoryName();
        String tileDirectory = baseDirectory;
        if (!new File(tileDirectory.concat(File.separator).concat("fac")).exists()) {
            Short tileId = new Short(Short.parseShort(values.getAttribute("tile_id").toString()));
            tileDirectory = tileDirectory.concat(File.separator).concat(featureType.getFeatureClass().getCoverage().getLibrary().getTileMap().get(tileId).toString()).trim();
        }
        String edgeTableName = tileDirectory.concat(File.separator).concat("edg");
        VPFFile edgeFile = VPFFileFactory.getInstance().getFile(edgeTableName);
        String faceTableName = tileDirectory.concat(File.separator).concat("fac");
        VPFFile faceFile = VPFFileFactory.getInstance().getFile(faceTableName);
        faceFile.reset();
        String ringTableName = tileDirectory.concat(File.separator).concat("rng");
        VPFFile ringFile = VPFFileFactory.getInstance().getFile(ringTableName);
        ringFile.reset();
        SimpleFeature faceFeature = faceFile.readFeature();
        while (faceFeature != null) {
            if (faceFeature.getAttribute("id").equals(new Integer(faceId))) {
                int startEdgeId;
                coordinates = new LinkedList<Object>();
                int ringId = Integer.parseInt(faceFeature.getAttribute("ring_ptr").toString());
                int nextEdgeId = startEdgeId = ((Number)ringFile.getRowFromId("id", ringId).getAttribute("start_edge")).intValue();
                int prevNodeId = -1;
                while (nextEdgeId > 0) {
                    int tempEdgeId;
                    SimpleFeature edgeRow = edgeFile.getRowFromId("id", nextEdgeId);
                    int leftFace = ((TripletId)edgeRow.getAttribute("left_face")).getId();
                    int rightFace = ((TripletId)edgeRow.getAttribute("right_face")).getId();
                    int startNode = (Integer)edgeRow.getAttribute("start_node");
                    int endNode = (Integer)edgeRow.getAttribute("end_node");
                    int leftEdge = ((TripletId)edgeRow.getAttribute("left_edge")).getId();
                    int rightEdge = ((TripletId)edgeRow.getAttribute("right_edge")).getId();
                    boolean addPoints = true;
                    if (faceId == leftFace && faceId == rightFace) {
                        addPoints = false;
                        if (prevNodeId == startNode) {
                            isLeft = false;
                            prevNodeId = endNode;
                        } else if (prevNodeId == endNode) {
                            isLeft = true;
                            prevNodeId = startNode;
                        } else {
                            if (prevNodeId != -1) throw new SQLException("This edge is not part of this face.");
                            int leftEdgeStartNode = (Integer)edgeFile.getRowFromId("id", leftEdge).getAttribute("start_node");
                            int rightEdgeStartNode = (Integer)edgeFile.getRowFromId("id", rightEdge).getAttribute("start_node");
                            if (leftEdgeStartNode == endNode) {
                                isLeft = true;
                                prevNodeId = startNode;
                            } else {
                                if (rightEdgeStartNode != endNode) throw new SQLException("This edge is not part of this face.");
                                isLeft = false;
                                prevNodeId = endNode;
                            }
                        }
                    } else if (faceId == rightFace) {
                        isLeft = false;
                        prevNodeId = endNode;
                    } else {
                        if (faceId != leftFace) throw new SQLException("This edge is not part of this face.");
                        isLeft = true;
                        prevNodeId = startNode;
                    }
                    LineString edgeGeometry = (LineString)edgeRow.getAttribute("coordinates");
                    if (addPoints) {
                        int inx;
                        if (isLeft) {
                            for (inx = edgeGeometry.getNumPoints() - 1; inx >= 0; --inx) {
                                coordinate = edgeGeometry.getCoordinateSequence().getCoordinate(inx);
                                if (previousCoordinate != null && coordinate.equals3D(previousCoordinate)) continue;
                                coordinates.add(coordinate);
                                previousCoordinate = coordinate;
                            }
                        } else {
                            for (inx = 0; inx < edgeGeometry.getNumPoints(); ++inx) {
                                coordinate = edgeGeometry.getCoordinateSequence().getCoordinate(inx);
                                if (previousCoordinate != null && coordinate.equals3D(previousCoordinate)) continue;
                                coordinates.add(coordinate);
                                previousCoordinate = coordinate;
                            }
                        }
                    } else {
                        coordinate = edgeGeometry.getCoordinateSequence().getCoordinate(isLeft ? 0 : edgeGeometry.getNumPoints() - 1);
                    }
                    int n = tempEdgeId = isLeft ? leftEdge : rightEdge;
                    if (tempEdgeId == startEdgeId) {
                        nextEdgeId = 0;
                        continue;
                    }
                    nextEdgeId = tempEdgeId;
                }
                if (!coordinate.equals(coordinates.get(0))) {
                    coordinates.add(coordinates.get(0));
                }
                Coordinate[] coordinateArray = new Coordinate[coordinates.size()];
                for (int cnx = 0; cnx < coordinates.size(); ++cnx) {
                    coordinateArray[cnx] = (Coordinate)coordinates.get(cnx);
                }
                LinearRing ring = null;
                ring = geometryFactory.createLinearRing(coordinateArray);
                if (outerRing == null) {
                    outerRing = ring;
                } else {
                    innerRings.add(ring);
                }
            }
            if (faceFile.hasNext()) {
                faceFeature = faceFile.readFeature();
                continue;
            }
            faceFeature = null;
        }
        if (innerRings.isEmpty()) {
            result = geometryFactory.createPolygon(outerRing, null);
        } else {
            LinearRing[] ringArray = new LinearRing[innerRings.size()];
            for (int cnx = 0; cnx < innerRings.size(); ++cnx) {
                ringArray[cnx] = (LinearRing)innerRings.get(cnx);
            }
            result = geometryFactory.createPolygon(outerRing, ringArray);
        }
        values.setDefaultGeometry((Object)result);
    }
}

