/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.protocol;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.geotools.data.wfs.protocol.http.HttpMethod;
import org.geotools.util.logging.Logging;
import org.geotools.wfs.protocol.ConnectionFactory;

public class DefaultConnectionFactory
implements ConnectionFactory {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs");
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final boolean tryGzip;
    private final Authenticator auth;
    private Charset encoding;
    private String authUser;
    private String authPass;
    private int timeoutMillis;

    public DefaultConnectionFactory(boolean tryGzip, String user, String pass, Charset encoding, int timeoutMillis) {
        this.tryGzip = tryGzip;
        this.authUser = user;
        this.authPass = pass;
        this.timeoutMillis = timeoutMillis;
        this.auth = user != null && pass != null ? new WFSAuthenticator(user, pass) : null;
        this.encoding = encoding;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public HttpURLConnection getConnection(URL query, HttpMethod method) throws IOException {
        return DefaultConnectionFactory.getConnection(query, this.tryGzip, method, this.auth, this.timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static HttpURLConnection getConnection(URL url, boolean tryGzip, HttpMethod method, Authenticator auth, int timeoutMillis) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (HttpMethod.POST == method) {
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-type", "text/xml, application/xml");
        } else {
            connection.setRequestMethod("GET");
        }
        connection.setDoInput(true);
        if (auth != null) {
            Class<Authenticator> clazz = Authenticator.class;
            // MONITORENTER : java.net.Authenticator.class
            Authenticator.setDefault(auth);
            connection.connect();
            // MONITOREXIT : clazz
        }
        if (tryGzip) {
            connection.addRequestProperty("Accept-Encoding", "gzip");
        }
        connection.setConnectTimeout(timeoutMillis);
        connection.setReadTimeout(timeoutMillis);
        return connection;
    }

    public InputStream getInputStream(HttpURLConnection hc) throws IOException {
        return DefaultConnectionFactory.getInputStream(hc, this.tryGzip);
    }

    public InputStream getInputStream(URL query, HttpMethod method) throws IOException {
        HttpURLConnection connection = this.getConnection(query, method);
        InputStream inputStream = this.getInputStream(connection);
        return inputStream;
    }

    private static InputStream getInputStream(HttpURLConnection hc, boolean tryGZIP) throws IOException {
        InputStream is = hc.getInputStream();
        if (tryGZIP && hc.getContentEncoding() != null && hc.getContentEncoding().indexOf("gzip") != -1) {
            is = new GZIPInputStream(is);
        }
        is = new BufferedInputStream(is);
        Logger logger = Logging.getLogger((String)"org.geotools.data.communication");
        return is;
    }

    public String getAuthPassword() {
        return this.authPass;
    }

    public String getAuthUsername() {
        return this.authUser;
    }

    public boolean isTryGzip() {
        return this.tryGzip;
    }

    private static class WFSAuthenticator
    extends Authenticator {
        private PasswordAuthentication pa;

        public WFSAuthenticator(String user, String pass) {
            this.pa = new PasswordAuthentication(user, pass.toCharArray());
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.pa;
        }
    }
}

