/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wms.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extent {
    protected String name;
    protected String defaultValue;
    protected boolean nearestValue = false;
    protected boolean multipleValues;
    protected boolean current = false;
    protected String value;

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        this.current = current;
    }

    public Extent(String name, String defaultValue, Boolean multipleValues, Boolean nearestValue, String value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Error creating Dimension: parameter name must not be null!");
        }
        this.name = name;
        this.defaultValue = defaultValue;
        this.nearestValue = nearestValue;
        this.multipleValues = multipleValues;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean getNearestValue() {
        return this.nearestValue;
    }

    public void setNearestValue(boolean nearestValue) {
        this.nearestValue = nearestValue;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isMultipleValues() {
        return this.multipleValues;
    }

    public void setMultipleValues(boolean multipleValues) {
        this.multipleValues = multipleValues;
    }

    public String toString() {
        return this.name + ": " + this.value + " (default: " + this.defaultValue + ")";
    }

    List<String> values() {
        if (this.value == null) {
            return Collections.emptyList();
        }
        if (this.multipleValues) {
            String[] split = this.value.split(",");
            return new ArrayList<String>(Arrays.asList(split));
        }
        return new ArrayList<String>(Collections.singletonList(this.value));
    }

    public boolean isEmpty() {
        return this.value != null && this.value.length() > 0;
    }
}

