/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.Layer;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.request.GetFeatureInfoRequest;
import org.geotools.data.wms.request.GetMapRequest;
import org.geotools.data.wms.response.GetFeatureInfoResponse;
import org.geotools.data.wms.response.GetMapResponse;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapLayer;
import org.geotools.ows.ServiceException;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSMapLayer
extends DefaultMapLayer {
    public static final Logger LOGGER = Logging.getLogger((String)"org.geotools.map");
    static Style STYLE;
    static GridCoverageFactory gcf;
    WMSCoverageReader reader;

    public WMSMapLayer(WebMapServer wms, Layer layer) {
        super((FeatureSource)null, null, "");
        this.reader = new WMSCoverageReader(wms, layer);
        try {
            this.featureSource = DataUtilities.source((FeatureCollection)FeatureUtilities.wrapGridCoverageReader((AbstractGridCoverage2DReader)this.reader, null));
        }
        catch (Throwable t) {
            throw new RuntimeException("Unexpected exception occurred during map layer building", t);
        }
        this.style = STYLE;
    }

    public synchronized ReferencedEnvelope getBounds() {
        return this.reader.bounds;
    }

    public String getFeatureInfoAsText(DirectPosition2D pos, int featureCount) throws IOException {
        BufferedReader br = null;
        try {
            String line;
            InputStream is = this.reader.getFeatureInfo(pos, "text/plain", featureCount, this.reader.mapRequest);
            br = new BufferedReader(new InputStreamReader(is));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw (IOException)new IOException("Failed to grab feature info").initCause(t);
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    public InputStream getFeatureInfo(DirectPosition2D pos, String infoFormat, int featureCount) throws IOException {
        return this.reader.getFeatureInfo(pos, infoFormat, featureCount, this.reader.mapRequest);
    }

    public InputStream getFeatureInfo(ReferencedEnvelope bbox, int width, int height, int x, int y, String infoFormat, int featureCount) throws IOException {
        try {
            this.reader.initMapRequest(bbox, width, height);
            AffineTransform at = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)bbox, (Rectangle)new Rectangle(width, height));
            Point2D.Double screenPos = new Point2D.Double(x, y);
            Point2D.Double worldPos = new Point2D.Double(x, y);
            at.inverseTransform(screenPos, worldPos);
            DirectPosition2D fromPos = new DirectPosition2D(((Point2D)worldPos).getX(), ((Point2D)worldPos).getY());
            DirectPosition2D toPos = new DirectPosition2D();
            MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)bbox.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)this.reader.requestCRS, (boolean)true);
            mt.transform((DirectPosition)fromPos, (DirectPosition)toPos);
            return this.reader.getFeatureInfo(toPos, infoFormat, featureCount, this.reader.mapRequest);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw (IOException)new IOException("Unexpected issue during GetFeatureInfo execution").initCause(t);
        }
    }

    public WebMapServer getWebMapServer() {
        return this.reader.wms;
    }

    public List<Layer> getWMSLayers() {
        return this.reader.layers;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.reader.getCrs();
    }

    public GetMapRequest getLastGetMap() {
        return this.reader.mapRequest;
    }

    public void addLayer(Layer layer) {
        this.reader.addLayer(layer);
    }

    public boolean isNativelySupported(CoordinateReferenceSystem crs) {
        try {
            String code = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false);
            return code != null && this.reader.validSRS.contains(code);
        }
        catch (Throwable t) {
            return false;
        }
    }

    static {
        gcf = new GridCoverageFactory();
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        RasterSymbolizer symbolizer = factory.createRasterSymbolizer();
        Rule rule = factory.createRule();
        rule.symbolizers().add(symbolizer);
        FeatureTypeStyle type = factory.createFeatureTypeStyle();
        type.rules().add(rule);
        STYLE = factory.createStyle();
        STYLE.featureTypeStyles().add(type);
    }

    static class WMSCoverageReader
    extends AbstractGridCoverage2DReader {
        WebMapServer wms;
        List<Layer> layers = new ArrayList<Layer>();
        String srsName;
        String format;
        private GetMapRequest mapRequest;
        GridCoverage2D grid;
        Set<String> validSRS;
        ReferencedEnvelope bounds;
        ReferencedEnvelope requestedEnvelope;
        int width;
        int height;
        CoordinateReferenceSystem requestCRS;

        public WMSCoverageReader(WebMapServer wms, Layer layer) {
            this.wms = wms;
            this.addLayer(layer);
            List formats = wms.getCapabilities().getRequest().getGetMap().getFormats();
            this.format = (String)formats.iterator().next();
            for (String format : formats) {
                if (!"image/png".equals(format) && !"image/png24".equals(format) && !"png".equals(format) && !"png24".equals(format)) continue;
                this.format = format;
            }
        }

        void addLayer(Layer layer) {
            this.layers.add(layer);
            if (this.srsName == null) {
                if (layer.getBoundingBoxes().size() > 0) {
                    CRSEnvelope envelope = layer.getBoundingBoxes().get(layer.getBoundingBoxes().keySet().iterator().next());
                    this.srsName = envelope.getEPSGCode();
                } else {
                    this.srsName = layer.getSrs().contains("EPSG:4326") ? "EPSG:4326" : layer.getSrs().iterator().next();
                }
                this.validSRS = layer.getSrs();
            } else {
                HashSet<String> intersection = new HashSet<String>(this.validSRS);
                intersection.retainAll(layer.getSrs());
                if (!intersection.contains(this.srsName)) {
                    if (intersection.size() == 0) {
                        throw new IllegalArgumentException("The layer being appended does not have any SRS in common with the ones already included in the WMS request, cannot be merged");
                    }
                    this.srsName = intersection.contains("EPSG:4326") ? "EPSG:4326" : (String)intersection.iterator().next();
                    this.validSRS = intersection;
                }
            }
            CoordinateReferenceSystem crs = null;
            try {
                crs = CRS.decode((String)this.srsName);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Bounds unavailable for layer" + layer);
            }
            this.crs = crs;
            this.updateBounds();
        }

        public InputStream getFeatureInfo(DirectPosition2D pos, String infoFormat, int featureCount, GetMapRequest getmap) throws IOException {
            GetFeatureInfoRequest request = this.wms.createGetFeatureInfoRequest(getmap);
            request.setFeatureCount(1);
            request.setQueryLayers(new LinkedHashSet<Layer>(this.layers));
            request.setInfoFormat(infoFormat);
            request.setFeatureCount(featureCount);
            try {
                AffineTransform tx = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)this.requestedEnvelope, (Rectangle)new Rectangle(this.width, this.height));
                Point2D.Double dest = new Point2D.Double();
                Point2D.Double src = new Point2D.Double(pos.x, pos.y);
                tx.transform(src, dest);
                request.setQueryPoint((int)((Point2D)dest).getX(), (int)((Point2D)dest).getY());
            }
            catch (Exception e) {
                throw (IOException)new IOException("Failed to grab feature info").initCause(e);
            }
            try {
                GetFeatureInfoResponse response = this.wms.issueRequest(request);
                return response.getInputStream();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                throw (IOException)new IOException("Failed to grab feature info").initCause(t);
            }
        }

        public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
            GeneralEnvelope requestedEnvelope = null;
            int width = -1;
            int height = -1;
            if (parameters != null) {
                for (GeneralParameterValue param : parameters) {
                    ReferenceIdentifier name = param.getDescriptor().getName();
                    if (!name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) continue;
                    GridGeometry2D gg = (GridGeometry2D)((ParameterValue)param).getValue();
                    requestedEnvelope = gg.getEnvelope();
                    width = gg.getGridRange().getHigh(0) + 1;
                    height = gg.getGridRange().getHigh(1) + 1;
                    break;
                }
            }
            if (requestedEnvelope == null) {
                requestedEnvelope = this.getOriginalEnvelope();
                width = 640;
                height = (int)Math.round(requestedEnvelope.getSpan(1) / requestedEnvelope.getSpan(0) * 640.0);
            }
            if (this.grid != null && this.grid.getGridGeometry().getGridRange2D().getWidth() == (double)width && this.grid.getGridGeometry().getGridRange2D().getHeight() == (double)height && this.grid.getEnvelope().equals(requestedEnvelope)) {
                return this.grid;
            }
            this.grid = this.getMap(this.reference((org.opengis.geometry.Envelope)requestedEnvelope), width, height);
            return this.grid;
        }

        GridCoverage2D getMap(ReferencedEnvelope requestedEnvelope, int width, int height) throws IOException {
            ReferencedEnvelope gridEnvelope = this.initMapRequest(requestedEnvelope, width, height);
            InputStream is = null;
            try {
                GetMapResponse response = this.wms.issueRequest(this.mapRequest);
                is = response.getInputStream();
                BufferedImage image = ImageIO.read(is);
                LOGGER.fine("GetMap completed");
                return gcf.create((CharSequence)this.layers.get(0).getTitle(), (RenderedImage)image, (org.opengis.geometry.Envelope)gridEnvelope);
            }
            catch (ServiceException e) {
                throw (IOException)new IOException("GetMap failed").initCause(e);
            }
        }

        ReferencedEnvelope initMapRequest(ReferencedEnvelope bbox, int width, int height) throws IOException {
            ReferencedEnvelope gridEnvelope = bbox;
            String requestSrs = this.srsName;
            try {
                String code = CRS.lookupIdentifier((IdentifiedObject)bbox.getCoordinateReferenceSystem(), (boolean)false);
                if (code != null && this.validSRS.contains(code)) {
                    requestSrs = code;
                } else {
                    gridEnvelope = bbox.transform(this.getCrs(), true);
                    if (gridEnvelope.getWidth() < gridEnvelope.getHeight()) {
                        height = (int)Math.round((double)width * gridEnvelope.getHeight() / gridEnvelope.getWidth());
                    } else {
                        width = (int)Math.round((double)height * gridEnvelope.getWidth() / gridEnvelope.getHeight());
                    }
                }
            }
            catch (Exception e) {
                throw (IOException)new IOException("Could not reproject the request envelope").initCause(e);
            }
            GetMapRequest mapRequest = this.wms.createGetMapRequest();
            ArrayList<Layer> reversed = new ArrayList<Layer>(this.layers);
            Collections.reverse(reversed);
            for (Layer layer : reversed) {
                mapRequest.addLayer(layer);
            }
            mapRequest.setDimensions(width, height);
            mapRequest.setFormat(this.format);
            mapRequest.setSRS(requestSrs);
            mapRequest.setBBox((BoundingBox)gridEnvelope);
            mapRequest.setTransparent(true);
            try {
                this.requestCRS = CRS.decode((String)requestSrs);
            }
            catch (Exception e) {
                throw new IOException("Could not decode request SRS " + requestSrs);
            }
            this.mapRequest = mapRequest;
            this.requestedEnvelope = gridEnvelope;
            this.width = width;
            this.height = height;
            return gridEnvelope;
        }

        public Format getFormat() {
            return null;
        }

        public void updateBounds() {
            ReferencedEnvelope result = this.reference(this.layers.get(0).getEnvelope(this.crs));
            for (int i = 1; i < this.layers.size(); ++i) {
                ReferencedEnvelope layerEnvelope = this.reference(this.layers.get(i).getEnvelope(this.crs));
                result.expandToInclude((Envelope)layerEnvelope);
            }
            this.bounds = result;
            this.originalEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)result);
        }

        ReferencedEnvelope reference(org.opengis.geometry.Envelope envelope) {
            ReferencedEnvelope env = new ReferencedEnvelope(envelope.getCoordinateReferenceSystem());
            env.expandToInclude(envelope.getMinimum(0), envelope.getMinimum(1));
            env.expandToInclude(envelope.getMaximum(0), envelope.getMaximum(1));
            return env;
        }

        ReferencedEnvelope reference(GeneralEnvelope ge) {
            return new ReferencedEnvelope(ge.getMinimum(0), ge.getMinimum(1), ge.getMaximum(0), ge.getMaximum(1), ge.getCoordinateReferenceSystem());
        }
    }
}

