/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.xsi;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.naming.OperationNotSupportedException;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeValue;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Facet;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.Type;
import org.geotools.xml.schema.impl.AttributeValueGT;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XSISimpleTypes {
    private static Map m;
    public static final URI NAMESPACE;

    private static URI makeURI(java.lang.String s) {
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static SimpleType find(java.lang.String type) {
        if (m == null) {
            XSISimpleTypes.load();
        }
        SimpleType r = (SimpleType)m.get(type);
        return r;
    }

    public static SimpleType find(Class type) {
        if (m == null) {
            XSISimpleTypes.load();
        }
        SimpleType r = (SimpleType)m.get(type);
        return r;
    }

    private static void load() {
        m = new HashMap();
        m.put(Integer.getInstance().getName(), Integer.getInstance());
        m.put(Decimal.getInstance().getName(), Decimal.getInstance());
        m.put(NegativeInteger.getInstance().getName(), NegativeInteger.getInstance());
        m.put(PositiveInteger.getInstance().getName(), PositiveInteger.getInstance());
        m.put(NonNegativeInteger.getInstance().getName(), NonNegativeInteger.getInstance());
        m.put(NonPositiveInteger.getInstance().getName(), NonPositiveInteger.getInstance());
        m.put(Long.getInstance().getName(), Long.getInstance());
        m.put(Int.getInstance().getName(), Int.getInstance());
        m.put(Short.getInstance().getName(), Short.getInstance());
        m.put(Byte.getInstance().getName(), Byte.getInstance());
        m.put(UnsignedLong.getInstance().getName(), UnsignedLong.getInstance());
        m.put(UnsignedShort.getInstance().getName(), UnsignedShort.getInstance());
        m.put(UnsignedInt.getInstance().getName(), UnsignedInt.getInstance());
        m.put(UnsignedByte.getInstance().getName(), UnsignedByte.getInstance());
        m.put(Float.getInstance().getName(), Float.getInstance());
        m.put(Double.getInstance().getName(), Double.getInstance());
        m.put(Date.getInstance().getName(), Date.getInstance());
        m.put(DateTime.getInstance().getName(), DateTime.getInstance());
        m.put(Duration.getInstance().getName(), Duration.getInstance());
        m.put(gDay.getInstance().getName(), gDay.getInstance());
        m.put(gMonth.getInstance().getName(), gMonth.getInstance());
        m.put(gMonthDay.getInstance().getName(), gMonthDay.getInstance());
        m.put(gYear.getInstance().getName(), gYear.getInstance());
        m.put(gYearMonth.getInstance().getName(), gYearMonth.getInstance());
        m.put(Time.getInstance().getName(), Time.getInstance());
        m.put(ID.getInstance().getName(), ID.getInstance());
        m.put(IDREF.getInstance().getName(), IDREF.getInstance());
        m.put(IDREFS.getInstance().getName(), IDREFS.getInstance());
        m.put(ENTITY.getInstance().getName(), ENTITY.getInstance());
        m.put(ENTITIES.getInstance().getName(), ENTITIES.getInstance());
        m.put(NMTOKEN.getInstance().getName(), NMTOKEN.getInstance());
        m.put(NMTOKENS.getInstance().getName(), NMTOKENS.getInstance());
        m.put(NOTATION.getInstance().getName(), NOTATION.getInstance());
        m.put(String.getInstance().getName(), String.getInstance());
        m.put(NormalizedString.getInstance().getName(), NormalizedString.getInstance());
        m.put(Token.getInstance().getName(), Token.getInstance());
        m.put(QName.getInstance().getName(), QName.getInstance());
        m.put(Name.getInstance().getName(), Name.getInstance());
        m.put(NCName.getInstance().getName(), NCName.getInstance());
        m.put(Boolean.getInstance().getName(), Boolean.getInstance());
        m.put(AnyURI.getInstance().getName(), AnyURI.getInstance());
        m.put(Base64Binary.getInstance().getName(), Base64Binary.getInstance());
        m.put(HexBinary.getInstance().getName(), HexBinary.getInstance());
        m.put(Language.getInstance().getName(), Language.getInstance());
        m.put(Integer.getInstance().getInstanceType(), Integer.getInstance());
        m.put(Decimal.getInstance().getInstanceType(), Decimal.getInstance());
        m.put(NegativeInteger.getInstance().getInstanceType(), NegativeInteger.getInstance());
        m.put(PositiveInteger.getInstance().getInstanceType(), PositiveInteger.getInstance());
        m.put(NonNegativeInteger.getInstance().getInstanceType(), NonNegativeInteger.getInstance());
        m.put(NonPositiveInteger.getInstance().getInstanceType(), NonPositiveInteger.getInstance());
        m.put(Long.getInstance().getInstanceType(), Long.getInstance());
        m.put(Int.getInstance().getInstanceType(), Int.getInstance());
        m.put(Short.getInstance().getInstanceType(), Short.getInstance());
        m.put(Byte.getInstance().getInstanceType(), Byte.getInstance());
        m.put(UnsignedLong.getInstance().getInstanceType(), UnsignedLong.getInstance());
        m.put(UnsignedShort.getInstance().getInstanceType(), UnsignedShort.getInstance());
        m.put(UnsignedInt.getInstance().getInstanceType(), UnsignedInt.getInstance());
        m.put(UnsignedByte.getInstance().getInstanceType(), UnsignedByte.getInstance());
        m.put(Float.getInstance().getInstanceType(), Float.getInstance());
        m.put(Double.getInstance().getInstanceType(), Double.getInstance());
        m.put(Date.getInstance().getInstanceType(), Date.getInstance());
        m.put(DateTime.getInstance().getInstanceType(), DateTime.getInstance());
        m.put(Duration.getInstance().getInstanceType(), Duration.getInstance());
        m.put(gDay.getInstance().getInstanceType(), gDay.getInstance());
        m.put(gMonth.getInstance().getInstanceType(), gMonth.getInstance());
        m.put(gMonthDay.getInstance().getInstanceType(), gMonthDay.getInstance());
        m.put(gYear.getInstance().getInstanceType(), gYear.getInstance());
        m.put(gYearMonth.getInstance().getInstanceType(), gYearMonth.getInstance());
        m.put(Time.getInstance().getInstanceType(), Time.getInstance());
        m.put(ID.getInstance().getInstanceType(), ID.getInstance());
        m.put(IDREF.getInstance().getInstanceType(), IDREF.getInstance());
        m.put(IDREFS.getInstance().getInstanceType(), IDREFS.getInstance());
        m.put(ENTITY.getInstance().getInstanceType(), ENTITY.getInstance());
        m.put(ENTITIES.getInstance().getInstanceType(), ENTITIES.getInstance());
        m.put(NMTOKEN.getInstance().getInstanceType(), NMTOKEN.getInstance());
        m.put(NMTOKENS.getInstance().getInstanceType(), NMTOKENS.getInstance());
        m.put(NOTATION.getInstance().getInstanceType(), NOTATION.getInstance());
        m.put(String.getInstance().getInstanceType(), String.getInstance());
        m.put(NormalizedString.getInstance().getInstanceType(), NormalizedString.getInstance());
        m.put(Token.getInstance().getInstanceType(), Token.getInstance());
        m.put(QName.getInstance().getInstanceType(), QName.getInstance());
        m.put(Name.getInstance().getInstanceType(), Name.getInstance());
        m.put(NCName.getInstance().getInstanceType(), NCName.getInstance());
        m.put(Boolean.getInstance().getInstanceType(), Boolean.getInstance());
        m.put(AnyURI.getInstance().getInstanceType(), AnyURI.getInstance());
        m.put(Base64Binary.getInstance().getInstanceType(), Base64Binary.getInstance());
        m.put(HexBinary.getInstance().getInstanceType(), HexBinary.getInstance());
        m.put(Language.getInstance().getInstanceType(), Language.getInstance());
    }

    static {
        NAMESPACE = XSISimpleTypes.makeURI("http://www.w3.org/2001/XMLSchema");
    }

    public static class AnyType
    extends XSISimpleType
    implements ComplexType {
        private static SimpleType instance = new AnyType();

        public static SimpleType getInstance() {
            return instance;
        }

        public boolean isAbstract() {
            return false;
        }

        public java.lang.String getAnyAttributeNameSpace() {
            return null;
        }

        public Attribute[] getAttributes() {
            return null;
        }

        public int getBlock() {
            return 0;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public boolean isMixed() {
            return false;
        }

        public boolean isDerived() {
            return false;
        }

        public boolean cache(Element element, Map hints) {
            return false;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws OperationNotSupportedException {
            if (element == null || element.getType() == null || value == null) {
                throw new OperationNotSupportedException();
            }
            if (value.length == 1 && value[0].getElement() == null) {
                return value[0].getValue();
            }
            Object[] r = new Object[value.length];
            for (int i = 0; i < r.length; ++i) {
                r[i] = value[i].getValue();
            }
            return r;
        }

        public java.lang.String getName() {
            return "AnyType";
        }

        public Class getInstanceType() {
            return null;
        }
    }

    public static class Language
    extends XSISimpleType {
        private static SimpleType instance = new Language();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "language";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                Locale i = new Locale((java.lang.String)value[0].getValue());
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return Locale.class;
        }
    }

    public static class HexBinary
    extends XSISimpleType {
        private static SimpleType instance = new HexBinary();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "hexBinary";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String i = (java.lang.String)value[0].getValue();
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String.class;
        }
    }

    public static class Base64Binary
    extends XSISimpleType {
        private static SimpleType instance = new Base64Binary();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "base64Binary";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String i = (java.lang.String)value[0].getValue();
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String.class;
        }
    }

    public static class AnyURI
    extends XSISimpleType {
        private static SimpleType instance = new AnyURI();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "anyURI";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value.length == 1 && value[0].getValue() != null) {
                try {
                    URI i = new URI((java.lang.String)value[0].getValue());
                    return i;
                }
                catch (URISyntaxException e) {
                    throw new SAXException(e);
                }
            }
            return null;
        }

        public Class getInstanceType() {
            return URI.class;
        }
    }

    public static class Boolean
    extends XSISimpleType {
        private static SimpleType instance = new Boolean();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "boolean";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String booleanValue = (java.lang.String)value[0].getValue();
                java.lang.Boolean parsedValue = "1".equals(booleanValue) ? java.lang.Boolean.TRUE : java.lang.Boolean.valueOf(booleanValue);
                return parsedValue;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Boolean.class;
        }
    }

    public static class NCName
    extends XSISimpleType {
        private static SimpleType instance = new NCName();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "NCName";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String i = (java.lang.String)value[0].getValue();
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String.class;
        }
    }

    public static class Name
    extends XSISimpleType {
        private static SimpleType instance = new Name();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "Name";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String i = (java.lang.String)value[0].getValue();
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String.class;
        }
    }

    public static class QName
    extends XSISimpleType {
        private static SimpleType instance = new QName();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "QName";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String i = (java.lang.String)value[0].getValue();
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String.class;
        }
    }

    public static class Token
    extends XSISimpleType {
        private static SimpleType instance = new Token();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "token";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String i = ((java.lang.String)value[0].getValue()).replaceAll("\\s", " ");
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String.class;
        }
    }

    public static class NormalizedString
    extends XSISimpleType {
        private static SimpleType instance = new NormalizedString();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "normalizedString";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String i = ((java.lang.String)value[0].getValue()).replaceAll("\\s", " ");
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String.class;
        }
    }

    public static class String
    extends XSISimpleType {
        private static SimpleType instance = new String();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "string";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String i = (java.lang.String)value[0].getValue();
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String.class;
        }
    }

    public static class NOTATION
    extends XSISimpleType {
        private static SimpleType instance = new NOTATION();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "NOTATION";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String i = (java.lang.String)value[0].getValue();
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String.class;
        }
    }

    public static class NMTOKENS
    extends XSISimpleType {
        private static SimpleType instance = new NMTOKENS();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "NMTOKENS";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String[] i = ((java.lang.String)value[0].getValue()).split("\\s");
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String[].class;
        }
    }

    public static class NMTOKEN
    extends XSISimpleType {
        private static SimpleType instance = new NMTOKEN();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "NMTOKEN";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String i = (java.lang.String)value[0].getValue();
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String.class;
        }
    }

    public static class ENTITIES
    extends XSISimpleType {
        private static SimpleType instance = new ENTITIES();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "ENTITIES";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String[] i = ((java.lang.String)value[0].getValue()).split("\\s");
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String[].class;
        }
    }

    public static class ENTITY
    extends XSISimpleType {
        private static SimpleType instance = new ENTITY();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "ENTITY";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String i = (java.lang.String)value[0].getValue();
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String.class;
        }
    }

    public static class IDREFS
    extends XSISimpleType {
        private static SimpleType instance = new IDREFS();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "IDREFS";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String[] i = ((java.lang.String)value[0].getValue()).split("\\s");
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String[].class;
        }
    }

    public static class IDREF
    extends XSISimpleType {
        private static SimpleType instance = new IDREF();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "IDREF";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String i = (java.lang.String)value[0].getValue();
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String.class;
        }
    }

    public static class ID
    extends XSISimpleType {
        private static SimpleType instance = new ID();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "ID";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String i = (java.lang.String)value[0].getValue();
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.String.class;
        }
    }

    public static class Time
    extends XSISimpleType {
        private static SimpleType instance = new Time();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "time";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value.length == 1 && value[0].getValue() != null) {
                TimeZone tz;
                int second;
                java.lang.String svalue = (java.lang.String)value[0].getValue();
                java.lang.String[] values = svalue.split("\\:", 3);
                if (values.length != 3) {
                    throw new SAXException("Could not parse the DateTime " + value);
                }
                int hour = java.lang.Integer.parseInt(values[0]);
                int minute = java.lang.Integer.parseInt(values[1]);
                int i = values[2].indexOf("-");
                Calendar c = null;
                if (i == -1) {
                    i = values[2].indexOf("+");
                }
                if (i == -1) {
                    second = values[2].endsWith("Z") ? (int)java.lang.Float.parseFloat(values[2].substring(0, values[2].length() - 1)) : (int)java.lang.Float.parseFloat(values[2]);
                    tz = TimeZone.getTimeZone("GMT");
                    c = Calendar.getInstance(tz);
                    c.clear();
                } else {
                    second = (int)java.lang.Float.parseFloat(values[2].substring(0, i));
                    tz = TimeZone.getTimeZone("GMT" + values[2].substring(i));
                    c = Calendar.getInstance(tz);
                    c.clear();
                }
                c.set(11, hour);
                c.set(12, minute);
                c.set(13, second);
                java.util.Date r = c.getTime();
                return r;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.util.Date.class;
        }
    }

    public static class gYearMonth
    extends XSISimpleType {
        private static SimpleType instance = new gYearMonth();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "gYearMonth";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String svalue = (java.lang.String)value[0].getValue();
                java.lang.String[] t = svalue.split("\\D*");
                Calendar c = Calendar.getInstance();
                c.clear();
                c.set(2, java.lang.Integer.parseInt(t[1]));
                c.set(1, java.lang.Integer.parseInt(t[0]));
                return c.getTime();
            }
            return null;
        }

        public Class getInstanceType() {
            return java.util.Date.class;
        }
    }

    public static class gYear
    extends XSISimpleType {
        private static SimpleType instance = new gYear();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "gYear";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String svalue = (java.lang.String)value[0].getValue();
                java.lang.String[] t = svalue.split("\\D*");
                Calendar c = Calendar.getInstance();
                c.clear();
                c.set(1, java.lang.Integer.parseInt(t[0]));
                return c.getTime();
            }
            return null;
        }

        public Class getInstanceType() {
            return java.util.Date.class;
        }
    }

    public static class gMonthDay
    extends XSISimpleType {
        private static SimpleType instance = new gMonthDay();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "gMonthDay";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String svalue = (java.lang.String)value[0].getValue();
                java.lang.String[] t = svalue.split("\\D*");
                Calendar c = Calendar.getInstance();
                c.clear();
                c.set(5, java.lang.Integer.parseInt(t[0]));
                c.set(2, java.lang.Integer.parseInt(t[1]));
                return c.getTime();
            }
            return null;
        }

        public Class getInstanceType() {
            return java.util.Date.class;
        }
    }

    public static class gMonth
    extends XSISimpleType {
        private static SimpleType instance = new gMonth();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "gMonth";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String svalue = (java.lang.String)value[0].getValue();
                svalue = svalue.split("\\D*")[0];
                Calendar c = Calendar.getInstance();
                c.clear();
                c.set(2, java.lang.Integer.parseInt(svalue));
                return c.getTime();
            }
            return null;
        }

        public Class getInstanceType() {
            return java.util.Date.class;
        }
    }

    public static class gDay
    extends XSISimpleType {
        private static SimpleType instance = new gDay();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "gDay";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String svalue = (java.lang.String)value[0].getValue();
                svalue = svalue.split("\\D*")[0];
                Calendar c = Calendar.getInstance();
                c.clear();
                c.set(5, java.lang.Integer.parseInt(svalue));
                return c.getTime();
            }
            return null;
        }

        public Class getInstanceType() {
            return java.util.Date.class;
        }
    }

    public static class Duration
    extends XSISimpleType {
        private static SimpleType instance = new Duration();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "duration";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value.length == 1 && value[0].getValue() != null) {
                int second = 0;
                int minute = 0;
                int hour = 0;
                int day = 0;
                int month = 0;
                int year = 0;
                int index = 0;
                java.lang.String svalue = (java.lang.String)value[0].getValue();
                if (svalue.indexOf("P") == 0) {
                    ++index;
                } else {
                    throw new SAXException("Malformed Duration: " + svalue);
                }
                java.lang.String[] svalues = svalue.split("\\D");
                int sindex = 0;
                if (svalues == null) {
                    return null;
                }
                if (svalue.length() < index && svalue.charAt(1 + svalues[sindex].length()) == 'Y' && sindex < svalues.length) {
                    year = java.lang.Integer.parseInt(svalues[sindex]);
                    index += svalues[sindex].length() + 1;
                    ++sindex;
                }
                if (svalue.length() < index && svalue.charAt(1 + svalues[sindex].length()) == 'M' && sindex < svalues.length) {
                    month = java.lang.Integer.parseInt(svalues[sindex]);
                    index += svalues[sindex].length() + 1;
                    ++sindex;
                }
                if (svalue.length() < index && svalue.charAt(1 + svalues[sindex].length()) == 'D' && sindex < svalues.length) {
                    day = java.lang.Integer.parseInt(svalues[sindex]);
                    index += svalues[sindex].length() + 1;
                    ++sindex;
                }
                if (svalue.length() < ++index && svalue.charAt(1 + svalues[sindex].length()) == 'H' && sindex < svalues.length) {
                    hour = java.lang.Integer.parseInt(svalues[sindex]);
                    index += svalues[sindex].length() + 1;
                    ++sindex;
                }
                if (svalue.length() < index && svalue.charAt(1 + svalues[sindex].length()) == 'M' && sindex < svalues.length) {
                    minute = java.lang.Integer.parseInt(svalues[sindex]);
                    index += svalues[0].length() + 1;
                    ++sindex;
                }
                if (svalue.length() < index && svalue.charAt(1 + svalues[sindex].length()) == 'S' && sindex < svalues.length) {
                    second = java.lang.Integer.parseInt(svalues[sindex]);
                    index += svalues[sindex].length() + 1;
                    ++sindex;
                }
                Calendar c = Calendar.getInstance();
                c.clear();
                c.set(year, month, day, hour, minute, second);
                java.util.Date r = c.getTime();
                return r;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.util.Date.class;
        }
    }

    public static class DateTime
    extends XSISimpleType {
        private static SimpleType instance = new DateTime();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "dateTime";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value.length == 1 && value[0].getValue() != null) {
                TimeZone tz;
                int second;
                java.lang.String svalue = (java.lang.String)value[0].getValue();
                java.lang.String[] values = svalue.split("T");
                if (values.length != 2) {
                    throw new SAXException("Could not parse the DateTime " + value);
                }
                java.lang.String date = values[0];
                java.lang.String time = values[1];
                values = date.split("\\-");
                if (values.length != 3) {
                    throw new SAXException("Could not parse the DateTime " + value);
                }
                int year = java.lang.Integer.parseInt(values[0]);
                int month = java.lang.Integer.parseInt(values[1]);
                int day = java.lang.Integer.parseInt(values[2]);
                values = time.split("\\:", 3);
                if (values.length != 3) {
                    throw new SAXException("Could not parse the DateTime " + value);
                }
                int hour = java.lang.Integer.parseInt(values[0]);
                int minute = java.lang.Integer.parseInt(values[1]);
                int i = values[2].indexOf("-");
                Calendar c = null;
                if (i == -1) {
                    i = values[2].indexOf("+");
                }
                if (i == -1) {
                    second = values[2].endsWith("Z") ? (int)java.lang.Float.parseFloat(values[2].substring(0, values[2].length() - 1)) : (int)java.lang.Float.parseFloat(values[2]);
                    tz = TimeZone.getTimeZone("GMT");
                    c = Calendar.getInstance(tz);
                    c.clear();
                } else {
                    second = (int)java.lang.Float.parseFloat(values[2].substring(0, i));
                    tz = TimeZone.getTimeZone("GMT" + values[2].substring(i));
                    c = Calendar.getInstance(tz);
                    c.clear();
                }
                c.set(year, month, day, hour, minute, second);
                java.util.Date r = c.getTime();
                return r;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.util.Date.class;
        }
    }

    public static class Date
    extends XSISimpleType {
        private static SimpleType instance = new Date();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "date";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.String svalue = (java.lang.String)value[0].getValue();
                java.lang.String[] values = svalue.split("\\-");
                if (values.length != 3) {
                    throw new SAXException("Could not parse the DateTime " + value);
                }
                int year = java.lang.Integer.parseInt(values[0]);
                int month = java.lang.Integer.parseInt(values[1]);
                int day = java.lang.Integer.parseInt(values[2]);
                Calendar c = Calendar.getInstance();
                c.clear();
                c.set(year, month, day);
                return c.getTime();
            }
            return null;
        }

        public Class getInstanceType() {
            return java.util.Date.class;
        }
    }

    public static class Double
    extends XSISimpleType {
        private static SimpleType instance = new Double();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "double";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.Double i = new java.lang.Double((java.lang.String)value[0].getValue());
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Double.class;
        }
    }

    public static class Float
    extends XSISimpleType {
        private static SimpleType instance = new Float();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "float";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.Float i = new java.lang.Float((java.lang.String)value[0].getValue());
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Float.class;
        }
    }

    public static class UnsignedByte
    extends XSISimpleType {
        private static SimpleType instance = new UnsignedByte();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "unsignedByte";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.Byte i = new java.lang.Byte((java.lang.String)value[0].getValue());
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Byte.class;
        }
    }

    public static class UnsignedInt
    extends XSISimpleType {
        private static SimpleType instance = new UnsignedInt();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "unsignedInt";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.Integer i = new java.lang.Integer((java.lang.String)value[0].getValue());
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Integer.class;
        }
    }

    public static class UnsignedShort
    extends XSISimpleType {
        private static SimpleType instance = new UnsignedShort();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "unsignedShort";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.Short i = new java.lang.Short((java.lang.String)value[0].getValue());
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Short.class;
        }
    }

    public static class UnsignedLong
    extends XSISimpleType {
        private static SimpleType instance = new UnsignedLong();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "unsignedLong";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.Long i = new java.lang.Long((java.lang.String)value[0].getValue());
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Long.class;
        }
    }

    public static class Byte
    extends XSISimpleType {
        private static SimpleType instance = new Byte();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "byte";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.Byte i = new java.lang.Byte((java.lang.String)value[0].getValue());
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Byte.class;
        }
    }

    public static class Short
    extends XSISimpleType {
        private static SimpleType instance = new Short();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "short";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.Short i = new java.lang.Short((java.lang.String)value[0].getValue());
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Short.class;
        }
    }

    public static class Int
    extends XSISimpleType {
        private static SimpleType instance = new Int();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "int";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.Integer i = new java.lang.Integer((java.lang.String)value[0].getValue());
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Integer.class;
        }
    }

    public static class Long
    extends XSISimpleType {
        private static SimpleType instance = new Long();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "long";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.Long i = new java.lang.Long((java.lang.String)value[0].getValue());
                return i;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Long.class;
        }
    }

    public static class NonPositiveInteger
    extends XSISimpleType {
        private static SimpleType instance = new NonPositiveInteger();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "nonPositiveInteger";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.Integer i = new java.lang.Integer((java.lang.String)value[0].getValue());
                return i <= 0 ? i : null;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Integer.class;
        }
    }

    public static class PositiveInteger
    extends XSISimpleType {
        private static SimpleType instance = new PositiveInteger();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "positiveInteger";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.Integer i = new java.lang.Integer((java.lang.String)value[0].getValue());
                return i > 0 ? i : null;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Integer.class;
        }
    }

    public static class NonNegativeInteger
    extends XSISimpleType {
        private static SimpleType instance = new NonNegativeInteger();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "nonNegativeInteger";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.Integer i = new java.lang.Integer((java.lang.String)value[0].getValue());
                return i >= 0 ? i : null;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Integer.class;
        }
    }

    public static class NegativeInteger
    extends XSISimpleType {
        private static SimpleType instance = new NegativeInteger();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "negativeInteger";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                java.lang.Integer i = new java.lang.Integer((java.lang.String)value[0].getValue());
                return i < 0 ? i : null;
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Integer.class;
        }
    }

    public static class Decimal
    extends XSISimpleType {
        private static SimpleType instance = new Decimal();

        public static SimpleType getInstance() {
            return instance;
        }

        public java.lang.String getName() {
            return "decimal";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            if (value.length == 1 && value[0].getValue() != null) {
                return new java.lang.Double((java.lang.String)value[0].getValue());
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Double.class;
        }
    }

    public static class Integer
    extends XSISimpleType {
        private static SimpleType instance = new Integer();

        public java.lang.String getName() {
            return "integer";
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrsgetValue, Map hints) {
            if (value.length >= 1 && value[0].getValue() != null) {
                return new java.lang.Integer((java.lang.String)value[0].getValue());
            }
            return null;
        }

        public Class getInstanceType() {
            return java.lang.Integer.class;
        }

        public static SimpleType getInstance() {
            return instance;
        }
    }

    protected static abstract class XSISimpleType
    implements SimpleType {
        protected XSISimpleType() {
        }

        public Element findChildElement(String name) {
            return null;
        }

        public boolean canCreateAttributes(Attribute attribute, Object value, Map hints) {
            return value != null && value.getClass().equals(this.getInstanceType()) && attribute.getSimpleType() != null && this.getClass().equals(attribute.getSimpleType().getClass());
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return value != null && value.getClass().equals(this.getInstanceType()) && element.getType() != null && this.getClass().equals(element.getType().getClass());
        }

        public AttributeValue toAttribute(Attribute attribute, Object value, Map hints) {
            return new AttributeValueGT(attribute, value.toString());
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException {
            if (element == null) {
                output.startElement(this.getNamespace(), this.getName(), null);
                output.characters(value.toString());
                output.endElement(this.getNamespace(), this.getName());
            } else {
                output.startElement(element.getNamespace(), element.getName(), null);
                output.characters(value == null ? "" : value.toString());
                output.endElement(element.getNamespace(), element.getName());
            }
        }

        public static SimpleType getInstance() {
            throw new RuntimeException("This method must be overwritten");
        }

        public Type getParent() {
            return null;
        }

        public URI getNamespace() {
            return NAMESPACE;
        }

        public int getFinal() {
            return 0;
        }

        public java.lang.String getId() {
            return null;
        }

        public int getChildType() {
            return 0;
        }

        public SimpleType[] getParents() {
            return null;
        }

        public Facet[] getFacets() {
            return null;
        }

        public Element findChildElement(java.lang.String name) {
            return null;
        }
    }
}

