/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.FilterCapabilities;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class DB2FilterToSQL
extends PreparedFilterToSQL {
    private static Logger LOGGER = Logging.getLogger((String)"org.geotools.data.db2");
    private static WKTWriter wktWriter = new WKTWriter();
    private static char SQL_WILD_MULTI = (char)37;
    private static char SQL_WILD_SINGLE = (char)95;
    private static String escapedWildcardSingle = "\\.\\?";
    private static String escapedWildcardMulti = "\\.\\*";
    private static HashMap<Class<?>, String> DB2_SPATIAL_PREDICATES = new HashMap();
    private String selectivityClause = null;
    private boolean looseBBOXEnabled = false;

    public DB2FilterToSQL(PreparedStatementSQLDialect dialect) {
        super(dialect);
        DB2_SPATIAL_PREDICATES.put(BBOX.class, "EnvelopesIntersect");
        DB2_SPATIAL_PREDICATES.put(Contains.class, "ST_Contains");
        DB2_SPATIAL_PREDICATES.put(Crosses.class, "ST_Crosses");
        DB2_SPATIAL_PREDICATES.put(Disjoint.class, "ST_Disjoint");
        DB2_SPATIAL_PREDICATES.put(Equals.class, "ST_Equals");
        DB2_SPATIAL_PREDICATES.put(Intersects.class, "ST_Intersects");
        DB2_SPATIAL_PREDICATES.put(Overlaps.class, "ST_Overlaps");
        DB2_SPATIAL_PREDICATES.put(Touches.class, "ST_Touches");
        DB2_SPATIAL_PREDICATES.put(Within.class, "ST_Within");
        DB2_SPATIAL_PREDICATES.put(DWithin.class, "ST_Distance");
        DB2_SPATIAL_PREDICATES.put(Beyond.class, "ST_Distance");
    }

    public DB2FilterToSQL(Writer out) {
        super(out);
        DB2_SPATIAL_PREDICATES.put(BBOX.class, "EnvelopesIntersect");
        DB2_SPATIAL_PREDICATES.put(Contains.class, "ST_Contains");
        DB2_SPATIAL_PREDICATES.put(Crosses.class, "ST_Crosses");
        DB2_SPATIAL_PREDICATES.put(Disjoint.class, "ST_Disjoint");
        DB2_SPATIAL_PREDICATES.put(Equals.class, "ST_Equals");
        DB2_SPATIAL_PREDICATES.put(Intersects.class, "ST_Intersects");
        DB2_SPATIAL_PREDICATES.put(Overlaps.class, "ST_Overlaps");
        DB2_SPATIAL_PREDICATES.put(Touches.class, "ST_Touches");
        DB2_SPATIAL_PREDICATES.put(Within.class, "ST_Within");
        DB2_SPATIAL_PREDICATES.put(DWithin.class, "ST_Distance");
        DB2_SPATIAL_PREDICATES.put(Beyond.class, "ST_Distance");
    }

    public HashMap getPredicateMap() {
        return DB2_SPATIAL_PREDICATES;
    }

    private static HashMap getPredicateTable() {
        return DB2_SPATIAL_PREDICATES;
    }

    public String db2Geom(Geometry geom) {
        String geomType = geom.getGeometryType();
        String g1 = geom.toText();
        String g2 = "db2gse.ST_" + geomType + "('" + g1 + "'," + this.getSRID() + ")";
        return g2;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities capabilities = new FilterCapabilities();
        capabilities.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        Iterator i = DB2FilterToSQL.getPredicateTable().keySet().iterator();
        while (i.hasNext()) {
            capabilities.addType((Class)i.next());
        }
        capabilities.addType(PropertyIsLike.class);
        capabilities.addType(Id.class);
        capabilities.addType(0x2000000L);
        capabilities.addType(0x800000L);
        capabilities.addType(0x1000000L);
        capabilities.addType(65536L);
        capabilities.addType(0x200000L);
        capabilities.addType(524288L);
        capabilities.addType(131072L);
        capabilities.addType(0x100000L);
        capabilities.addType(262144L);
        capabilities.addType(2048L);
        capabilities.addType(8192L);
        capabilities.addType(4096L);
        capabilities.addType(0x400000L);
        capabilities.addType(0x40000000L);
        capabilities.addType(Integer.MIN_VALUE);
        capabilities.addType(1L);
        capabilities.addType(128L);
        capabilities.addType(32L);
        capabilities.addType(4L);
        capabilities.addType(2L);
        capabilities.addType(8L);
        capabilities.addType(256L);
        capabilities.addType(16L);
        capabilities.addType(64L);
        capabilities.addType(1024L);
        capabilities.addType(512L);
        return capabilities;
    }

    public void setSelectivityClause(String string) {
        this.selectivityClause = string;
    }

    private void encodeDistance(BinarySpatialOperator filter, double distance, String distanceUnits, String op) throws RuntimeException {
        DefaultExpression left = (DefaultExpression)filter.getExpression1();
        DefaultExpression right = (DefaultExpression)filter.getExpression2();
        try {
            short leftType = left.getType();
            short rightType = right.getType();
            if (113 == leftType && 104 == rightType) {
                this.out.write("db2gse.ST_Distance(");
                left.accept((ExpressionVisitor)this, null);
                this.out.write(", ");
                right.accept((ExpressionVisitor)this, Geometry.class);
                if (distanceUnits != null && distanceUnits.length() != 0) {
                    this.out.write(", \"" + distanceUnits + "\"");
                }
            } else {
                String msg = "Unsupported left and right types: " + leftType + ":" + rightType;
                LOGGER.warning(msg);
                throw new RuntimeException(msg);
            }
            this.out.write(") " + op + " " + distance);
            this.addSelectivity();
        }
        catch (IOException e) {
            LOGGER.warning("Filter not generated; I/O problem of some sort" + e);
        }
    }

    public Object visit(DWithin filter, Object extraData) {
        double distance = filter.getDistance();
        String distanceUnit = filter.getDistanceUnits();
        this.encodeDistance((BinarySpatialOperator)filter, distance, distanceUnit, "<");
        return extraData;
    }

    public Object visit(Beyond filter, Object extraData) {
        double distance = filter.getDistance();
        String distanceUnit = filter.getDistanceUnits();
        this.encodeDistance((BinarySpatialOperator)filter, distance, distanceUnit, ">");
        return extraData;
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Object extraData) {
        throw new RuntimeException("SQLEncoderDB2 must implement this method in order to handle geometries");
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Object extraData, String db2Predicate) {
        LOGGER.finer("Generating GeometryFilter WHERE clause for " + filter);
        this.currentSRID = this.getSRID();
        DefaultExpression left = (DefaultExpression)filter.getExpression1();
        DefaultExpression right = (DefaultExpression)filter.getExpression2();
        if (left == null || right == null) {
            String msg = "Left or right expression is null - " + filter;
            LOGGER.warning(msg);
            throw new RuntimeException(msg);
        }
        try {
            this.out.write("db2gse." + db2Predicate + "(");
            left.accept((ExpressionVisitor)this, extraData);
            this.out.write(", ");
            right.accept((ExpressionVisitor)this, extraData);
            this.out.write(") = 1");
            this.addSelectivity();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LOGGER.fine(this.out.toString());
        return extraData;
    }

    private Object encodeBBox(BBOX filter, Object extraData) {
        LOGGER.finer("Generating EnvelopesIntersect WHERE clause for " + filter);
        try {
            Integer srid;
            String spatialColumn = filter.getPropertyName();
            if (spatialColumn == null || spatialColumn.trim().length() == 0) {
                spatialColumn = this.featureType.getGeometryDescriptor().getLocalName();
            }
            if ((srid = this.getSRID(spatialColumn)) == null) {
                throw new RuntimeException("Attribute: " + spatialColumn + " is not registered");
            }
            double minx = filter.getMinX();
            double maxx = filter.getMaxX();
            double miny = filter.getMinY();
            double maxy = filter.getMaxY();
            if (this.isLooseBBOXEnabled()) {
                this.out.write("db2gse.EnvelopesIntersect(");
                this.out.write(this.escapeName(spatialColumn));
                this.out.write(", ");
                this.out.write(String.valueOf(minx) + ", " + miny + ", " + maxx + ", " + maxy + ", " + srid);
                this.out.write(") = 1");
            } else {
                this.out.write("db2gse.st_intersects(");
                this.out.write(this.escapeName(spatialColumn));
                this.out.write(", ");
                GeometryFactory fac = new GeometryFactory();
                LinearRing linearRing = fac.createLinearRing(new Coordinate[]{new Coordinate(minx, miny), new Coordinate(maxx, miny), new Coordinate(maxx, maxy), new Coordinate(minx, maxy), new Coordinate(minx, miny)});
                Polygon poly = fac.createPolygon(linearRing, null);
                this.out.write("db2gse.st_polyfromtext('");
                WKTWriter writer = new WKTWriter();
                this.out.write(writer.write((Geometry)poly));
                this.out.write("',");
                this.out.write(srid.toString());
                this.out.write(")) = 1");
            }
            this.addSelectivity();
        }
        catch (IOException e) {
            LOGGER.warning("Filter not generated; I/O problem of some sort" + e);
        }
        return extraData;
    }

    public Object visit(BBOX filter, Object extraData) {
        return this.encodeBBox(filter, extraData);
    }

    public Object visit(Contains filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData, "ST_Contains");
    }

    public Object visit(Crosses filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData, "ST_Crosses");
    }

    public Object visit(Disjoint filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData, "ST_Disjoint");
    }

    public Object visit(Equals filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData, "ST_Equals");
    }

    public Object visit(Intersects filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData, "ST_Intersects");
    }

    public Object visit(Overlaps filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData, "ST_Overlaps");
    }

    public Object visit(Touches filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData, "ST_Touches");
    }

    public Object visit(Within filter, Object extraData) {
        return this.visitBinarySpatialOperator((BinarySpatialOperator)filter, extraData, "ST_Within");
    }

    public void visitLiteralGeometry(Literal expression) throws IOException {
        String wktRepresentation = wktWriter.write((Geometry)expression.getValue());
        int spacePos = wktRepresentation.indexOf(" ");
        String geomType = wktRepresentation.substring(0, spacePos);
        this.out.write("db2gse.ST_" + geomType + "('" + wktRepresentation + "', " + this.getSRID() + ")");
    }

    protected void addSelectivity() throws IOException {
        if (this.selectivityClause != null) {
            this.out.write(" " + this.selectivityClause);
        }
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        try {
            this.out.write("1=0");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return extraData;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        try {
            this.out.write("1=1");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return extraData;
    }

    private Integer getSRID() {
        return this.getSRID(this.featureType.getGeometryDescriptor());
    }

    private Integer getSRID(String attrName) {
        AttributeDescriptor attrDescr = this.featureType.getDescriptor(attrName);
        if (attrDescr instanceof GeometryDescriptor) {
            return this.getSRID((GeometryDescriptor)attrDescr);
        }
        return this.currentSRID;
    }

    private Integer getSRID(GeometryDescriptor gDescr) {
        Integer result = null;
        if (gDescr != null) {
            result = (Integer)gDescr.getUserData().get("nativeSRID");
        }
        if (result == null) {
            result = this.currentSRID;
        }
        return result;
    }

    public boolean isLooseBBOXEnabled() {
        return this.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.looseBBOXEnabled = looseBBOXEnabled;
    }
}

