/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import com.vividsolutions.jts.io.ByteArrayInStream;
import com.vividsolutions.jts.io.ByteOrderDataInStream;
import com.vividsolutions.jts.io.InStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.db2.DB2DialectInfo;
import org.geotools.data.db2.DB2SQLDialectPrepared;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class DB2NGDataStoreFactory
extends JDBCDataStoreFactory {
    public static String GetCurrentSchema = "select current sqlid from sysibm.sysdummy1";
    public static String GetWKBZTypes = "select db2gse.st_asbinary(db2gse.st_point(1,2,3,0)) from sysibm.sysdummy1";
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"db2");
    public static final String DriverClassName = "com.ibm.db2.jcc.DB2Driver";

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new DB2SQLDialectPrepared(dataStore, new DB2DialectInfo());
    }

    public String getDisplayName() {
        return "DB2 NG";
    }

    protected String getDriverClassName() {
        return DriverClassName;
    }

    protected String getDatabaseID() {
        return (String)DB2NGDataStoreFactory.DBTYPE.sample;
    }

    public String getDescription() {
        return "DB2 Database";
    }

    protected String getValidationQuery() {
        return "select current date from sysibm.sysdummy1";
    }

    protected boolean checkDBType(Map params) {
        if (super.checkDBType(params)) {
            return true;
        }
        if (this.checkDBType(params, "DB2")) {
            try {
                Class.forName("org.geotools.data.db2.DB2DataStoreFactory");
                return false;
            }
            catch (ClassNotFoundException e) {
                return true;
            }
        }
        return false;
    }

    protected String getJDBCUrl(Map params) throws IOException {
        String host = null;
        Integer port = null;
        try {
            host = (String)HOST.lookUp(params);
            port = (Integer)PORT.lookUp(params);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String db = (String)DATABASE.lookUp(params);
        if (host == null && port == null && db != null) {
            return "jdbc:" + this.getDatabaseID() + ":" + db;
        }
        return super.getJDBCUrl(params);
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.put(DB2NGDataStoreFactory.DBTYPE.key, DBTYPE);
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        Connection con = null;
        try {
            int geometryType;
            ResultSet rs;
            PreparedStatement ps;
            con = dataStore.getDataSource().getConnection();
            DB2DialectInfo di = ((DB2SQLDialectPrepared)dataStore.getSQLDialect()).getDb2DialectInfo();
            DatabaseMetaData md = con.getMetaData();
            di.setMajorVersion(md.getDatabaseMajorVersion());
            di.setMinorVersion(md.getDatabaseMinorVersion());
            di.setProductName(md.getDatabaseProductName());
            di.setProductVersion(md.getDatabaseProductVersion());
            if (dataStore.getDatabaseSchema() == null) {
                ps = con.prepareStatement(GetCurrentSchema);
                rs = ps.executeQuery();
                rs.next();
                dataStore.setDatabaseSchema(rs.getString(1));
                rs.close();
                ps.close();
            }
            ps = con.prepareStatement(GetWKBZTypes);
            rs = ps.executeQuery();
            rs.next();
            byte[] bytes = rs.getBytes(1);
            ByteOrderDataInStream dis = new ByteOrderDataInStream();
            dis.setInStream((InStream)new ByteArrayInStream(bytes));
            byte byteOrder = dis.readByte();
            if (byteOrder == 1) {
                dis.setOrder(2);
            }
            if ((geometryType = dis.readInt()) == 1001) {
                di.setHasOGCWkbZTyps(true);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        dataStore.closeSafe(con);
        return dataStore;
    }
}

