/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.db2;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ByteArrayInStream;
import com.vividsolutions.jts.io.ByteOrderDataInStream;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;
import org.geotools.data.db2.DB2WKBConstants;

public class DB2WKBReader {
    private static final String INVALID_GEOM_TYPE_MSG = "Invalid geometry type encountered in ";
    private GeometryFactory factory;
    private PrecisionModel precisionModel;
    private int inputDimension = 2;
    private int SRID = 0;
    private ByteOrderDataInStream dis = new ByteOrderDataInStream();
    private double[] ordValues;

    public static byte[] hexToBytes(String hex) {
        int byteLen = hex.length() / 2;
        byte[] bytes = new byte[byteLen];
        int i = 0;
        while (i < hex.length() / 2) {
            byte b;
            int i2 = 2 * i;
            if (i2 + 1 > hex.length()) {
                throw new IllegalArgumentException("Hex string has odd length");
            }
            int nib1 = DB2WKBReader.hexToInt(hex.charAt(i2));
            int nib0 = DB2WKBReader.hexToInt(hex.charAt(i2 + 1));
            bytes[i] = b = (byte)((nib1 << 4) + (byte)nib0);
            ++i;
        }
        return bytes;
    }

    private static int hexToInt(char hex) {
        int nib = Character.digit(hex, 16);
        if (nib < 0) {
            throw new IllegalArgumentException("Invalid hex digit: '" + hex + "'");
        }
        return nib;
    }

    public DB2WKBReader() {
        this(new GeometryFactory());
    }

    public DB2WKBReader(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
        this.precisionModel = this.factory.getPrecisionModel();
    }

    public Geometry read(byte[] bytes) throws ParseException {
        try {
            return this.read((InStream)new ByteArrayInStream(bytes));
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IOException caught: " + ex.getMessage());
        }
    }

    public Geometry read(InStream is) throws IOException, ParseException {
        this.dis.setInStream(is);
        Geometry g = this.readGeometry();
        this.setSRID(g);
        return g;
    }

    private Geometry readGeometry() throws IOException, ParseException {
        int geometryType;
        byte byteOrder = this.dis.readByte();
        if (byteOrder == 1) {
            this.dis.setOrder(2);
        }
        if (DB2WKBConstants.zTypes.contains(geometryType = this.dis.readInt())) {
            this.inputDimension = 3;
            if (geometryType == 3000001) {
                geometryType = 1;
            }
            if (geometryType == 1001) {
                geometryType = 1;
            }
            if (geometryType == 3000002) {
                geometryType = 2;
            }
            if (geometryType == 1002) {
                geometryType = 2;
            }
            if (geometryType == 3000005) {
                geometryType = 3;
            }
            if (geometryType == 1003) {
                geometryType = 3;
            }
            if (geometryType == 3000007) {
                geometryType = 4;
            }
            if (geometryType == 1004) {
                geometryType = 4;
            }
            if (geometryType == 3000009) {
                geometryType = 5;
            }
            if (geometryType == 1005) {
                geometryType = 5;
            }
            if (geometryType == 3000011) {
                geometryType = 6;
            }
            if (geometryType == 1006) {
                geometryType = 6;
            }
            if (geometryType == 3000012) {
                geometryType = 7;
            }
            if (geometryType == 1007) {
                geometryType = 7;
            }
        }
        if (this.ordValues == null || this.ordValues.length < this.inputDimension) {
            this.ordValues = new double[this.inputDimension];
        }
        switch (geometryType) {
            case 1: {
                return this.readPoint();
            }
            case 2: {
                return this.readLineString();
            }
            case 3: {
                return this.readPolygon();
            }
            case 4: {
                return this.readMultiPoint();
            }
            case 5: {
                return this.readMultiLineString();
            }
            case 6: {
                return this.readMultiPolygon();
            }
            case 7: {
                return this.readGeometryCollection();
            }
        }
        throw new ParseException("Unknown WKB type " + geometryType);
    }

    private Geometry setSRID(Geometry g) {
        if (this.SRID != 0) {
            g.setSRID(this.SRID);
        }
        return g;
    }

    private Point readPoint() throws IOException {
        CoordinateSequence pts = this.readCoordinateSequence(1);
        return this.factory.createPoint(pts);
    }

    private LineString readLineString() throws IOException {
        int size = this.dis.readInt();
        CoordinateSequence pts = this.readCoordinateSequence(size);
        return this.factory.createLineString(pts);
    }

    private LinearRing readLinearRing() throws IOException {
        int size = this.dis.readInt();
        CoordinateSequence pts = this.readCoordinateSequence(size);
        return this.factory.createLinearRing(pts);
    }

    private Polygon readPolygon() throws IOException {
        int numRings = this.dis.readInt();
        LinearRing[] holes = null;
        if (numRings > 1) {
            holes = new LinearRing[numRings - 1];
        }
        LinearRing shell = this.readLinearRing();
        int i = 0;
        while (i < numRings - 1) {
            holes[i] = this.readLinearRing();
            ++i;
        }
        return this.factory.createPolygon(shell, holes);
    }

    private MultiPoint readMultiPoint() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Point[] geoms = new Point[numGeom];
        int i = 0;
        while (i < numGeom) {
            Geometry g = this.readGeometry();
            if (!(g instanceof Point)) {
                throw new ParseException("Invalid geometry type encountered in MultiPoint");
            }
            geoms[i] = (Point)g;
            ++i;
        }
        return this.factory.createMultiPoint(geoms);
    }

    private MultiLineString readMultiLineString() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        LineString[] geoms = new LineString[numGeom];
        int i = 0;
        while (i < numGeom) {
            Geometry g = this.readGeometry();
            if (!(g instanceof LineString)) {
                throw new ParseException("Invalid geometry type encountered in MultiLineString");
            }
            geoms[i] = (LineString)g;
            ++i;
        }
        return this.factory.createMultiLineString(geoms);
    }

    private MultiPolygon readMultiPolygon() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Polygon[] geoms = new Polygon[numGeom];
        int i = 0;
        while (i < numGeom) {
            Geometry g = this.readGeometry();
            if (!(g instanceof Polygon)) {
                throw new ParseException("Invalid geometry type encountered in MultiPolygon");
            }
            geoms[i] = (Polygon)g;
            ++i;
        }
        return this.factory.createMultiPolygon(geoms);
    }

    private GeometryCollection readGeometryCollection() throws IOException, ParseException {
        int numGeom = this.dis.readInt();
        Geometry[] geoms = new Geometry[numGeom];
        int i = 0;
        while (i < numGeom) {
            geoms[i] = this.readGeometry();
            ++i;
        }
        return this.factory.createGeometryCollection(geoms);
    }

    private CoordinateSequence readCoordinateSequence(int size) throws IOException {
        CoordinateSequence seq = this.factory.getCoordinateSequenceFactory().create(size, this.inputDimension);
        int targetDim = seq.getDimension();
        if (targetDim > this.inputDimension) {
            targetDim = this.inputDimension;
        }
        int i = 0;
        while (i < size) {
            this.readCoordinate();
            int j = 0;
            while (j < targetDim) {
                seq.setOrdinate(i, j, this.ordValues[j]);
                ++j;
            }
            ++i;
        }
        return seq;
    }

    private void readCoordinate() throws IOException {
        int i = 0;
        while (i < this.inputDimension) {
            this.ordValues[i] = i <= 1 ? this.precisionModel.makePrecise(this.dis.readDouble()) : this.dis.readDouble();
            ++i;
        }
    }
}

