/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geotools.data.DataSourceException;
import org.geotools.data.postgis.Base64;

public class WKBAttributeIO {
    WKBReader wkbr;
    ByteArrayInStream inStream = new ByteArrayInStream();

    public WKBAttributeIO() {
        this.wkbr = new WKBReader();
    }

    public WKBAttributeIO(GeometryFactory gf) {
        this.wkbr = new WKBReader(gf);
    }

    private Geometry wkb2Geometry(byte[] wkbBytes) throws IOException {
        if (wkbBytes == null) {
            return null;
        }
        try {
            this.inStream.setBytes(wkbBytes);
            return this.wkbr.read((InStream)this.inStream);
        }
        catch (Exception e) {
            throw new DataSourceException("An exception occurred while parsing WKB data", (Throwable)e);
        }
    }

    public Object read(ResultSet rs, String columnName) throws IOException {
        try {
            byte[] bytes = rs.getBytes(columnName);
            if (bytes == null) {
                return null;
            }
            return this.wkb2Geometry(Base64.decode(bytes));
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", (Throwable)e);
        }
    }

    public Object read(ResultSet rs, int columnIndex) throws IOException {
        try {
            byte[] bytes = rs.getBytes(columnIndex);
            if (bytes == null) {
                return null;
            }
            return this.wkb2Geometry(Base64.decode(bytes));
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", (Throwable)e);
        }
    }

    public void write(PreparedStatement ps, int position, Object value) throws IOException {
        try {
            if (value == null) {
                ps.setNull(position, 1111);
            } else {
                ps.setBytes(position, new WKBWriter().write((Geometry)value));
            }
        }
        catch (SQLException e) {
            throw new DataSourceException("SQL exception occurred while reading the geometry.", (Throwable)e);
        }
    }

    public static byte getFromChar(char c) {
        if (c <= '9') {
            return (byte)(c - 48);
        }
        if (c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        return (byte)(c - 97 + 10);
    }

    private byte[] hexToBytes(String wkb) {
        byte[] wkbBytes = new byte[wkb.length() / 2];
        for (int i = 0; i < wkbBytes.length; ++i) {
            byte b1 = WKBAttributeIO.getFromChar(wkb.charAt(i * 2));
            byte b2 = WKBAttributeIO.getFromChar(wkb.charAt(i * 2 + 1));
            wkbBytes[i] = (byte)(b1 << 4 | b2);
        }
        return wkbBytes;
    }

    private static class ByteArrayInStream
    implements InStream {
        byte[] buffer;
        int position;

        private ByteArrayInStream() {
        }

        public void setBytes(byte[] buffer) {
            this.buffer = buffer;
            this.position = 0;
        }

        public void read(byte[] buf) throws IOException {
            int size = buf.length;
            System.arraycopy(this.buffer, this.position, buf, 0, size);
            this.position += size;
        }
    }
}

