/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.spatialite;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.spatialite.SpatiaLiteDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class SpatiaLiteDataStoreFactory
extends JDBCDataStoreFactory {
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"spatialite");
    public static final DataAccessFactory.Param USER = new DataAccessFactory.Param(JDBCDataStoreFactory.USER.key, JDBCDataStoreFactory.USER.type, JDBCDataStoreFactory.USER.description, false, JDBCDataStoreFactory.USER.sample);

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new SpatiaLiteDialect(dataStore);
    }

    protected String getDatabaseID() {
        return "spatialite";
    }

    protected String getDriverClassName() {
        return "org.sqlite.JDBC";
    }

    public String getDescription() {
        return "SpatiaLite";
    }

    protected String getValidationQuery() {
        return null;
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.remove(SpatiaLiteDataStoreFactory.HOST.key);
        parameters.remove(SpatiaLiteDataStoreFactory.PORT.key);
        parameters.remove(JDBCDataStoreFactory.USER.key);
        parameters.put(SpatiaLiteDataStoreFactory.USER.key, USER);
        parameters.put(SpatiaLiteDataStoreFactory.DBTYPE.key, DBTYPE);
    }

    protected String getJDBCUrl(Map params) throws IOException {
        String db = (String)DATABASE.lookUp(params);
        return "jdbc:sqlite:" + db;
    }

    public BasicDataSource createDataSource(Map params) throws IOException {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(this.getDriverClassName());
        dataSource.setUrl(this.getJDBCUrl(params));
        dataSource.addConnectionProperty("enable_load_extension", "true");
        dataSource.addConnectionProperty("shared_cache", "yes");
        return dataSource;
    }
}

