/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sqlserver;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import java.io.IOException;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.filter.FilterCapabilities;
import org.geotools.jdbc.SQLDialect;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class SQLServerFilterToSQL
extends FilterToSQL {
    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = super.createFilterCapabilities();
        caps.addAll(SQLDialect.BASE_DBMS_CAPABILITIES);
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        return caps;
    }

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        Geometry g = (Geometry)this.evaluateLiteral(expression, Geometry.class);
        if (g instanceof LinearRing) {
            g = g.getFactory().createLineString(((LinearRing)g).getCoordinateSequence());
        }
        this.out.write("geometry::STGeomFromText('" + g.toText() + "', " + this.currentSRID + ")");
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        try {
            if (!(filter instanceof Disjoint)) {
                property.accept((ExpressionVisitor)this, extraData);
                this.out.write(".Filter(");
                geometry.accept((ExpressionVisitor)this, extraData);
                this.out.write(") = 1");
                if (!(filter instanceof BBOX)) {
                    this.out.write(" AND ");
                }
            }
            if (filter instanceof BBOX) {
                return extraData;
            }
            if (filter instanceof DistanceBufferOperator) {
                property.accept((ExpressionVisitor)this, extraData);
                this.out.write(".STDistance(");
                geometry.accept((ExpressionVisitor)this, extraData);
                this.out.write(")");
                if (filter instanceof DWithin) {
                    this.out.write("<");
                } else if (filter instanceof Beyond) {
                    this.out.write(">");
                } else {
                    throw new RuntimeException("Unknown distance operator.");
                }
                this.out.write(Double.toString(((DistanceBufferOperator)filter).getDistance()));
            } else {
                if (swapped) {
                    geometry.accept((ExpressionVisitor)this, extraData);
                } else {
                    property.accept((ExpressionVisitor)this, extraData);
                }
                if (filter instanceof Contains) {
                    this.out.write(".STContains(");
                } else if (filter instanceof Crosses) {
                    this.out.write(".STCrosses(");
                } else if (filter instanceof Disjoint) {
                    this.out.write(".STDisjoint(");
                } else if (filter instanceof Equals) {
                    this.out.write(".STEquals(");
                } else if (filter instanceof Intersects) {
                    this.out.write(".STIntersects(");
                } else if (filter instanceof Overlaps) {
                    this.out.write(".STOverlaps(");
                } else if (filter instanceof Touches) {
                    this.out.write(".STTouches(");
                } else if (filter instanceof Within) {
                    this.out.write(".STWithin(");
                } else {
                    throw new RuntimeException("Unknown operator: " + filter);
                }
                if (swapped) {
                    property.accept((ExpressionVisitor)this, extraData);
                } else {
                    geometry.accept((ExpressionVisitor)this, extraData);
                }
                this.out.write(") = 1");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extraData;
    }
}

