/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sqlserver;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.util.Map;
import java.util.UUID;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.sqlserver.SQLServerFilterToSQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServerDialect
extends BasicSQLDialect {
    public SQLServerDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        return !"INFORMATION_SCHEMA".equals(schemaName) && !"sys".equals(schemaName);
    }

    public String getGeometryTypeName(Integer type) {
        return "geometry";
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Date.class, 93);
        mappings.put(Time.class, 93);
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("geometry", Geometry.class);
        mappings.put("uniqueidentifier", UUID.class);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        super.registerSqlTypeToSqlTypeNameOverrides(overrides);
        overrides.put(12, "varchar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        Statement st = cx.createStatement();
        try {
            for (AttributeDescriptor ad : featureType.getAttributeDescriptors()) {
                CoordinateReferenceSystem crs;
                CoordinateSystem cs;
                if (!(ad instanceof GeometryDescriptor)) continue;
                String bbox = null;
                GeometryDescriptor gd = (GeometryDescriptor)ad;
                if (gd.getCoordinateReferenceSystem() != null && (cs = (crs = gd.getCoordinateReferenceSystem()).getCoordinateSystem()).getDimension() == 2) {
                    bbox = "(" + cs.getAxis(0).getMinimumValue() + ", " + cs.getAxis(1).getMinimumValue();
                    bbox = bbox + ", " + cs.getAxis(0).getMaximumValue() + ", " + cs.getAxis(1).getMaximumValue() + ")";
                }
                if (bbox == null) continue;
                StringBuffer sql = new StringBuffer("CREATE SPATIAL INDEX ");
                this.encodeTableName(featureType.getTypeName() + "_" + gd.getLocalName() + "_index", sql);
                sql.append(" ON ");
                this.encodeTableName(featureType.getTypeName(), sql);
                sql.append("(");
                this.encodeColumnName(gd.getLocalName(), sql);
                sql.append(")");
                sql.append(" WITH ( BOUNDING_BOX = ").append(bbox).append(")");
                LOGGER.fine(sql.toString());
                st.execute(sql.toString());
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT TOP 1 ");
        this.encodeColumnName(columnName, sql);
        sql.append(".STSrid");
        sql.append(" FROM ");
        this.encodeTableName(schemaName, tableName, sql, true);
        sql.append(" WHERE ");
        this.encodeColumnName(columnName, sql);
        sql.append(" IS NOT NULL");
        this.dataStore.getLogger().fine(sql.toString());
        Statement st = cx.createStatement();
        try {
            ResultSet rs;
            block8: {
                Integer n;
                rs = st.executeQuery(sql.toString());
                try {
                    if (!rs.next()) break block8;
                    n = rs.getInt(1);
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(rs);
                    throw throwable;
                }
                this.dataStore.closeSafe(rs);
                return n;
            }
            Integer n = 0;
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, int srid, StringBuffer sql) {
        this.encodeColumnName(gatt.getLocalName(), sql);
        sql.append(".STAsBinary()");
    }

    public void encodeGeometryValue(Geometry value, int srid, StringBuffer sql) throws IOException {
        if (value == null) {
            sql.append("NULL");
            return;
        }
        sql.append("geometry::STGeomFromText('").append(value.toText()).append("',").append(srid).append(")");
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        byte[] bytes = rs.getBytes(column);
        if (bytes == null) {
            return null;
        }
        try {
            return new WKBReader(factory).read(bytes);
        }
        catch (ParseException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    Geometry decodeGeometry(String s, GeometryFactory factory) throws IOException {
        CoordinateReferenceSystem crs;
        if (s == null) {
            return null;
        }
        if (factory == null) {
            factory = new GeometryFactory();
        }
        String[] split = s.split(":");
        String srid = split[0];
        Geometry g = null;
        try {
            g = new WKTReader(factory).read(split[1]);
        }
        catch (ParseException e) {
            throw (IOException)new IOException().initCause(e);
        }
        try {
            crs = CRS.decode((String)("EPSG:" + srid));
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
        g.setUserData((Object)crs);
        return g;
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("CAST(");
        this.encodeColumnName(geometryColumn, sql);
        sql.append(".STSrid as VARCHAR)");
        sql.append(" + ':' + ");
        this.encodeColumnName(geometryColumn, sql);
        sql.append(".STEnvelope().ToString()");
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        String s = rs.getString(column);
        Geometry g = this.decodeGeometry(s, null);
        if (g == null) {
            return null;
        }
        return new ReferencedEnvelope(g.getEnvelopeInternal(), (CoordinateReferenceSystem)g.getUserData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT");
        sql.append(" IDENT_CURRENT('");
        this.encodeTableName(schemaName, tableName, sql, false);
        sql.append("')");
        sql.append(" + ");
        sql.append(" IDENT_INCR('");
        this.encodeTableName(schemaName, tableName, sql, false);
        sql.append("')");
        this.dataStore.getLogger().fine(sql.toString());
        Statement st = cx.createStatement();
        try {
            Integer n;
            ResultSet rs = st.executeQuery(sql.toString());
            try {
                rs.next();
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(rs);
                throw throwable;
            }
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public FilterToSQL createFilterToSQL() {
        return new SQLServerFilterToSQL();
    }

    protected void encodeTableName(String schemaName, String tableName, StringBuffer sql, boolean escape) {
        if (schemaName != null) {
            if (escape) {
                this.encodeSchemaName(schemaName, sql);
            } else {
                sql.append(schemaName);
            }
            sql.append(".");
        }
        if (escape) {
            this.encodeTableName(tableName, sql);
        } else {
            sql.append(tableName);
        }
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        CharSequence orderBy;
        int lastClosed = sql.lastIndexOf(")");
        int orderByIndex = sql.lastIndexOf("ORDER BY");
        if (orderByIndex > 0 && orderByIndex > lastClosed) {
            orderBy = sql.subSequence(orderByIndex, sql.length());
            sql.delete(orderByIndex, orderByIndex + orderBy.length());
        } else {
            orderBy = "ORDER BY CURRENT_TIMESTAMP";
        }
        int fromStart = sql.indexOf("FROM");
        sql.insert(fromStart - 1, ", ROW_NUMBER() OVER (" + orderBy + ") AS _GT_ROW_NUMBER ");
        sql.insert(0, "SELECT * FROM (");
        sql.append(") AS _GT_PAGING_SUBQUERY WHERE ");
        if (offset > 0) {
            sql.append("_GT_ROW_NUMBER > " + offset);
        }
        if (limit >= 0 && limit < Integer.MAX_VALUE) {
            int max = limit;
            if (offset > 0) {
                max += offset;
                sql.append(" AND ");
            }
            sql.append("_GT_ROW_NUMBER <= " + max);
        }
    }

    public void encodeValue(Object value, Class type, StringBuffer sql) {
        if (byte[].class.equals((Object)type)) {
            byte[] b = (byte[])value;
            sql.append("0x");
            for (int i = 0; i < b.length; ++i) {
                sql.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
            }
        } else {
            super.encodeValue(value, type, sql);
        }
    }
}

