/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven.taglet;

import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Source
implements Taglet {
    static final char SVN_KEYWORD_DELIMITER = '$';
    public static final String SVN_REPO_URL = "http://svn.osgeo.org/geotools/";
    final Pattern findURL = Pattern.compile("\\s*(\\$URL\\s*\\:)?\\s*(.+?)\\s*(\\$\\s*)?");
    static final int URL_CAPTURE_GROUP = 2;
    final Pattern findModule = Pattern.compile("https?\\Q://\\E[a-zA-Z\\.\\-]+\\/geotools\\/[a-z]+(\\/[a-zA-Z0-9\\-\\_\\.]+)?\\/(((modules)\\/(library|plugin|extension|unsupported))|demo)\\/(.+)\\/src.*");

    public static void register(Map<String, Taglet> tagletMap) {
        Source tag = new Source();
        tagletMap.put(tag.getName(), tag);
    }

    Source() {
    }

    public String getName() {
        return "source";
    }

    public boolean inOverview() {
        return true;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inType() {
        return true;
    }

    public boolean inConstructor() {
        return true;
    }

    public boolean inMethod() {
        return true;
    }

    public boolean inField() {
        return true;
    }

    public boolean isInlineTag() {
        return false;
    }

    public String toString(Tag tag) {
        return this.toString(new Tag[]{tag});
    }

    public String toString(Tag[] tags) {
        String category;
        String group;
        if (tags == null || tags.length != 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n<DT><B>Module:</B></DT>");
        String tagText = tags[0].text();
        Matcher matchURL = this.findURL.matcher(tagText);
        if (!matchURL.matches()) {
            return "";
        }
        String url = matchURL.group(2).trim();
        Matcher matchModule = this.findModule.matcher(url);
        if (!matchModule.matches()) {
            return "";
        }
        String modulePath = matchModule.group(6);
        int pos = modulePath.indexOf(47);
        String module = pos == -1 ? modulePath : modulePath.substring(pos + 1);
        if (matchModule.group(2).equals("demo")) {
            group = matchModule.group(2);
            category = null;
        } else {
            group = matchModule.group(4);
            category = matchModule.group(5);
        }
        sb.append("\n<DD><CODE><B>");
        sb.append(group).append('/');
        if (category != null) {
            sb.append(category).append('/');
        }
        sb.append(module);
        sb.append(" (gt-").append(module).append(".jar)");
        sb.append("</B></CODE>");
        sb.append("</DD>\n");
        sb.append("\n<DT><B>Source repository:</B></DT>").append('\n');
        sb.append("<DD>   <CODE>").append(url).append("</CODE></DD>\n");
        return sb.toString();
    }
}

