/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.Font;
import org.geotools.styling.StyleFactory;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.picocontainer.MutablePicoContainer;

public class SLDFontBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;
    FilterFactory filterFactory;

    public SLDFontBinding(StyleFactory styleFactory, FilterFactory filterFactory) {
        this.styleFactory = styleFactory;
        this.filterFactory = filterFactory;
    }

    public QName getTarget() {
        return SLD.FONT;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return Font.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        ArrayList<Expression> family = new ArrayList<Expression>();
        Expression style = null;
        Expression weight = null;
        Expression size = null;
        for (CssParameter css : node.getChildValues(CssParameter.class)) {
            Expression exp = css.getExpression();
            if (exp == null) continue;
            if ("font-family".equals(css.getName())) {
                family.add(exp);
            }
            if ("font-style".equals(css.getName())) {
                style = exp;
            }
            if ("font-weight".equals(css.getName())) {
                weight = exp;
            }
            if (!"font-size".equals(css.getName())) continue;
            size = exp;
        }
        return this.styleFactory.font(family, style, weight, size);
    }
}

