/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wcs.bindings;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.gml.DirectPositionType;
import net.opengis.gml.EnvelopeType;
import net.opengis.gml.Gml4wcsFactory;
import net.opengis.wcs10.SpatialSubsetType;
import net.opengis.wcs10.Wcs10Factory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.wcs.WCS;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.referencing.IdentifiedObject;

public class SpatialSubsetTypeBinding
extends AbstractComplexBinding {
    public QName getTarget() {
        return WCS.SpatialSubsetType;
    }

    public Class getType() {
        return SpatialSubsetType.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        SpatialSubsetType spatialSubset = Wcs10Factory.eINSTANCE.createSpatialSubsetType();
        List envelopes = node.getChildren("Envelope");
        for (Node envelopeNode : envelopes) {
            ReferencedEnvelope envelope = (ReferencedEnvelope)envelopeNode.getValue();
            EnvelopeType env = Gml4wcsFactory.eINSTANCE.createEnvelopeType();
            env.setSrsName(CRS.lookupIdentifier((IdentifiedObject)envelope.getCoordinateReferenceSystem(), (boolean)true));
            DirectPositionType pos1 = Gml4wcsFactory.eINSTANCE.createDirectPositionType();
            DirectPositionType pos2 = Gml4wcsFactory.eINSTANCE.createDirectPositionType();
            pos1.setDimension(BigInteger.valueOf(2L));
            pos2.setDimension(BigInteger.valueOf(2L));
            pos1.setValue(Arrays.asList(envelope.getMinX(), envelope.getMinY()));
            pos2.setValue(Arrays.asList(envelope.getMaxX(), envelope.getMaxY()));
            env.getPos().add((Object)pos1);
            env.getPos().add((Object)pos2);
            spatialSubset.getEnvelope().add((Object)envelope);
        }
        List gridsNode = node.getChildren("Grid");
        for (Node grid : gridsNode) {
            spatialSubset.getGrid().add(grid.getValue());
        }
        return spatialSubset;
    }

    public int getExecutionMode() {
        return 2;
    }
}

