/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2002-2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.wfs;

import java.util.Set;
import javax.xml.namespace.QName;
import org.geotools.filter.v1_1.OGC;
import org.geotools.ows.OWS;
import org.geotools.xml.XSD;


/**
 * This interface contains the qualified names of all the types,elements, and
 * attributes in the <code>http://www.opengis.net/wfs</code> for the
 * <code>http://schemas.opengis.net/wfs/1.1.0/wfs.xsd</code> schema.
 *
 * @generated
 *
 * @source $URL$
 */
public abstract class WFS extends XSD {

    /** @generated */
    public static final String NAMESPACE = "http://www.opengis.net/wfs";

    /* Type Definitions */
    /** @generated */
    public static final QName ActionType = new QName("http://www.opengis.net/wfs", "ActionType");

    /** @generated */
    public static final QName AllSomeType = new QName("http://www.opengis.net/wfs", "AllSomeType");

    /** @generated */
    public static final QName Base_TypeNameListType = new QName("http://www.opengis.net/wfs",
            "Base_TypeNameListType");

    /** @generated */
    public static final QName BaseRequestType = new QName("http://www.opengis.net/wfs",
            "BaseRequestType");

    /** @generated */
    public static final QName DeleteElementType = new QName("http://www.opengis.net/wfs",
            "DeleteElementType");

    /** @generated */
    public static final QName DescribeFeatureTypeType = new QName("http://www.opengis.net/wfs",
            "DescribeFeatureTypeType");

    /** @generated */
    public static final QName FeatureCollectionType = new QName("http://www.opengis.net/wfs",
            "FeatureCollectionType");

    /** @generated */
    public static final QName FeaturesLockedType = new QName("http://www.opengis.net/wfs",
            "FeaturesLockedType");

    /** @generated */
    public static final QName FeaturesNotLockedType = new QName("http://www.opengis.net/wfs",
            "FeaturesNotLockedType");

    /** @generated */
    public static final QName FeatureTypeListType = new QName("http://www.opengis.net/wfs",
            "FeatureTypeListType");

    /** @generated */
    public static final QName FeatureTypeType = new QName("http://www.opengis.net/wfs",
            "FeatureTypeType");

    /** @generated */
    public static final QName GetCapabilitiesType = new QName("http://www.opengis.net/wfs",
            "GetCapabilitiesType");

    /** @generated */
    public static final QName GetFeatureType = new QName("http://www.opengis.net/wfs",
            "GetFeatureType");

    /** @generated */
    public static final QName GetFeatureWithLockType = new QName("http://www.opengis.net/wfs",
            "GetFeatureWithLockType");

    /** @generated */
    public static final QName GetGmlObjectType = new QName("http://www.opengis.net/wfs",
            "GetGmlObjectType");

    /** @generated */
    public static final QName GMLObjectTypeListType = new QName("http://www.opengis.net/wfs",
            "GMLObjectTypeListType");

    /** @generated */
    public static final QName GMLObjectTypeType = new QName("http://www.opengis.net/wfs",
            "GMLObjectTypeType");

    /** @generated */
    public static final QName IdentifierGenerationOptionType = new QName("http://www.opengis.net/wfs",
            "IdentifierGenerationOptionType");

    /** @generated */
    public static final QName InsertedFeatureType = new QName("http://www.opengis.net/wfs",
            "InsertedFeatureType");

    /** @generated */
    public static final QName InsertElementType = new QName("http://www.opengis.net/wfs",
            "InsertElementType");

    /** @generated */
    public static final QName InsertResultsType = new QName("http://www.opengis.net/wfs",
            "InsertResultsType");

    /** @generated */
    public static final QName LockFeatureResponseType = new QName("http://www.opengis.net/wfs",
            "LockFeatureResponseType");

    /** @generated */
    public static final QName LockFeatureType = new QName("http://www.opengis.net/wfs",
            "LockFeatureType");

    /** @generated */
    public static final QName LockType = new QName("http://www.opengis.net/wfs", "LockType");

    /** @generated */
    public static final QName MetadataURLType = new QName("http://www.opengis.net/wfs",
            "MetadataURLType");

    /** @generated */
    public static final QName NativeType = new QName("http://www.opengis.net/wfs", "NativeType");

    /** @generated */
    public static final QName OperationsType = new QName("http://www.opengis.net/wfs",
            "OperationsType");

    /** @generated */
    public static final QName OperationType = new QName("http://www.opengis.net/wfs",
            "OperationType");

    /** @generated */
    public static final QName OutputFormatListType = new QName("http://www.opengis.net/wfs",
            "OutputFormatListType");

    /** @generated */
    public static final QName PropertyType = new QName("http://www.opengis.net/wfs", "PropertyType");

    /** @generated */
    public static final QName QueryType = new QName("http://www.opengis.net/wfs", "QueryType");

    /** @generated */
    public static final QName ResultTypeType = new QName("http://www.opengis.net/wfs",
            "ResultTypeType");

    /** @generated */
    public static final QName TransactionResponseType = new QName("http://www.opengis.net/wfs",
            "TransactionResponseType");

    /** @generated */
    public static final QName TransactionResultsType = new QName("http://www.opengis.net/wfs",
            "TransactionResultsType");

    public static final QName TransactionResults = new QName("http://www.opengis.net/wfs",
    "TransactionResults");

    /** @generated */
    public static final QName TransactionSummaryType = new QName("http://www.opengis.net/wfs",
            "TransactionSummaryType");

    /** @generated */
    public static final QName TransactionType = new QName("http://www.opengis.net/wfs",
            "TransactionType");

    /** @generated */
    public static final QName TypeNameListType = new QName("http://www.opengis.net/wfs",
            "TypeNameListType");

    /** @generated */
    public static final QName UpdateElementType = new QName("http://www.opengis.net/wfs",
            "UpdateElementType");

    /** @generated */
    public static final QName WFS_CapabilitiesType = new QName("http://www.opengis.net/wfs",
            "WFS_CapabilitiesType");

    /** @generated */
    public static final QName _XlinkPropertyName = new QName("http://www.opengis.net/wfs",
            "_XlinkPropertyName");

    /** @generated */
    public static final QName FeatureTypeType_NoSRS = new QName("http://www.opengis.net/wfs",
            "FeatureTypeType_NoSRS");

    /* Elements */
    /** @generated */
    public static final QName Delete = new QName("http://www.opengis.net/wfs", "Delete");

    /** @generated */
    public static final QName DescribeFeatureType = new QName("http://www.opengis.net/wfs",
            "DescribeFeatureType");

    /** @generated */
    public static final QName FeatureCollection = new QName("http://www.opengis.net/wfs",
            "FeatureCollection");

    /** @generated */
    public static final QName FeatureTypeList = new QName("http://www.opengis.net/wfs",
            "FeatureTypeList");

    /** @generated */
    public static final QName GetCapabilities = new QName("http://www.opengis.net/wfs",
            "GetCapabilities");

    /** @generated */
    public static final QName GetFeature = new QName("http://www.opengis.net/wfs", "GetFeature");

    /** @generated */
    public static final QName GetFeatureWithLock = new QName("http://www.opengis.net/wfs",
            "GetFeatureWithLock");

    /** @generated */
    public static final QName GetGmlObject = new QName("http://www.opengis.net/wfs", "GetGmlObject");

    /** @generated */
    public static final QName Insert = new QName("http://www.opengis.net/wfs", "Insert");

    /** @generated */
    public static final QName LockFeature = new QName("http://www.opengis.net/wfs", "LockFeature");

    /** @generated */
    public static final QName LockFeatureResponse = new QName("http://www.opengis.net/wfs",
            "LockFeatureResponse");

    /** @generated */
    public static final QName LockId = new QName("http://www.opengis.net/wfs", "LockId");

    /** @generated */
    public static final QName Native = new QName("http://www.opengis.net/wfs", "Native");

    /** @generated */
    public static final QName Property = new QName("http://www.opengis.net/wfs", "Property");

    /** @generated */
    public static final QName PropertyName = new QName("http://www.opengis.net/wfs", "PropertyName");

    /** @generated */
    public static final QName Query = new QName("http://www.opengis.net/wfs", "Query");

    /** @generated */
    public static final QName ServesGMLObjectTypeList = new QName("http://www.opengis.net/wfs",
            "ServesGMLObjectTypeList");

    /** @generated */
    public static final QName SupportsGMLObjectTypeList = new QName("http://www.opengis.net/wfs",
            "SupportsGMLObjectTypeList");

    /** @generated */
    public static final QName Transaction = new QName("http://www.opengis.net/wfs", "Transaction");

    /** @generated */
    public static final QName TransactionResponse = new QName("http://www.opengis.net/wfs",
            "TransactionResponse");

    /** @generated */
    public static final QName Update = new QName("http://www.opengis.net/wfs", "Update");

    /** @generated */
    public static final QName WFS_Capabilities = new QName("http://www.opengis.net/wfs",
            "WFS_Capabilities");

    /** @generated */
    public static final QName XlinkPropertyName = new QName("http://www.opengis.net/wfs",
            "XlinkPropertyName");

    /**
     * private constructor
     */
    protected WFS() {
    }

    /**
     * Returns 'http://www.opengis.net/wfs'.
     */
    public String getNamespaceURI() {
        return NAMESPACE;
    }
    
    /**
     * Returns the version of WFS.
     */
    public abstract String getVersion();

    /* Attributes */
}
