/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.web.servlet;

import java.io.IOException;
import java.util.EventListener;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import org.glassfish.grizzly.web.container.util.LoggerUtils;
import org.glassfish.grizzly.web.servlet.FilterConfigImpl;
import org.glassfish.grizzly.web.servlet.ServletConfigImpl;
import org.glassfish.grizzly.web.servlet.ServletContextImpl;

public final class FilterChainImpl
implements FilterChain {
    public static final int INCREMENT = 8;
    private FilterConfigImpl[] filters = new FilterConfigImpl[8];
    private int pos = 0;
    private int n = 0;
    private Servlet servlet = null;
    private ServletConfigImpl configImpl;

    protected void init() throws ServletException {
        for (FilterConfigImpl f : this.filters) {
            if (f == null) continue;
            f.getFilter().init((FilterConfig)f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeFilterChain(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ServletRequestEvent event = new ServletRequestEvent(this.configImpl.getServletContext(), request);
        try {
            for (EventListener l : ((ServletContextImpl)this.configImpl.getServletContext()).getListeners()) {
                try {
                    if (!(l instanceof ServletRequestListener)) continue;
                    ((ServletRequestListener)l).requestInitialized(event);
                }
                catch (Throwable t) {
                    LoggerUtils.getLogger().log(Level.WARNING, "", t);
                }
            }
            this.pos = 0;
            this.doFilter(request, response);
        }
        finally {
            for (EventListener l : ((ServletContextImpl)this.configImpl.getServletContext()).getListeners()) {
                try {
                    if (!(l instanceof ServletRequestListener)) continue;
                    ((ServletRequestListener)l).requestDestroyed(event);
                }
                catch (Throwable t) {
                    LoggerUtils.getLogger().log(Level.WARNING, "", t);
                }
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.pos < this.n) {
            FilterConfigImpl filterConfig = this.filters[this.pos++];
            Filter filter = null;
            try {
                filter = filterConfig.getFilter();
                filter.doFilter(request, response, (FilterChain)this);
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ServletException("Throwable", e);
            }
            return;
        }
        try {
            if (this.servlet != null) {
                this.servlet.service(request, response);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException("Throwable", e);
        }
    }

    protected void addFilter(FilterConfigImpl filterConfig) {
        if (this.n == this.filters.length) {
            FilterConfigImpl[] newFilters = new FilterConfigImpl[this.n + 8];
            System.arraycopy(this.filters, 0, newFilters, 0, this.n);
            this.filters = newFilters;
        }
        this.filters[this.n++] = filterConfig;
    }

    protected void recycle() {
        this.pos = 0;
    }

    protected void setServlet(ServletConfigImpl configImpl, Servlet servlet) {
        this.configImpl = configImpl;
        this.servlet = servlet;
    }

    protected FilterConfigImpl getFilter(int i) {
        return this.filters[i];
    }

    protected Servlet getServlet() {
        return this.servlet;
    }

    protected ServletConfigImpl getServletConfig() {
        return this.configImpl;
    }

    public void destroy() {
        for (FilterConfigImpl filter : this.filters) {
            if (filter == null) continue;
            filter.recycle();
        }
        this.filters = null;
    }
}

