/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ast;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ast.AstBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ast.AstModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSetAttrO;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.AST})
public final class AstBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AstBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonBuiltinNode {
        @Specialization
        static Object doit(VirtualFrame frame, PythonObject self, Object ignored, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PyObjectLookupAttr lookupAttr, @Cached PythonObjectFactory factory) {
            Object clazz = getClassNode.execute(inliningTarget, self);
            Object dict = lookupAttr.execute((Frame)frame, inliningTarget, self, SpecialAttributeNames.T___DICT__);
            return factory.createTuple(new Object[]{clazz, factory.createTuple(PythonUtils.EMPTY_OBJECT_ARRAY), dict});
        }
    }

    @Builtin(name="__dict__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    public static abstract class DictNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        static Object doit(PythonObject self, PNone none, @Bind(value="this") Node inliningTarget, @Cached GetOrCreateDictNode getDict) {
            return getDict.execute(inliningTarget, self);
        }

        @Specialization
        static Object dict(PythonObject self, PDict dict, @Bind(value="this") Node inliningTarget, @Cached SetDictNode setDict) {
            setDict.execute(inliningTarget, self, dict);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(d)", "!isDict(d)"})
        static Object setDict(PythonObject self, Object d, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.DICT_MUST_BE_SET_TO_DICT, d);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    static abstract class InitNode
    extends PythonVarargsBuiltinNode {
        InitNode() {
        }

        @Specialization
        protected Object doIt(VirtualFrame frame, Object self, Object[] args, PKeyword[] kwArgs, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookupAttrNode, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached PyObjectSetAttrO setAttrNode, @Cached TruffleString.EqualNode equalNode) {
            Object[] fields;
            Object fieldsObj = lookupAttrNode.execute((Frame)frame, inliningTarget, self, AstModuleBuiltins.T__FIELDS);
            if (fieldsObj == PNone.NO_VALUE) {
                fields = PythonUtils.EMPTY_OBJECT_ARRAY;
            } else {
                if (!(fieldsObj instanceof PSequence)) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.IS_NOT_A_SEQUENCE, fieldsObj);
                }
                fields = getObjectArrayNode.execute(inliningTarget, fieldsObj);
            }
            if (fields.length < args.length) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.S_CONSTRUCTOR_TAKES_AT_MOST_D_POSITIONAL_ARGUMENT_S, self, fields.length, fields.length == 1 ? "" : "s");
            }
            for (int i = 0; i < args.length; ++i) {
                setAttrNode.execute((Frame)frame, inliningTarget, self, fields[i], args[i]);
            }
            for (PKeyword kwArg : kwArgs) {
                if (InitNode.contains(fields, args.length, kwArg.getName(), equalNode)) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.P_GOT_MULTIPLE_VALUES_FOR_ARGUMENT_S, self, kwArg.getName());
                }
                setAttrNode.execute((Frame)frame, inliningTarget, self, kwArg.getName(), kwArg.getValue());
            }
            return PNone.NONE;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean contains(Object[] fields, int maxIndex, TruffleString name, TruffleString.EqualNode equalNode) {
            for (int i = 0; i < maxIndex; ++i) {
                if (!(fields[i] instanceof TruffleString) || !equalNode.execute((AbstractTruffleString)name, (AbstractTruffleString)((TruffleString)fields[i]), PythonUtils.TS_ENCODING)) continue;
                return true;
            }
            return false;
        }
    }
}

