/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.hashlib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import java.security.MessageDigest;
import javax.crypto.Mac;

public abstract class DigestObject
extends PythonBuiltinObject {
    private final String name;

    DigestObject(Object cls, Shape instanceShape, String name) {
        super(cls, instanceShape);
        this.name = name;
    }

    public static DigestObject create(PythonBuiltinClassType digestType, Shape instanceShape, String name, Object digest) {
        if (digest instanceof MessageDigest) {
            MessageDigest md = (MessageDigest)digest;
            return new MessageDigestObject(digestType, instanceShape, name, md);
        }
        if (digest instanceof Mac) {
            Mac mac = (Mac)digest;
            return new MacDigestObject(digestType, instanceShape, name, mac);
        }
        throw CompilerDirectives.shouldNotReachHere((String)"unsupported digest type");
    }

    public PythonBuiltinClassType getType() {
        return (PythonBuiltinClassType)((Object)this.getInitialPythonClass());
    }

    public int getBlockSize() {
        PythonBuiltinClassType mainDigestType = this.getMainDigestType();
        switch (mainDigestType) {
            case MD5Type: 
            case SHA1Type: 
            case SHA224Type: 
            case SHA256Type: {
                return 64;
            }
            case SHA384Type: 
            case SHA512Type: {
                return 128;
            }
            case Sha3SHA224Type: {
                return 144;
            }
            case Sha3SHA256Type: {
                return 136;
            }
            case Sha3SHA384Type: {
                return 104;
            }
            case Sha3SHA512Type: {
                return 72;
            }
            case Sha3Shake128Type: {
                return 168;
            }
            case Sha3Shake256Type: {
                return 136;
            }
            case Blake2bType: {
                return 128;
            }
            case Blake2sType: {
                return 64;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private PythonBuiltinClassType getMainDigestType() {
        PythonBuiltinClassType actualType = this.getType();
        switch (actualType) {
            case HashlibHash: 
            case HashlibHashXof: 
            case HashlibHmac: {
                return this.determineMainDigestType();
            }
        }
        return actualType;
    }

    private PythonBuiltinClassType determineMainDigestType() {
        String algorithm;
        switch (algorithm = this.getAlgorithm()) {
            case "md5": 
            case "hmac-md5": {
                return PythonBuiltinClassType.MD5Type;
            }
            case "sha1": 
            case "hmac-sha1": {
                return PythonBuiltinClassType.SHA1Type;
            }
            case "sha224": 
            case "hmac-sha224": {
                return PythonBuiltinClassType.SHA224Type;
            }
            case "sha256": 
            case "hmac-sha256": {
                return PythonBuiltinClassType.SHA256Type;
            }
            case "sha384": 
            case "hmac-sha384": {
                return PythonBuiltinClassType.SHA384Type;
            }
            case "sha512": 
            case "hmac-sha512": {
                return PythonBuiltinClassType.SHA512Type;
            }
            case "sha3_224": 
            case "hmac-sha3_224": {
                return PythonBuiltinClassType.Sha3SHA224Type;
            }
            case "sha3_256": 
            case "hmac-sha3_256": {
                return PythonBuiltinClassType.Sha3SHA256Type;
            }
            case "sha3_384": 
            case "hmac-sha3_384": {
                return PythonBuiltinClassType.Sha3SHA384Type;
            }
            case "sha3_512": 
            case "hmac-sha3_512": {
                return PythonBuiltinClassType.Sha3SHA512Type;
            }
            case "shake_128": {
                return PythonBuiltinClassType.Sha3Shake128Type;
            }
            case "shake_256": {
                return PythonBuiltinClassType.Sha3Shake256Type;
            }
            case "blake2s": {
                return PythonBuiltinClassType.Blake2sType;
            }
            case "blake2b": {
                return PythonBuiltinClassType.Blake2bType;
            }
        }
        return PythonBuiltinClassType.MD5Type;
    }

    abstract byte[] digest();

    abstract boolean wasReset();

    abstract void update(byte[] var1, int var2);

    abstract DigestObject copy(PythonObjectFactory var1) throws CloneNotSupportedException;

    abstract int getDigestLength();

    final String getAlgorithm() {
        return this.name;
    }

    private static final class MessageDigestObject
    extends DigestObjectBase {
        private final MessageDigest digest;

        MessageDigestObject(PythonBuiltinClassType digestType, Shape instanceShape, String name, MessageDigest digest) {
            super((Object)digestType, instanceShape, name);
            this.digest = digest;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        DigestObject copy(PythonObjectFactory factory) throws CloneNotSupportedException {
            return factory.createDigestObject(this.getType(), this.getAlgorithm(), this.digest.clone());
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        byte[] calculateDigestOnClone() throws CloneNotSupportedException {
            return ((MessageDigest)this.digest.clone()).digest();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        byte[] calculateDigest() {
            return this.digest.digest();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        void doUpdate(byte[] data, int length) {
            this.digest.update(data, 0, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        int getDigestLength() {
            return this.digest.getDigestLength();
        }
    }

    private static final class MacDigestObject
    extends DigestObjectBase {
        private final Mac mac;

        MacDigestObject(PythonBuiltinClassType digestType, Shape instanceShape, String name, Mac mac) {
            super((Object)digestType, instanceShape, name);
            this.mac = mac;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        DigestObject copy(PythonObjectFactory factory) throws CloneNotSupportedException {
            return factory.createDigestObject(this.getType(), this.getAlgorithm(), this.mac.clone());
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        byte[] calculateDigestOnClone() throws CloneNotSupportedException {
            return ((Mac)this.mac.clone()).doFinal();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        byte[] calculateDigest() {
            return this.mac.doFinal();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        void doUpdate(byte[] data, int length) {
            this.mac.update(data, 0, length);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        int getDigestLength() {
            return this.mac.getMacLength();
        }
    }

    private static abstract class DigestObjectBase
    extends DigestObject {
        private byte[] cachedDigest = null;
        private boolean wasReset;

        DigestObjectBase(Object cls, Shape instanceShape, String name) {
            super(cls, instanceShape, name);
        }

        @Override
        final boolean wasReset() {
            return this.wasReset;
        }

        @Override
        final byte[] digest() {
            if (this.cachedDigest == null) {
                try {
                    this.cachedDigest = this.calculateDigestOnClone();
                }
                catch (CloneNotSupportedException e) {
                    this.wasReset = true;
                    this.cachedDigest = this.calculateDigest();
                }
            }
            return this.cachedDigest;
        }

        @Override
        final void update(byte[] data, int length) {
            if (this.wasReset) {
                throw CompilerDirectives.shouldNotReachHere((String)"update() called after digest() on an implementation the does not support clone()");
            }
            this.cachedDigest = null;
            this.doUpdate(data, length);
        }

        abstract byte[] calculateDigestOnClone() throws CloneNotSupportedException;

        abstract byte[] calculateDigest();

        abstract void doUpdate(byte[] var1, int var2);
    }
}

