/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.CPyObjectArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonObjectNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToJavaNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToNativeNode;
import com.oracle.graal.python.builtins.objects.cext.common.NativeCExtSymbol;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.argument.ReadIndexedArgumentNode;
import com.oracle.graal.python.nodes.argument.ReadVarArgsNode;
import com.oracle.graal.python.nodes.argument.ReadVarKeywordsNode;
import com.oracle.graal.python.nodes.call.special.CallVarargsMethodNode;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.nodes.truffle.PythonTypes;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.NativeObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.Function;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class ExternalFunctionNodes {
    private static final TruffleLogger LOGGER = CApiContext.getLogger(ExternalFunctionNodes.class);
    public static final TruffleString KW_CALLABLE = PythonUtils.tsLiteral("$callable");
    public static final TruffleString KW_CLOSURE = PythonUtils.tsLiteral("$closure");
    static final TruffleString[] KEYWORDS_HIDDEN_CALLABLE = new TruffleString[]{KW_CALLABLE};
    static final TruffleString[] KEYWORDS_HIDDEN_CALLABLE_AND_CLOSURE = new TruffleString[]{KW_CALLABLE, KW_CLOSURE};

    public static PKeyword[] createKwDefaults(Object callable) {
        assert (InteropLibrary.getUncached().isExecutable(callable));
        return new PKeyword[]{new PKeyword(KW_CALLABLE, callable)};
    }

    public static PKeyword[] createKwDefaults(Object callable, Object closure) {
        assert (InteropLibrary.getUncached().isExecutable(callable));
        return new PKeyword[]{new PKeyword(KW_CALLABLE, callable), new PKeyword(KW_CLOSURE, closure)};
    }

    public static Object tryGetHiddenCallable(PBuiltinFunction function) {
        if (function.getFunctionRootNode() instanceof MethodDescriptorRoot) {
            return ExternalFunctionNodes.getHiddenCallable(function.getKwDefaults());
        }
        return null;
    }

    public static Object getHiddenCallable(PKeyword[] kwDefaults) {
        if (kwDefaults.length >= KEYWORDS_HIDDEN_CALLABLE.length) {
            PKeyword kwDefault = kwDefaults[0];
            assert (KW_CALLABLE.equalsUncached((AbstractTruffleString)kwDefault.getName(), PythonUtils.TS_ENCODING)) : "invalid keyword defaults";
            return kwDefault.getValue();
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private static Signature createSignature(boolean takesVarKeywordArgs, int varArgIndex, TruffleString[] parameters, boolean checkEnclosingType, boolean hidden) {
        return new Signature(-1, takesVarKeywordArgs, varArgIndex, false, parameters, KEYWORDS_HIDDEN_CALLABLE, checkEnclosingType, StringLiterals.T_EMPTY_STRING, hidden);
    }

    private static Signature createSignatureWithClosure(boolean takesVarKeywordArgs, int varArgIndex, TruffleString[] parameters, boolean checkEnclosingType, boolean hidden) {
        return new Signature(-1, takesVarKeywordArgs, varArgIndex, false, parameters, KEYWORDS_HIDDEN_CALLABLE_AND_CLOSURE, checkEnclosingType, StringLiterals.T_EMPTY_STRING, hidden);
    }

    public static abstract class MethodDescriptorRoot
    extends PRootNode {
        private final PExternalFunctionWrapper provider;
        private final CApiTiming timing;
        @Node.Child
        private ExecutionContext.CalleeContext calleeContext = ExecutionContext.CalleeContext.create();
        @Node.Child
        private CallVarargsMethodNode invokeNode;
        @Node.Child
        private ExternalFunctionWrapperInvokeNode externalInvokeNode;
        @Node.Child
        private ReadIndexedArgumentNode readSelfNode;
        @Node.Child
        private ReadIndexedArgumentNode readCallableNode;
        @Node.Child
        private CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode;
        @Node.Children
        private final CExtToNativeNode[] convertArgs;
        private final TruffleString name;

        MethodDescriptorRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            this(language, name, isStatic, null);
        }

        MethodDescriptorRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language);
            CompilerAsserts.neverPartOfCompilation();
            this.name = name;
            this.timing = CApiTiming.create(true, name);
            this.provider = provider;
            if (provider != null) {
                this.externalInvokeNode = ExternalFunctionWrapperInvokeNode.create();
                this.convertArgs = provider.createConvertArgNodes();
            } else {
                this.invokeNode = CallVarargsMethodNode.create();
                this.convertArgs = null;
            }
            if (!isStatic) {
                this.readSelfNode = ReadIndexedArgumentNode.create(0);
            }
        }

        @ExplodeLoop
        private void prepareArguments(Object[] arguments) {
            for (int i = 0; i < this.convertArgs.length; ++i) {
                if (this.convertArgs[i] == null) continue;
                arguments[i] = this.convertArgs[i].execute(arguments[i]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object execute(VirtualFrame frame) {
            this.calleeContext.enter(frame);
            try {
                Object callable = this.ensureReadCallableNode().execute(frame);
                if (this.externalInvokeNode != null) {
                    Object[] cArguments = this.prepareCArguments(frame);
                    this.prepareArguments(cArguments);
                    try {
                        assert (this.provider != null) : "the provider cannot be null";
                        Object object = this.externalInvokeNode.execute(frame, this.provider, this.timing, this.name, callable, cArguments);
                        return object;
                    }
                    finally {
                        this.postprocessCArguments(frame, cArguments);
                    }
                }
                Object object = this.invokeNode.execute((Frame)frame, callable, this.preparePArguments(frame), PArguments.getKeywordArguments((Frame)frame));
                return object;
            }
            finally {
                this.calleeContext.exit(frame, this);
            }
        }

        protected abstract Object[] prepareCArguments(VirtualFrame var1);

        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
        }

        protected Object[] preparePArguments(VirtualFrame frame) {
            Object[] variableArguments = PArguments.getVariableArguments((Frame)frame);
            int variableArgumentsLength = variableArguments != null ? variableArguments.length : 0;
            int userArgumentLength = PArguments.getUserArgumentLength(frame) - 1;
            int argumentsLength = userArgumentLength + variableArgumentsLength;
            Object[] arguments = new Object[argumentsLength];
            PythonUtils.arraycopy(frame.getArguments(), 9, arguments, 0, userArgumentLength);
            if (variableArguments != null) {
                PythonUtils.arraycopy(variableArguments, 0, arguments, userArgumentLength, variableArgumentsLength);
            }
            return arguments;
        }

        private ReadIndexedArgumentNode ensureReadCallableNode() {
            if (this.readCallableNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int hiddenArg = this.getSignature().getParameterIds().length;
                this.readCallableNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(hiddenArg));
            }
            return this.readCallableNode;
        }

        protected final CExtNodes.ReleaseNativeWrapperNode ensureReleaseNativeWrapperNode() {
            if (this.releaseNativeWrapperNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.releaseNativeWrapperNode = (CExtNodes.ReleaseNativeWrapperNode)this.insert(CExtNodesFactory.ReleaseNativeWrapperNodeGen.create());
            }
            return this.releaseNativeWrapperNode;
        }

        @Override
        public boolean isCloningAllowed() {
            return true;
        }

        public String getName() {
            return this.name.toJavaStringUncached();
        }

        public String toString() {
            return "<METH root " + String.valueOf(this.name) + ">";
        }

        @Override
        public boolean isPythonInternal() {
            return true;
        }

        public boolean isInternal() {
            return true;
        }

        @Override
        public boolean setsUpCalleeContext() {
            return true;
        }

        protected final Object readSelf(VirtualFrame frame) {
            if (this.readSelfNode != null) {
                return this.readSelfNode.execute(frame);
            }
            return PNone.NO_VALUE;
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class CheckInquiryResultNode
    extends CExtCommonNodes.CheckFunctionResultNode {
        public abstract boolean executeBool(PythonContext.PythonThreadState var1, TruffleString var2, Object var3);

        @Specialization
        static boolean doLong(PythonContext.PythonThreadState threadState, TruffleString name, long result, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile resultProfile, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            transformExceptionFromNativeNode.execute(inliningTarget, threadState, name, result == -1L, false);
            return resultProfile.profile(inliningTarget, result != 0L);
        }

        @Specialization(replaces={"doLong"})
        @HostCompilerDirectives.InliningCutoff
        static boolean doGeneric(PythonContext.PythonThreadState threadState, TruffleString name, Object result, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile resultProfile, @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            if (lib.fitsInLong(result)) {
                try {
                    long lresult = lib.asLong(result);
                    transformExceptionFromNativeNode.execute(inliningTarget, threadState, name, lresult == -1L, false);
                    return resultProfile.profile(inliningTarget, lresult != 0L);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.FUNC_DIDNT_RETURN_INT, name);
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class CheckPrimitiveFunctionResultNode
    extends CExtCommonNodes.CheckFunctionResultNode {
        public abstract long executeLong(PythonContext.PythonThreadState var1, TruffleString var2, Object var3);

        @Specialization
        static long doLong(PythonContext.PythonThreadState threadState, TruffleString name, long result, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            transformExceptionFromNativeNode.execute(inliningTarget, threadState, name, result == -1L, false);
            return result;
        }

        @Specialization(replaces={"doLong"})
        @HostCompilerDirectives.InliningCutoff
        static long doGeneric(PythonContext.PythonThreadState threadState, TruffleString name, Object result, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="2") InteropLibrary lib, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            if (lib.fitsInLong(result)) {
                try {
                    long ret = lib.asLong(result);
                    transformExceptionFromNativeNode.execute(inliningTarget, threadState, name, ret == -1L, false);
                    return ret;
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)"expected primitive function result but does not fit into Java long");
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class InitCheckFunctionResultNode
    extends CExtCommonNodes.CheckFunctionResultNode {
        @Specialization
        static Object doInt(PythonContext.PythonThreadState state, TruffleString name, int result, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            transformExceptionFromNativeNode.execute(inliningTarget, state, name, result < 0, true);
            return PNone.NONE;
        }

        @Specialization(replaces={"doInt"})
        @HostCompilerDirectives.InliningCutoff
        static Object notNumber(PythonContext.PythonThreadState state, TruffleString name, Object result, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="2") InteropLibrary lib, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            int ret = 0;
            if (lib.isNumber(result)) {
                try {
                    ret = lib.asInt(result);
                    if (ret >= 0) {
                        return PNone.NONE;
                    }
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            transformExceptionFromNativeNode.execute(inliningTarget, state, name, ret < 0, true);
            return result;
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class CheckIterNextResultNode
    extends CExtCommonNodes.CheckFunctionResultNode {
        @Specialization(limit="3")
        static Object doGeneric(PythonContext.PythonThreadState state, TruffleString name, Object result, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="result") InteropLibrary lib, @Cached CExtCommonNodes.ClearCurrentExceptionNode clearCurrentExceptionNode, @Cached PRaiseNode raiseNode) {
            if (lib.isNull(result)) {
                AbstractTruffleException currentException = state.getCurrentException();
                if (currentException == null) {
                    throw raiseNode.raiseStopIteration();
                }
                throw clearCurrentExceptionNode.getCurrentExceptionForReraise(inliningTarget, state);
            }
            return result;
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class PyObjectCheckFunctionResultNode
    extends CExtCommonNodes.CheckFunctionResultNode {
        @Specialization(guards={"!isForeignObject.execute(inliningTarget, result)"})
        static Object doPythonObject(PythonContext.PythonThreadState state, TruffleString name, Object result, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached IsForeignObjectNode isForeignObject, @Cached.Shared @Cached InlinedConditionProfile indicatesErrorProfile, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            boolean indicatesError = indicatesErrorProfile.profile(inliningTarget, PGuards.isNoValue(result));
            transformExceptionFromNativeNode.execute(inliningTarget, state, name, indicatesError, true);
            assert (!indicatesError);
            return result;
        }

        @Specialization(guards={"isForeignObject.execute(inliningTarget, result)"})
        static Object doForeign(PythonContext.PythonThreadState state, TruffleString name, Object result, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached IsForeignObjectNode isForeignObject, @Cached.Shared @Cached InlinedConditionProfile indicatesErrorProfile, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode, @CachedLibrary(limit="3") InteropLibrary lib) {
            boolean indicatesError = indicatesErrorProfile.profile(inliningTarget, lib.isNull(result));
            transformExceptionFromNativeNode.execute(inliningTarget, state, name, indicatesError, true);
            assert (!indicatesError);
            return result;
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class DefaultCheckFunctionResultNode
    extends CExtCommonNodes.CheckFunctionResultNode {
        @Specialization
        static Object doNativeWrapper(PythonContext.PythonThreadState state, TruffleString name, PythonNativeWrapper result, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            transformExceptionFromNativeNode.execute(inliningTarget, state, name, false, true);
            return result;
        }

        @Specialization(guards={"isNoValue(result)"})
        static Object doNoValue(PythonContext.PythonThreadState state, TruffleString name, PNone result, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            transformExceptionFromNativeNode.execute(inliningTarget, state, name, true, true);
            return PNone.NO_VALUE;
        }

        @Specialization(guards={"!isNoValue(result)"})
        static Object doPythonObject(PythonContext.PythonThreadState state, TruffleString name, PythonAbstractObject result, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            transformExceptionFromNativeNode.execute(inliningTarget, state, name, false, true);
            return result;
        }

        @Specialization
        static Object doNativePointer(PythonContext.PythonThreadState state, TruffleString name, NativePointer result, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            transformExceptionFromNativeNode.execute(inliningTarget, state, name, result.isNull(), true);
            return result;
        }

        @Specialization
        static int doInteger(PythonContext.PythonThreadState state, TruffleString name, int result, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            transformExceptionFromNativeNode.execute(inliningTarget, state, name, result == -1, false);
            return result;
        }

        @Specialization
        static long doLong(PythonContext.PythonThreadState state, TruffleString name, long result, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode) {
            transformExceptionFromNativeNode.execute(inliningTarget, state, name, result == -1L, false);
            return result;
        }

        @Specialization(guards={"!isPythonNativeWrapper(result)", "!isPNone(result)"})
        static Object doForeign(PythonContext.PythonThreadState state, TruffleString name, Object result, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CExtCommonNodes.TransformExceptionFromNativeNode transformExceptionFromNativeNode, @Cached.Exclusive @CachedLibrary(limit="3") InteropLibrary lib) {
            transformExceptionFromNativeNode.execute(inliningTarget, state, name, lib.isNull(result), true);
            return result;
        }

        protected static boolean isPythonNativeWrapper(Object object) {
            return object instanceof PythonNativeWrapper;
        }
    }

    @TypeSystemReference(value=PythonTypes.class)
    @GenerateInline(value=false)
    static abstract class MaterializePrimitiveNode
    extends Node {
        MaterializePrimitiveNode() {
        }

        public abstract Object execute(PythonObjectFactory var1, Object var2);

        @Specialization
        static PInt doInteger(PythonObjectFactory factory, int i) {
            return factory.createInt(i);
        }

        @Specialization(replaces={"doInteger"})
        static PInt doLong(PythonObjectFactory factory, long l) {
            return factory.createInt(l);
        }

        @Specialization
        static PFloat doDouble(PythonObjectFactory factory, double d) {
            return factory.createFloat(d);
        }

        @Specialization
        static PString doString(PythonObjectFactory factory, TruffleString s) {
            return factory.createString(s);
        }

        @Specialization(guards={"!needsMaterialization(object)"})
        static Object doObject(PythonObjectFactory factory, Object object) {
            return object;
        }

        static boolean needsMaterialization(Object object) {
            return object instanceof Integer || object instanceof Long || PGuards.isDouble(object) || object instanceof TruffleString;
        }
    }

    @GenerateInline(value=false)
    @ImportStatic(value={PythonUtils.class})
    static abstract class ReleaseNativeSequenceStorageNode
    extends Node {
        ReleaseNativeSequenceStorageNode() {
        }

        abstract void execute(NativeSequenceStorage var1);

        @Specialization(guards={"storage.length() == cachedLen", "cachedLen <= 8"}, limit="1")
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
        static void doObjectCachedLen(NativeObjectSequenceStorage storage, @Bind(value="this") Node inliningTarget, @Cached(value="storage.length()") int cachedLen, @Cached.Shared @Cached CStructAccess.ReadPointerNode readNode, @Cached.Shared @Cached CExtNodes.XDecRefPointerNode decRefPointerNode, @Cached.Shared @Cached CStructAccess.FreeNode freeNode) {
            for (int i = 0; i < cachedLen; ++i) {
                Object elementPointer = readNode.readArrayElement(storage.getPtr(), i);
                decRefPointerNode.execute(inliningTarget, elementPointer);
            }
            freeNode.free(storage.getPtr());
        }

        @Specialization(replaces={"doObjectCachedLen"})
        static void doObjectGeneric(NativeObjectSequenceStorage storage, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CStructAccess.ReadPointerNode readNode, @Cached.Shared @Cached CExtNodes.XDecRefPointerNode decRefPointerNode, @Cached.Shared @Cached CStructAccess.FreeNode freeNode) {
            for (int i = 0; i < storage.length(); ++i) {
                Object elementPointer = readNode.readArrayElement(storage.getPtr(), i);
                decRefPointerNode.execute(inliningTarget, elementPointer);
            }
            freeNode.free(storage.getPtr());
        }
    }

    @GenerateInline(value=false)
    static abstract class CreateArgsTupleNode
    extends Node {
        CreateArgsTupleNode() {
        }

        public abstract PTuple execute(PythonObjectFactory var1, Object[] var2, boolean var3);

        @Specialization(guards={"args.length == cachedLen", "cachedLen <= 8", "!eagerNative"}, limit="1")
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
        static PTuple doCachedLen(PythonObjectFactory factory, Object[] args, boolean eagerNative, @Cached(value="args.length") int cachedLen, @Cached(value="createMaterializeNodes(args.length)") MaterializePrimitiveNode[] materializePrimitiveNodes) {
            for (int i = 0; i < cachedLen; ++i) {
                args[i] = materializePrimitiveNodes[i].execute(factory, args[i]);
            }
            return factory.createTuple(args);
        }

        @Specialization(guards={"args.length == cachedLen", "cachedLen <= 8", "eagerNative"}, limit="1", replaces={"doCachedLen"})
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
        static PTuple doCachedLenEagerNative(PythonObjectFactory factory, Object[] args, boolean eagerNative, @Bind(value="this") Node inliningTarget, @Cached(value="args.length") int cachedLen, @Cached(value="createMaterializeNodes(args.length)") MaterializePrimitiveNode[] materializePrimitiveNodes, @Cached.Exclusive @Cached SequenceStorageNodes.StorageToNativeNode storageToNativeNode) {
            for (int i = 0; i < cachedLen; ++i) {
                args[i] = materializePrimitiveNodes[i].execute(factory, args[i]);
            }
            return factory.createTuple(storageToNativeNode.execute(inliningTarget, args, cachedLen, true));
        }

        @Specialization(replaces={"doCachedLen", "doCachedLenEagerNative"})
        static PTuple doGeneric(PythonObjectFactory factory, Object[] args, boolean eagerNative, @Bind(value="this") Node inliningTarget, @Cached MaterializePrimitiveNode materializePrimitiveNode, @Cached.Exclusive @Cached SequenceStorageNodes.StorageToNativeNode storageToNativeNode) {
            int n = args.length;
            for (int i = 0; i < n; ++i) {
                args[i] = materializePrimitiveNode.execute(factory, args[i]);
            }
            SequenceStorage storage = eagerNative ? storageToNativeNode.execute(inliningTarget, args, n, true) : new ObjectSequenceStorage(args);
            return factory.createTuple(storage);
        }

        static MaterializePrimitiveNode[] createMaterializeNodes(int length) {
            MaterializePrimitiveNode[] materializePrimitiveNodes = new MaterializePrimitiveNode[length];
            for (int i = 0; i < length; ++i) {
                materializePrimitiveNodes[i] = ExternalFunctionNodesFactory.MaterializePrimitiveNodeGen.create();
            }
            return materializePrimitiveNodes;
        }

        static CApiTransitions.PythonToNativeNode[] createPythonToNativeNodes(int length) {
            CApiTransitions.PythonToNativeNode[] pythonToNativeNodes = new CApiTransitions.PythonToNativeNode[length];
            for (int i = 0; i < length; ++i) {
                pythonToNativeNodes[i] = CApiTransitionsFactory.PythonToNativeNodeGen.create();
            }
            return pythonToNativeNodes;
        }
    }

    public static class SetterRoot
    extends GetSetRootNode {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignatureWithClosure(false, -1, PythonUtils.tsArray("self", "value"), true, false);
        @Node.Child
        private ReadIndexedArgumentNode readArgNode;

        public SetterRoot(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg = this.ensureReadArgNode().execute(frame);
            return new Object[]{self, arg, this.readClosure(frame)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }

        private ReadIndexedArgumentNode ensureReadArgNode() {
            if (this.readArgNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readArgNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(1));
            }
            return this.readArgNode;
        }
    }

    public static class GetterRoot
    extends GetSetRootNode {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignatureWithClosure(false, -1, PythonUtils.tsArray("self"), true, false);

        public GetterRoot(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            return new Object[]{self, this.readClosure(frame)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            this.ensureReleaseNativeWrapperNode().execute(cArguments[0]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static abstract class GetSetRootNode
    extends MethodDescriptorRoot {
        @Node.Child
        private ReadIndexedArgumentNode readClosureNode;

        GetSetRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
        }

        protected final Object readClosure(VirtualFrame frame) {
            if (this.readClosureNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                int hiddenArg = this.getSignature().getParameterIds().length + 1;
                this.readClosureNode = (ReadIndexedArgumentNode)this.insert(ReadIndexedArgumentNode.create(hiddenArg));
            }
            return this.readClosureNode.execute(frame);
        }
    }

    static class IterNextFuncRootNode
    extends MethodDescriptorRoot {
        IterNextFuncRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        IterNextFuncRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            return new Object[]{this.readSelf(frame)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            this.ensureReleaseNativeWrapperNode().execute(cArguments[0]);
        }

        @Override
        public Signature getSignature() {
            return MethNoargsRoot.SIGNATURE;
        }
    }

    static final class MethRichcmpOpRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, -1, PythonUtils.tsArray("self", "other"), true, false);
        @Node.Child
        private ReadIndexedArgumentNode readArgNode = ReadIndexedArgumentNode.create(1);
        private final int op;

        MethRichcmpOpRootNode(PythonLanguage language, TruffleString name, int op) {
            super(language, name, false);
            this.op = op;
        }

        MethRichcmpOpRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider, int op) {
            super(language, name, false, provider);
            this.op = op;
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg = this.readArgNode.execute(frame);
            return new Object[]{self, arg, this.op};
        }

        @Override
        protected Object[] preparePArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg = this.readArgNode.execute(frame);
            return new Object[]{self, arg, this.op};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class MethRPowRootNode
    extends MethPowRootNode {
        MethRPowRootNode(PythonLanguage language, TruffleString name) {
            super(language, name);
        }

        MethRPowRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, provider);
        }

        @Override
        Object[] getArguments(Object arg0, Object arg1, Object arg2) {
            return new Object[]{arg1, arg0, arg2};
        }
    }

    static class MethPowRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, 0, PythonUtils.tsArray("args"), false, false);
        @Node.Child
        private ReadVarArgsNode readVarargsNode;
        private final ConditionProfile profile;

        MethPowRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
            this.profile = null;
        }

        MethPowRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readVarargsNode = ReadVarArgsNode.create(true);
            this.profile = ConditionProfile.create();
        }

        @Override
        protected final Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object[] varargs = this.readVarargsNode.executeObjectArray(frame);
            Object arg0 = varargs[0];
            PNone arg1 = this.profile.profile(varargs.length > 1) ? varargs[1] : PNone.NONE;
            return this.getArguments(self, arg0, arg1);
        }

        Object[] getArguments(Object arg0, Object arg1, Object arg2) {
            return new Object[]{arg0, arg1, arg2};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
            releaseNativeWrapperNode.execute(cArguments[2]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class MethReverseRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, -1, PythonUtils.tsArray("self", "obj"), true, false);
        @Node.Child
        private ReadIndexedArgumentNode readArg0Node = ReadIndexedArgumentNode.create(0);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node = ReadIndexedArgumentNode.create(1);

        MethReverseRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        MethReverseRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object arg0 = this.readArg0Node.execute(frame);
            Object arg1 = this.readArg1Node.execute(frame);
            return new Object[]{arg1, arg0};
        }

        @Override
        protected Object[] preparePArguments(VirtualFrame frame) {
            Object arg0 = this.readArg0Node.execute(frame);
            Object arg1 = this.readArg1Node.execute(frame);
            return new Object[]{arg1, arg0};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class MpDelItemRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, -1, PythonUtils.tsArray("self", "i"), true, false);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;

        MpDelItemRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        MpDelItemRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readArg1Node = ReadIndexedArgumentNode.create(1);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg1 = this.readArg1Node.execute(frame);
            return new Object[]{self, arg1, PNone.NO_VALUE};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
            releaseNativeWrapperNode.execute(cArguments[2]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class DelAttrRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, -1, PythonUtils.tsArray("self", "obj"), true, false);
        @Node.Child
        private ReadIndexedArgumentNode readObj;

        public DelAttrRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        public DelAttrRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readObj = ReadIndexedArgumentNode.create(1);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object obj = this.readObj.execute(frame);
            return new Object[]{self, obj, PNone.NO_VALUE};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class DescrDeleteRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, -1, PythonUtils.tsArray("self", "obj"), true, false);
        @Node.Child
        private ReadIndexedArgumentNode readObj;

        public DescrDeleteRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        public DescrDeleteRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readObj = ReadIndexedArgumentNode.create(1);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object obj = this.readObj.execute(frame);
            return new Object[]{self, obj, PNone.NO_VALUE};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class DescrGetRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, -1, PythonUtils.tsArray("self", "obj", "type"), true, false);
        @Node.Child
        private ReadIndexedArgumentNode readObj;
        @Node.Child
        private ReadIndexedArgumentNode readType;

        public DescrGetRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        public DescrGetRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readObj = ReadIndexedArgumentNode.create(1);
            this.readType = ReadIndexedArgumentNode.create(2);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object obj = this.readObj.execute(frame);
            Object type = this.readType.execute(frame);
            return new Object[]{self, obj == PNone.NONE ? PNone.NO_VALUE : obj, type == PNone.NONE ? PNone.NO_VALUE : type};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
            releaseNativeWrapperNode.execute(cArguments[2]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class SetItemRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, -1, PythonUtils.tsArray("self", "i", "value"), true, false);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;
        @Node.Child
        private ReadIndexedArgumentNode readArg2Node;
        @Node.Child
        private CExtCommonNodes.GetIndexNode getIndexNode;

        SetItemRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        SetItemRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readArg1Node = ReadIndexedArgumentNode.create(1);
            this.readArg2Node = ReadIndexedArgumentNode.create(2);
            this.getIndexNode = CExtCommonNodes.GetIndexNode.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg1 = this.readArg1Node.execute(frame);
            Object arg2 = this.readArg2Node.execute(frame);
            return new Object[]{self, this.getIndexNode.execute(self, arg1), arg2};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[2]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class GetItemRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, -1, PythonUtils.tsArray("self", "i"), true, false);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;
        @Node.Child
        private CExtCommonNodes.GetIndexNode getIndexNode;

        GetItemRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        GetItemRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readArg1Node = ReadIndexedArgumentNode.create(1);
            this.getIndexNode = CExtCommonNodes.GetIndexNode.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg1 = this.readArg1Node.execute(frame);
            return new Object[]{self, this.getIndexNode.execute(self, arg1)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            this.ensureReleaseNativeWrapperNode().execute(cArguments[0]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class RichCmpFuncRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, -1, PythonUtils.tsArray("self", "other", "op"), true, false);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;
        @Node.Child
        private ReadIndexedArgumentNode readArg2Node;
        @Node.Child
        private CExtCommonNodes.ConvertPIntToPrimitiveNode asSsizeTNode;

        RichCmpFuncRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        RichCmpFuncRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readArg1Node = ReadIndexedArgumentNode.create(1);
            this.readArg2Node = ReadIndexedArgumentNode.create(2);
            this.asSsizeTNode = CExtCommonNodesFactory.ConvertPIntToPrimitiveNodeGen.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            try {
                Object self = this.readSelf(frame);
                Object arg1 = this.readArg1Node.execute(frame);
                Object arg2 = this.readArg2Node.execute(frame);
                return new Object[]{self, arg1, this.asSsizeTNode.executeIntCached(arg2, 1, 4)};
            }
            catch (UnexpectedResultException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class SetAttrFuncRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, -1, PythonUtils.tsArray("self", "key", "value"), true, false);
        @Node.Child
        private ReadIndexedArgumentNode readArg1Node;
        @Node.Child
        private ReadIndexedArgumentNode readArg2Node;
        @Node.Child
        private CExtNodes.AsCharPointerNode asCharPointerNode;
        @Node.Child
        private CStructAccess.FreeNode free;

        SetAttrFuncRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        SetAttrFuncRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readArg1Node = ReadIndexedArgumentNode.create(1);
            this.readArg2Node = ReadIndexedArgumentNode.create(2);
            this.asCharPointerNode = CExtNodesFactory.AsCharPointerNodeGen.create();
            this.free = CStructAccess.FreeNode.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg1 = this.readArg1Node.execute(frame);
            Object arg2 = this.readArg2Node.execute(frame);
            return new Object[]{self, this.asCharPointerNode.execute(arg1), arg2};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            this.free.free(cArguments[1]);
            releaseNativeWrapperNode.execute(cArguments[2]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static final class GetAttrFuncRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, -1, PythonUtils.tsArray("self", "key"), true, false);
        @Node.Child
        private ReadIndexedArgumentNode readArgNode;
        @Node.Child
        private CExtNodes.AsCharPointerNode asCharPointerNode;
        @Node.Child
        private CStructAccess.FreeNode free;

        GetAttrFuncRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        GetAttrFuncRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readArgNode = ReadIndexedArgumentNode.create(1);
            this.asCharPointerNode = CExtNodesFactory.AsCharPointerNodeGen.create();
            this.free = CStructAccess.FreeNode.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg = this.readArgNode.execute(frame);
            return new Object[]{self, this.asCharPointerNode.execute(arg)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            this.ensureReleaseNativeWrapperNode().execute(cArguments[0]);
            this.free.free(cArguments[1]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    static class AllocFuncRootNode
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, -1, PythonUtils.tsArray("self", "nitems"), true, false);
        @Node.Child
        private ReadIndexedArgumentNode readArgNode;
        @Node.Child
        private CExtCommonNodes.ConvertPIntToPrimitiveNode asSsizeTNode;

        AllocFuncRootNode(PythonLanguage language, TruffleString name) {
            super(language, name, false);
        }

        AllocFuncRootNode(PythonLanguage language, TruffleString name, PExternalFunctionWrapper provider) {
            super(language, name, false, provider);
            this.readArgNode = ReadIndexedArgumentNode.create(1);
            this.asSsizeTNode = CExtCommonNodesFactory.ConvertPIntToPrimitiveNodeGen.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg = this.readArgNode.execute(frame);
            try {
                return new Object[]{self, this.asSsizeTNode.executeLongCached(arg, 1, 8)};
            }
            catch (UnexpectedResultException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            this.ensureReleaseNativeWrapperNode().execute(cArguments[0]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethFastcallRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, 1, PythonUtils.tsArray("self"), true, true);
        @Node.Child
        private ReadVarArgsNode readVarargsNode;

        public MethFastcallRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethFastcallRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
            this.readVarargsNode = ReadVarArgsNode.create(true);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object[] args = this.readVarargsNode.executeObjectArray(frame);
            return new Object[]{self, new CPyObjectArrayWrapper(args), args.length};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            CPyObjectArrayWrapper wrapper = (CPyObjectArrayWrapper)cArguments[1];
            wrapper.free(this.ensureReleaseNativeWrapperNode());
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethMethodRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(true, 1, PythonUtils.tsArray("self", "cls"), true, true);
        @Node.Child
        private PythonObjectFactory factory;
        @Node.Child
        private ReadIndexedArgumentNode readClsNode;
        @Node.Child
        private ReadVarArgsNode readVarargsNode;
        @Node.Child
        private ReadVarKeywordsNode readKwargsNode;

        public MethMethodRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethMethodRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
            this.factory = PythonObjectFactory.create();
            this.readClsNode = ReadIndexedArgumentNode.create(1);
            this.readVarargsNode = ReadVarArgsNode.create(true);
            this.readKwargsNode = ReadVarKeywordsNode.create(PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object cls = this.readClsNode.execute(frame);
            Object[] args = this.readVarargsNode.executeObjectArray(frame);
            PKeyword[] kwargs = this.readKwargsNode.executePKeyword(frame);
            Object[] fastcallArgs = new Object[args.length + kwargs.length];
            Object[] fastcallKwnames = new Object[kwargs.length];
            PythonUtils.arraycopy(args, 0, fastcallArgs, 0, args.length);
            for (int i = 0; i < kwargs.length; ++i) {
                fastcallKwnames[i] = kwargs[i].getName();
                fastcallArgs[args.length + i] = kwargs[i].getValue();
            }
            return new Object[]{self, cls, new CPyObjectArrayWrapper(fastcallArgs), args.length, this.factory.createTuple(fastcallKwnames)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
            CPyObjectArrayWrapper wrapper = (CPyObjectArrayWrapper)cArguments[2];
            wrapper.free(releaseNativeWrapperNode);
            releaseNativeWrapperNode.execute(cArguments[4]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethFastcallWithKeywordsRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(true, 1, PythonUtils.tsArray("self"), true, true);
        @Node.Child
        private PythonObjectFactory factory;
        @Node.Child
        private ReadVarArgsNode readVarargsNode;
        @Node.Child
        private ReadVarKeywordsNode readKwargsNode;

        public MethFastcallWithKeywordsRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethFastcallWithKeywordsRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
            this.factory = PythonObjectFactory.create();
            this.readVarargsNode = ReadVarArgsNode.create(true);
            this.readKwargsNode = ReadVarKeywordsNode.create(PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object[] args = this.readVarargsNode.executeObjectArray(frame);
            PKeyword[] kwargs = this.readKwargsNode.executePKeyword(frame);
            Object[] fastcallArgs = new Object[args.length + kwargs.length];
            PythonAbstractObject kwnamesTuple = PNone.NO_VALUE;
            PythonUtils.arraycopy(args, 0, fastcallArgs, 0, args.length);
            if (kwargs.length > 0) {
                Object[] fastcallKwnames = new Object[kwargs.length];
                for (int i = 0; i < kwargs.length; ++i) {
                    fastcallKwnames[i] = kwargs[i].getName();
                    fastcallArgs[args.length + i] = kwargs[i].getValue();
                }
                kwnamesTuple = this.factory.createTuple(fastcallKwnames);
            }
            return new Object[]{self, new CPyObjectArrayWrapper(fastcallArgs), args.length, kwnamesTuple};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            CPyObjectArrayWrapper wrapper = (CPyObjectArrayWrapper)cArguments[1];
            wrapper.free(this.ensureReleaseNativeWrapperNode());
            releaseNativeWrapperNode.execute(cArguments[3]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethORoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, -1, PythonUtils.tsArray("self", "arg"), true, true);
        @Node.Child
        private ReadIndexedArgumentNode readArgNode;

        public MethORoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethORoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
            this.readArgNode = ReadIndexedArgumentNode.create(1);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object arg = this.readArgNode.execute(frame);
            return new Object[]{self, arg};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            releaseNativeWrapperNode.execute(cArguments[1]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethNoargsRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, -1, PythonUtils.tsArray("self"), true, true);

        public MethNoargsRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethNoargsRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            return new Object[]{this.readSelf(frame), PNone.NONE};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            this.ensureReleaseNativeWrapperNode().execute(cArguments[0]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethInquiryRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, -1, PythonUtils.tsArray("self"), true, false);

        public MethInquiryRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethInquiryRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            return new Object[]{this.readSelf(frame)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            this.ensureReleaseNativeWrapperNode().execute(cArguments[0]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethVarargsRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(false, 1, PythonUtils.tsArray("self"), true, true);
        @Node.Child
        private PythonObjectFactory factory;
        @Node.Child
        private ReadVarArgsNode readVarargsNode;
        @Node.Child
        private CreateArgsTupleNode createArgsTupleNode;
        @Node.Child
        private ReleaseNativeSequenceStorageNode freeNode;
        private boolean seenNativeArgsTupleStorage;

        public MethVarargsRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethVarargsRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
            this.factory = PythonObjectFactory.create();
            this.readVarargsNode = ReadVarArgsNode.create(true);
            this.createArgsTupleNode = ExternalFunctionNodesFactory.CreateArgsTupleNodeGen.create();
            this.freeNode = ExternalFunctionNodesFactory.ReleaseNativeSequenceStorageNodeGen.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object[] args = this.readVarargsNode.executeObjectArray(frame);
            return new Object[]{self, this.createArgsTupleNode.execute(this.factory, args, this.seenNativeArgsTupleStorage)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            boolean freed = MethVarargsRoot.releaseArgsTuple(cArguments[1], this.freeNode, this.seenNativeArgsTupleStorage);
            if (!this.seenNativeArgsTupleStorage && freed) {
                this.seenNativeArgsTupleStorage = true;
            }
        }

        static boolean releaseArgsTuple(Object argsTupleObject, ReleaseNativeSequenceStorageNode freeNode, boolean eagerNativeStorage) {
            if (!PythonContext.get(freeNode).isNativeAccessAllowed()) {
                return false;
            }
            try {
                assert (argsTupleObject instanceof PythonObjectNativeWrapper);
                PythonObjectNativeWrapper argsTupleWrapper = (PythonObjectNativeWrapper)argsTupleObject;
                Object argsTuple = argsTupleWrapper.getDelegate();
                assert (argsTuple instanceof PTuple);
                SequenceStorage s = ((PTuple)argsTuple).getSequenceStorage();
                if (s instanceof NativeSequenceStorage) {
                    NativeSequenceStorage nativeSequenceStorage = (NativeSequenceStorage)s;
                    if (nativeSequenceStorage.hasReference()) {
                        return true;
                    }
                    assert (eagerNativeStorage);
                    if (argsTupleWrapper.getRefCount() == 10L) {
                        freeNode.execute(nativeSequenceStorage);
                    } else {
                        CApiTransitions.registerNativeSequenceStorage(nativeSequenceStorage);
                    }
                    return true;
                }
                return false;
            }
            catch (ClassCastException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    public static final class MethKeywordsRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(true, 1, PythonUtils.tsArray("self"), true, true);
        @Node.Child
        private PythonObjectFactory factory;
        @Node.Child
        private ReadVarArgsNode readVarargsNode;
        @Node.Child
        private ReadVarKeywordsNode readKwargsNode;
        @Node.Child
        private CreateArgsTupleNode createArgsTupleNode;
        @Node.Child
        private ReleaseNativeSequenceStorageNode freeNode;
        private boolean seenNativeArgsTupleStorage;

        public MethKeywordsRoot(PythonLanguage language, TruffleString name, boolean isStatic) {
            super(language, name, isStatic);
        }

        public MethKeywordsRoot(PythonLanguage language, TruffleString name, boolean isStatic, PExternalFunctionWrapper provider) {
            super(language, name, isStatic, provider);
            this.factory = PythonObjectFactory.create();
            this.readVarargsNode = ReadVarArgsNode.create(true);
            this.readKwargsNode = ReadVarKeywordsNode.create(PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
            this.createArgsTupleNode = ExternalFunctionNodesFactory.CreateArgsTupleNodeGen.create();
            this.freeNode = ExternalFunctionNodesFactory.ReleaseNativeSequenceStorageNodeGen.create();
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object self = this.readSelf(frame);
            Object[] args = this.readVarargsNode.executeObjectArray(frame);
            PKeyword[] kwargs = this.readKwargsNode.executePKeyword(frame);
            return new Object[]{self, this.createArgsTupleNode.execute(this.factory, args, this.seenNativeArgsTupleStorage), this.factory.createDict(kwargs)};
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            CExtNodes.ReleaseNativeWrapperNode releaseNativeWrapperNode = this.ensureReleaseNativeWrapperNode();
            releaseNativeWrapperNode.execute(cArguments[0]);
            boolean freed = MethVarargsRoot.releaseArgsTuple(cArguments[1], this.freeNode, this.seenNativeArgsTupleStorage);
            if (!this.seenNativeArgsTupleStorage && freed) {
                this.seenNativeArgsTupleStorage = true;
            }
            releaseNativeWrapperNode.execute(cArguments[2]);
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }
    }

    @GenerateInline(value=false)
    public static abstract class ExternalFunctionWrapperInvokeNode
    extends PNodeWithContext {
        public abstract Object execute(VirtualFrame var1, PExternalFunctionWrapper var2, CApiTiming var3, TruffleString var4, Object var5, Object[] var6);

        @NeverDefault
        static CExtCommonNodes.CheckFunctionResultNode createCheckResultNode(PExternalFunctionWrapper provider) {
            CExtCommonNodes.CheckFunctionResultNode node = provider.createCheckFunctionResultNode();
            return node != null ? node : ExternalFunctionNodesFactory.DefaultCheckFunctionResultNodeGen.create();
        }

        static CExtCommonNodes.CheckFunctionResultNode getUncachedCheckResultNode(PExternalFunctionWrapper provider) {
            CExtCommonNodes.CheckFunctionResultNode node = provider.getUncachedCheckFunctionResultNode();
            return node != null ? node : ExternalFunctionNodesFactory.DefaultCheckFunctionResultNodeGen.getUncached();
        }

        @Specialization
        static Object invokeCached(VirtualFrame frame, PExternalFunctionWrapper provider, CApiTiming timing, TruffleString name, Object callable, Object[] cArguments, @Bind(value="this") Node inliningTarget, @Cached(value="createCheckResultNode(provider)") CExtCommonNodes.CheckFunctionResultNode checkResultNode, @Cached(value="provider.createConvertRetNode()") CExtToJavaNode convertReturnValue, @Cached PForeignToPTypeNode fromForeign, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached ExternalFunctionInvokeNode invokeNode2) {
            CompilerAsserts.partialEvaluationConstant((Object)provider);
            PythonContext ctx = PythonContext.get(inliningTarget);
            return ExternalFunctionWrapperInvokeNode.invoke(frame, ctx, timing, name, callable, cArguments, inliningTarget, checkResultNode, convertReturnValue, fromForeign, getThreadStateNode, invokeNode2);
        }

        private static Object invoke(VirtualFrame frame, PythonContext ctx, CApiTiming timing, TruffleString name, Object callable, Object[] cArguments, Node inliningTarget, CExtCommonNodes.CheckFunctionResultNode checkResultNode, CExtToJavaNode convertReturnValue, PForeignToPTypeNode fromForeign, PythonContext.GetThreadStateNode getThreadStateNode, ExternalFunctionInvokeNode invokeNode2) {
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, ctx);
            Object result = invokeNode2.execute(frame, inliningTarget, threadState, timing, name, callable, cArguments);
            result = checkResultNode.execute(threadState, name, result);
            if (convertReturnValue != null) {
                result = convertReturnValue.execute(result);
            }
            return fromForeign.executeConvert(result);
        }

        @NeverDefault
        public static ExternalFunctionWrapperInvokeNode create() {
            return ExternalFunctionNodesFactory.ExternalFunctionWrapperInvokeNodeGen.create();
        }

        public static ExternalFunctionWrapperInvokeNode getUncached() {
            return ExternalFunctionWrapperInvokeNodeUncached.INSTANCE;
        }

        @GenerateCached(value=false)
        private static final class ExternalFunctionWrapperInvokeNodeUncached
        extends ExternalFunctionWrapperInvokeNode {
            private static final ExternalFunctionWrapperInvokeNodeUncached INSTANCE = new ExternalFunctionWrapperInvokeNodeUncached();

            private ExternalFunctionWrapperInvokeNodeUncached() {
            }

            @Override
            public Object execute(VirtualFrame frame, PExternalFunctionWrapper provider, CApiTiming timing, TruffleString name, Object callable, Object[] cArguments) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                PythonContext ctx = PythonContext.get(null);
                return ExternalFunctionWrapperInvokeNode.invoke(frame, ctx, timing, name, callable, cArguments, null, ExternalFunctionWrapperInvokeNodeUncached.getUncachedCheckResultNode(provider), provider.getUncachedConvertRetNode(), PForeignToPTypeNode.getUncached(), PythonContext.GetThreadStateNode.getUncached(), ExternalFunctionNodesFactory.ExternalFunctionInvokeNodeGen.getUncached());
            }
        }
    }

    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class ExternalFunctionInvokeNode
    extends PNodeWithContext {
        abstract Object execute(VirtualFrame var1, Node var2, PythonContext.PythonThreadState var3, CApiTiming var4, TruffleString var5, Object var6, Object[] var7);

        public final Object call(VirtualFrame frame, Node inliningTarget, PythonContext.PythonThreadState threadState, CApiTiming timing, TruffleString name, Object callable, Object ... cArguments) {
            return this.execute(frame, inliningTarget, threadState, timing, name, callable, cArguments);
        }

        @Specialization
        static Object invoke(VirtualFrame frame, Node inliningTarget, PythonContext.PythonThreadState threadState, CApiTiming timing, TruffleString name, Object callable, Object[] cArguments, @Cached(value="createFor(this)", uncached="getUncached()") IndirectCallData indirectCallData, @CachedLibrary(limit="2") InteropLibrary lib) {
            assert (threadState.getCurrentException() == null);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, threadState, indirectCallData);
            CApiTiming.enter();
            try {
                Object object = lib.execute(callable, cArguments);
                return object;
            }
            catch (UnsupportedMessageException | UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CALLING_NATIVE_FUNC_FAILED, name, e);
            }
            catch (ArityException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.CALLING_NATIVE_FUNC_EXPECTED_ARGS, name, e.getExpectedMinArity(), e.getActualArity());
            }
            catch (Throwable exception) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                GilNode.uncachedAcquire();
                throw exception;
            }
            finally {
                CApiTiming.exit(timing);
                if (frame != null && threadState.getCaughtException() != null) {
                    PArguments.setException((Frame)frame, threadState.getCaughtException());
                }
                ExecutionContext.IndirectCallContext.exit(frame, threadState, state);
            }
        }
    }

    static final class MethDirectRoot
    extends MethodDescriptorRoot {
        private static final Signature SIGNATURE = ExternalFunctionNodes.createSignature(true, 0, null, false, true);

        private MethDirectRoot(PythonLanguage lang, TruffleString name, PExternalFunctionWrapper provider) {
            super(lang, name, true, provider);
        }

        @Override
        protected Object[] prepareCArguments(VirtualFrame frame) {
            Object[] varargs = PArguments.getVariableArguments((Frame)frame);
            return PythonUtils.arrayCopyOf(varargs, varargs.length);
        }

        @Override
        protected void postprocessCArguments(VirtualFrame frame, Object[] cArguments) {
            for (int i = 0; i < cArguments.length; ++i) {
                this.ensureReleaseNativeWrapperNode().execute(cArguments[i]);
            }
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }

        @CompilerDirectives.TruffleBoundary
        public static MethDirectRoot create(PythonLanguage lang, TruffleString name, PExternalFunctionWrapper provider) {
            return new MethDirectRoot(lang, name, provider);
        }
    }

    public static final class PExternalFunctionWrapper
    extends Enum<PExternalFunctionWrapper>
    implements NativeCExtSymbol {
        public static final /* enum */ PExternalFunctionWrapper DIRECT = new PExternalFunctionWrapper(1, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper FASTCALL = new PExternalFunctionWrapper(2, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
        public static final /* enum */ PExternalFunctionWrapper FASTCALL_WITH_KEYWORDS = new PExternalFunctionWrapper(3, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper KEYWORDS = new PExternalFunctionWrapper(4, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper VARARGS = new PExternalFunctionWrapper(5, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper NOARGS = new PExternalFunctionWrapper(6, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper O = new PExternalFunctionWrapper(7, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper METHOD = new PExternalFunctionWrapper(8, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyTypeObject, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper ALLOC = new PExternalFunctionWrapper(10, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyTypeObject, ArgDescriptor.Py_ssize_t);
        public static final /* enum */ PExternalFunctionWrapper GETATTR = new PExternalFunctionWrapper(11, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.CharPtrAsTruffleString);
        public static final /* enum */ PExternalFunctionWrapper SETATTR = new PExternalFunctionWrapper(12, ArgDescriptor.InitResult, ArgDescriptor.PyObject, ArgDescriptor.CharPtrAsTruffleString, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper RICHCMP = new PExternalFunctionWrapper(13, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int);
        public static final /* enum */ PExternalFunctionWrapper SETITEM = new PExternalFunctionWrapper(14, ArgDescriptor.InitResult, ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper UNARYFUNC = new PExternalFunctionWrapper(15, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper BINARYFUNC = new PExternalFunctionWrapper(16, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper BINARYFUNC_L = new PExternalFunctionWrapper(17, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper BINARYFUNC_R = new PExternalFunctionWrapper(18, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper TERNARYFUNC = new PExternalFunctionWrapper(19, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper TERNARYFUNC_R = new PExternalFunctionWrapper(20, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper LT = new PExternalFunctionWrapper(21, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int);
        public static final /* enum */ PExternalFunctionWrapper LE = new PExternalFunctionWrapper(22, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int);
        public static final /* enum */ PExternalFunctionWrapper EQ = new PExternalFunctionWrapper(23, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int);
        public static final /* enum */ PExternalFunctionWrapper NE = new PExternalFunctionWrapper(24, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int);
        public static final /* enum */ PExternalFunctionWrapper GT = new PExternalFunctionWrapper(25, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int);
        public static final /* enum */ PExternalFunctionWrapper GE = new PExternalFunctionWrapper(26, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int);
        public static final /* enum */ PExternalFunctionWrapper ITERNEXT = new PExternalFunctionWrapper(27, ArgDescriptor.IterResult, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper INQUIRY = new PExternalFunctionWrapper(28, ArgDescriptor.InquiryResult, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper DELITEM = new PExternalFunctionWrapper(29, PExternalFunctionWrapper.defaults(1), ArgDescriptor.Int, ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper GETITEM = new PExternalFunctionWrapper(30, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t);
        public static final /* enum */ PExternalFunctionWrapper GETTER = new PExternalFunctionWrapper(31, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.Pointer);
        public static final /* enum */ PExternalFunctionWrapper SETTER = new PExternalFunctionWrapper(32, ArgDescriptor.InitResult, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Pointer);
        public static final /* enum */ PExternalFunctionWrapper INITPROC = new PExternalFunctionWrapper(33, ArgDescriptor.InitResult, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper HASHFUNC = new PExternalFunctionWrapper(34, ArgDescriptor.PrimitiveResult64, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper CALL = new PExternalFunctionWrapper(35, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper SETATTRO = new PExternalFunctionWrapper(36, ArgDescriptor.InitResult, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper DESCR_GET = new PExternalFunctionWrapper(37, PExternalFunctionWrapper.defaults(1), ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper DESCR_SET = new PExternalFunctionWrapper(38, ArgDescriptor.InitResult, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper LENFUNC = new PExternalFunctionWrapper(39, ArgDescriptor.PrimitiveResult64, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper OBJOBJPROC = new PExternalFunctionWrapper(40, ArgDescriptor.InquiryResult, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper OBJOBJARGPROC = new PExternalFunctionWrapper(41, ArgDescriptor.PrimitiveResult32, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper NEW = new PExternalFunctionWrapper(42, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper MP_DELITEM = new PExternalFunctionWrapper(43, ArgDescriptor.PrimitiveResult32, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper TP_STR = new PExternalFunctionWrapper(44, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper TP_REPR = new PExternalFunctionWrapper(45, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper DESCR_DELETE = new PExternalFunctionWrapper(46, ArgDescriptor.InitResult, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper DELATTRO = new PExternalFunctionWrapper(47, ArgDescriptor.InitResult, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject);
        public static final /* enum */ PExternalFunctionWrapper SSIZE_ARG = new PExternalFunctionWrapper(48, ArgDescriptor.PyObjectTransfer, ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t);
        public static final /* enum */ PExternalFunctionWrapper VISITPROC = new PExternalFunctionWrapper(49, ArgDescriptor.Int, ArgDescriptor.PyObject, ArgDescriptor.Pointer);
        public static final /* enum */ PExternalFunctionWrapper TRAVERSEPROC = new PExternalFunctionWrapper(50, ArgDescriptor.Int, ArgDescriptor.PyObject, ArgDescriptor.Pointer, ArgDescriptor.Pointer);
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final PExternalFunctionWrapper[] VALUES;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final PExternalFunctionWrapper[] BY_ID;
        public final String signature;
        public final ArgDescriptor returnValue;
        public final ArgDescriptor[] arguments;
        public final int numDefaults;
        private final int value;
        private static final /* synthetic */ PExternalFunctionWrapper[] $VALUES;

        public static PExternalFunctionWrapper[] values() {
            return (PExternalFunctionWrapper[])$VALUES.clone();
        }

        public static PExternalFunctionWrapper valueOf(String name) {
            return Enum.valueOf(PExternalFunctionWrapper.class, name);
        }

        private static int defaults(int x) {
            return x;
        }

        private PExternalFunctionWrapper(int value, int numDefaults, ArgDescriptor returnValue, ArgDescriptor ... arguments) {
            this.value = value;
            this.returnValue = returnValue;
            this.arguments = arguments;
            StringBuilder s = new StringBuilder("(");
            for (int i = 0; i < arguments.length; ++i) {
                s.append(i == 0 ? "" : ",");
                s.append(arguments[i].getNFISignature());
            }
            s.append("):").append(returnValue.getNFISignature());
            this.signature = s.toString();
            this.numDefaults = numDefaults;
        }

        private PExternalFunctionWrapper(int value, ArgDescriptor returnValue, ArgDescriptor ... arguments) {
            this(value, 0, returnValue, arguments);
        }

        static PExternalFunctionWrapper fromValue(int value) {
            return value >= 0 && value < BY_ID.length ? BY_ID[value] : null;
        }

        static PExternalFunctionWrapper fromMethodFlags(int flags) {
            if (CExtContext.isMethNoArgs(flags)) {
                return NOARGS;
            }
            if (CExtContext.isMethO(flags)) {
                return O;
            }
            if (CExtContext.isMethVarargsWithKeywords(flags)) {
                return KEYWORDS;
            }
            if (CExtContext.isMethVarargs(flags)) {
                return VARARGS;
            }
            if (CExtContext.isMethMethod(flags)) {
                return METHOD;
            }
            if (CExtContext.isMethFastcallWithKeywords(flags)) {
                return FASTCALL_WITH_KEYWORDS;
            }
            if (CExtContext.isMethFastcall(flags)) {
                return FASTCALL;
            }
            throw CompilerDirectives.shouldNotReachHere((String)"illegal method flags");
        }

        @CompilerDirectives.TruffleBoundary
        static RootCallTarget getOrCreateCallTarget(PExternalFunctionWrapper sig, PythonLanguage language, TruffleString name, boolean doArgAndResultConversion, boolean isStatic) {
            Function rootNodeFunction;
            Class nodeKlass;
            switch (sig.ordinal()) {
                case 8: 
                case 46: {
                    nodeKlass = AllocFuncRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new AllocFuncRootNode((PythonLanguage)((Object)l), name, sig) : l -> new AllocFuncRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case 0: 
                case 13: 
                case 14: 
                case 15: 
                case 32: 
                case 34: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 42: 
                case 43: {
                    if (!doArgAndResultConversion) {
                        return null;
                    }
                    nodeKlass = MethDirectRoot.class;
                    rootNodeFunction = l -> MethDirectRoot.create(language, name, sig);
                    break;
                }
                case 3: 
                case 31: 
                case 33: 
                case 40: {
                    if (!doArgAndResultConversion) {
                        return null;
                    }
                    nodeKlass = MethKeywordsRoot.class;
                    rootNodeFunction = l -> new MethKeywordsRoot((PythonLanguage)((Object)l), name, isStatic, sig);
                    break;
                }
                case 4: {
                    nodeKlass = MethVarargsRoot.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethVarargsRoot((PythonLanguage)((Object)l), name, isStatic, sig) : l -> new MethVarargsRoot((PythonLanguage)((Object)l), name, isStatic);
                    break;
                }
                case 26: {
                    nodeKlass = MethInquiryRoot.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethInquiryRoot((PythonLanguage)((Object)l), name, isStatic, sig) : l -> new MethInquiryRoot((PythonLanguage)((Object)l), name, isStatic);
                    break;
                }
                case 5: {
                    nodeKlass = MethNoargsRoot.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethNoargsRoot((PythonLanguage)((Object)l), name, isStatic, sig) : l -> new MethNoargsRoot((PythonLanguage)((Object)l), name, isStatic);
                    break;
                }
                case 6: {
                    nodeKlass = MethORoot.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethORoot((PythonLanguage)((Object)l), name, isStatic, sig) : l -> new MethORoot((PythonLanguage)((Object)l), name, isStatic);
                    break;
                }
                case 1: {
                    nodeKlass = MethFastcallRoot.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethFastcallRoot((PythonLanguage)((Object)l), name, isStatic, sig) : l -> new MethFastcallRoot((PythonLanguage)((Object)l), name, isStatic);
                    break;
                }
                case 2: {
                    nodeKlass = MethFastcallWithKeywordsRoot.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethFastcallWithKeywordsRoot((PythonLanguage)((Object)l), name, isStatic, sig) : l -> new MethFastcallWithKeywordsRoot((PythonLanguage)((Object)l), name, isStatic);
                    break;
                }
                case 7: {
                    nodeKlass = MethMethodRoot.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethMethodRoot((PythonLanguage)((Object)l), name, isStatic, sig) : l -> new MethMethodRoot((PythonLanguage)((Object)l), name, isStatic);
                    break;
                }
                case 9: {
                    nodeKlass = GetAttrFuncRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new GetAttrFuncRootNode((PythonLanguage)((Object)l), name, sig) : l -> new GetAttrFuncRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case 10: {
                    nodeKlass = SetAttrFuncRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new SetAttrFuncRootNode((PythonLanguage)((Object)l), name, sig) : l -> new SetAttrFuncRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case 35: {
                    nodeKlass = DescrGetRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new DescrGetRootNode((PythonLanguage)((Object)l), name, sig) : l -> new DescrGetRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case 44: {
                    nodeKlass = DescrGetRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new DescrDeleteRootNode((PythonLanguage)((Object)l), name, sig) : l -> new DescrDeleteRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case 45: {
                    nodeKlass = DelAttrRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new DelAttrRootNode((PythonLanguage)((Object)l), name, sig) : l -> new DelAttrRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case 11: {
                    nodeKlass = RichCmpFuncRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new RichCmpFuncRootNode((PythonLanguage)((Object)l), name, sig) : l -> new RichCmpFuncRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case 12: 
                case 27: {
                    nodeKlass = SetItemRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new SetItemRootNode((PythonLanguage)((Object)l), name, sig) : l -> new SetItemRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case 28: {
                    nodeKlass = GetItemRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new GetItemRootNode((PythonLanguage)((Object)l), name, sig) : l -> new GetItemRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case 16: {
                    nodeKlass = MethReverseRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethReverseRootNode((PythonLanguage)((Object)l), name, sig) : l -> new MethReverseRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case 17: {
                    nodeKlass = MethPowRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethPowRootNode((PythonLanguage)((Object)l), name, sig) : l -> new MethPowRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case 18: {
                    nodeKlass = MethRPowRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethRPowRootNode((PythonLanguage)((Object)l), name, sig) : l -> new MethRPowRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    nodeKlass = MethRichcmpOpRootNode.class;
                    int op = PExternalFunctionWrapper.getCompareOpCode(sig);
                    rootNodeFunction = doArgAndResultConversion ? l -> new MethRichcmpOpRootNode((PythonLanguage)((Object)l), name, sig, op) : l -> new MethRichcmpOpRootNode((PythonLanguage)((Object)l), name, op);
                    break;
                }
                case 25: {
                    nodeKlass = IterNextFuncRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new IterNextFuncRootNode((PythonLanguage)((Object)l), name, sig) : l -> new IterNextFuncRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                case 29: {
                    if (!doArgAndResultConversion) {
                        return null;
                    }
                    nodeKlass = GetterRoot.class;
                    rootNodeFunction = l -> new GetterRoot((PythonLanguage)((Object)l), name, sig);
                    break;
                }
                case 30: {
                    if (!doArgAndResultConversion) {
                        return null;
                    }
                    nodeKlass = SetterRoot.class;
                    rootNodeFunction = l -> new SetterRoot((PythonLanguage)((Object)l), name, sig);
                    break;
                }
                case 41: {
                    nodeKlass = MpDelItemRootNode.class;
                    rootNodeFunction = doArgAndResultConversion ? l -> new MpDelItemRootNode((PythonLanguage)((Object)l), name, sig) : l -> new MpDelItemRootNode((PythonLanguage)((Object)l), name);
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            return language.createCachedExternalFunWrapperCallTarget(rootNodeFunction, nodeKlass, sig, name, doArgAndResultConversion, isStatic);
        }

        public static PBuiltinFunction createWrapperFunction(TruffleString name, Object callable, Object enclosingType, int flags, int sig, PythonLanguage language, PythonObjectFactory factory, boolean doArgAndResultConversion) {
            return PExternalFunctionWrapper.createWrapperFunction(name, callable, enclosingType, flags, PExternalFunctionWrapper.fromValue(sig), language, factory, doArgAndResultConversion);
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createWrapperFunction(TruffleString name, Object callable, Object enclosingType, int flags, PExternalFunctionWrapper sig, PythonLanguage language, PythonObjectFactory factory, boolean doArgAndResultConversion) {
            PKeyword[] kwDefaults;
            RootCallTarget callTarget;
            LOGGER.finer(() -> PythonUtils.formatJString("ExternalFunctions.createWrapperFunction(%s, %s)", name, callable));
            assert (!PExternalFunctionWrapper.isClosurePointer(PythonContext.get(null), callable, InteropLibrary.getUncached((Object)callable)));
            if (flags < 0) {
                flags = 0;
            }
            int numDefaults = -1;
            TpSlot.TpSlotNative slot = null;
            if (callable instanceof RootCallTarget) {
                callTarget = (RootCallTarget)callable;
                RootNode rootNode = callTarget.getRootNode();
                if (rootNode instanceof BuiltinFunctionRootNode) {
                    BuiltinFunctionRootNode builtinFunctionRootNode = (BuiltinFunctionRootNode)rootNode;
                    numDefaults = PythonBuiltins.numDefaults(builtinFunctionRootNode.getBuiltin());
                }
                kwDefaults = PKeyword.EMPTY_KEYWORDS;
            } else if (callable instanceof BuiltinMethodDescriptor) {
                BuiltinMethodDescriptor builtinMethodDescriptor = (BuiltinMethodDescriptor)callable;
                callTarget = language.getDescriptorCallTarget(builtinMethodDescriptor);
                numDefaults = PythonBuiltins.numDefaults(builtinMethodDescriptor.getBuiltinAnnotation());
                kwDefaults = PKeyword.EMPTY_KEYWORDS;
            } else {
                callTarget = PExternalFunctionWrapper.getOrCreateCallTarget(sig, language, name, doArgAndResultConversion, CExtContext.isMethStatic(flags));
                if (callTarget == null) {
                    return null;
                }
                Object boundCallable = CExtCommonNodes.EnsureExecutableNode.executeUncached(callable, sig);
                kwDefaults = ExternalFunctionNodes.createKwDefaults(boundCallable);
                slot = TpSlot.TpSlotNative.createCExtSlot(boundCallable);
            }
            if (numDefaults == -1) {
                numDefaults = sig.numDefaults;
            }
            Object[] defaults = PBuiltinFunction.generateDefaults(numDefaults);
            Object type = enclosingType == PNone.NO_VALUE || SpecialMethodNames.T___NEW__.equalsUncached((AbstractTruffleString)name, PythonUtils.TS_ENCODING) ? null : enclosingType;
            switch (sig.ordinal()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return factory.createBuiltinFunction(name, type, defaults, kwDefaults, flags, callTarget);
                }
            }
            return factory.createWrapperDescriptor(name, type, defaults, kwDefaults, flags, callTarget, slot, sig);
        }

        @CompilerDirectives.TruffleBoundary
        public static PBuiltinFunction createWrapperFunction(TruffleString name, TpSlot.TpSlotCExtNative slot, Object enclosingType, PExternalFunctionWrapper sig, PythonLanguage language, PythonObjectFactory factory) {
            RootCallTarget callTarget = PExternalFunctionWrapper.getOrCreateCallTarget(sig, language, name, true, false);
            if (callTarget == null) {
                return null;
            }
            PKeyword[] kwDefaults = ExternalFunctionNodes.createKwDefaults(slot.getCallable());
            Object[] defaults = PBuiltinFunction.generateDefaults(sig.numDefaults);
            return factory.createWrapperDescriptor(name, enclosingType, defaults, kwDefaults, 0, callTarget, slot, sig);
        }

        private static boolean isClosurePointer(PythonContext context, Object callable, InteropLibrary lib) {
            if (lib.isPointer(callable)) {
                try {
                    Object delegate = context.getCApiContext().getClosureDelegate(lib.asPointer(callable));
                    return delegate instanceof PBuiltinFunction;
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return false;
        }

        private static int getCompareOpCode(PExternalFunctionWrapper sig) {
            switch (sig.ordinal()) {
                case 19: {
                    return 0;
                }
                case 20: {
                    return 1;
                }
                case 21: {
                    return 2;
                }
                case 22: {
                    return 3;
                }
                case 23: {
                    return 4;
                }
                case 24: {
                    return 5;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        CExtCommonNodes.CheckFunctionResultNode createCheckFunctionResultNode() {
            return this.returnValue.createCheckResultNode();
        }

        CExtCommonNodes.CheckFunctionResultNode getUncachedCheckFunctionResultNode() {
            return this.returnValue.getUncachedCheckResultNode();
        }

        CExtToJavaNode createConvertRetNode() {
            return this.returnValue.createNativeToPythonNode();
        }

        CExtToJavaNode getUncachedConvertRetNode() {
            return this.returnValue.getUncachedNativeToPythonNode();
        }

        CExtToNativeNode[] createConvertArgNodes() {
            return PExternalFunctionWrapper.createConvertArgNodes(this.arguments);
        }

        public static CExtToNativeNode[] createConvertArgNodes(ArgDescriptor[] descriptors) {
            CExtToNativeNode[] result = new CExtToNativeNode[descriptors.length];
            for (int i = 0; i < descriptors.length; ++i) {
                result[i] = descriptors[i].createPythonToNativeNode();
            }
            return result;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public TruffleString getTsName() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public String getSignature() {
            return this.signature;
        }

        private static /* synthetic */ PExternalFunctionWrapper[] $values() {
            return new PExternalFunctionWrapper[]{DIRECT, FASTCALL, FASTCALL_WITH_KEYWORDS, KEYWORDS, VARARGS, NOARGS, O, METHOD, ALLOC, GETATTR, SETATTR, RICHCMP, SETITEM, UNARYFUNC, BINARYFUNC, BINARYFUNC_L, BINARYFUNC_R, TERNARYFUNC, TERNARYFUNC_R, LT, LE, EQ, NE, GT, GE, ITERNEXT, INQUIRY, DELITEM, GETITEM, GETTER, SETTER, INITPROC, HASHFUNC, CALL, SETATTRO, DESCR_GET, DESCR_SET, LENFUNC, OBJOBJPROC, OBJOBJARGPROC, NEW, MP_DELITEM, TP_STR, TP_REPR, DESCR_DELETE, DELATTRO, SSIZE_ARG, VISITPROC, TRAVERSEPROC};
        }

        static {
            $VALUES = PExternalFunctionWrapper.$values();
            VALUES = PExternalFunctionWrapper.values();
            BY_ID = new PExternalFunctionWrapper[51];
            for (PExternalFunctionWrapper e : VALUES) {
                assert (BY_ID[e.value] == null);
                PExternalFunctionWrapper.BY_ID[e.value] = e;
            }
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class ToPythonStringNode
    extends CExtToJavaNode {
        @Specialization
        static Object doIt(Object object, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached CApiTransitions.NativeToPythonNode nativeToPythonNode) {
            Object result = nativeToPythonNode.execute(object);
            if (result == PNone.NO_VALUE) {
                return result;
            }
            return castToStringNode.castKnownString(inliningTarget, result);
        }

        @NeverDefault
        public static ToPythonStringNode create() {
            return ExternalFunctionNodesFactory.ToPythonStringNodeGen.create();
        }

        public static ToPythonStringNode getUncached() {
            return ExternalFunctionNodesFactory.ToPythonStringNodeGen.getUncached();
        }
    }

    @GenerateInline(value=false)
    public static final class ToNativeBorrowedNode
    extends CExtToNativeNode {
        @Node.Child
        private CApiTransitions.PythonToNativeNode toNative = CApiTransitionsFactory.PythonToNativeNodeGen.create();

        @Override
        public Object execute(Object object) {
            assert (object instanceof Double && Double.isNaN((Double)object) || !(object instanceof Number) && !(object instanceof TruffleString));
            return this.toNative.execute(object);
        }
    }

    @GenerateInline(value=false)
    public static abstract class ToInt32Node
    extends CExtToNativeNode {
        @Specialization
        static int doInt(int value) {
            return value;
        }

        @NeverDefault
        public static ToInt32Node create() {
            return ExternalFunctionNodesFactory.ToInt32NodeGen.create();
        }
    }

    @GenerateInline(value=false)
    public static abstract class ToInt64Node
    extends CExtToNativeNode {
        @Specialization
        static long doInt(int value) {
            return value;
        }

        @Specialization
        static long doLong(long value) {
            return value;
        }

        @Fallback
        static Object doOther(Object value) {
            assert (CApiTransitions.isBackendPointerObject(value));
            return value;
        }

        @NeverDefault
        public static ToInt64Node create() {
            return ExternalFunctionNodesFactory.ToInt64NodeGen.create();
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class FromUInt32Node
    extends CExtToJavaNode {
        @Specialization
        static int doInt(int value) {
            return value;
        }

        @Specialization
        static int doLong(long value) {
            assert (value < 0x100000000L);
            return (int)value;
        }

        @NeverDefault
        public static FromUInt32Node create() {
            return ExternalFunctionNodesFactory.FromUInt32NodeGen.create();
        }

        public static FromUInt32Node getUncached() {
            return ExternalFunctionNodesFactory.FromUInt32NodeGen.getUncached();
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class FromLongNode
    extends CExtToJavaNode {
        @Specialization
        static long doInt(int value) {
            return (long)value & 0xFFFFFFFFL;
        }

        @Specialization
        static long doLong(long value) {
            return value;
        }

        @Fallback
        static Object doOther(Object value) {
            assert (CApiTransitions.isBackendPointerObject(value));
            return value;
        }

        @NeverDefault
        public static FromLongNode create() {
            return ExternalFunctionNodesFactory.FromLongNodeGen.create();
        }

        public static FromLongNode getUncached() {
            return ExternalFunctionNodesFactory.FromLongNodeGen.getUncached();
        }
    }

    public static abstract class FinishArgNode
    extends PNodeWithContext {
        public abstract void execute(Object var1);
    }
}

