/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteOrder;

public abstract class UnicodeObjectNodes {

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class UnicodeAsWideCharNode
    extends Node {
        public final PBytes executeNativeOrder(Node inliningTarget, Object obj, long elementSize) {
            return this.execute(inliningTarget, obj, elementSize, ByteOrder.nativeOrder());
        }

        public final PBytes executeLittleEndian(Node inliningTarget, Object obj, long elementSize) {
            return this.execute(inliningTarget, obj, elementSize, ByteOrder.LITTLE_ENDIAN);
        }

        public final PBytes executeBigEndian(Node inliningTarget, Object obj, long elementSize) {
            return this.execute(inliningTarget, obj, elementSize, ByteOrder.BIG_ENDIAN);
        }

        public abstract PBytes execute(Node var1, Object var2, long var3, ByteOrder var5);

        @Specialization
        static PBytes doUnicode(Node inliningTarget, PString s, long elementSize, ByteOrder byteOrder, @Cached StringNodes.StringMaterializeNode materializeNode) {
            return UnicodeAsWideCharNode.doUnicode(materializeNode.execute(inliningTarget, s), elementSize, byteOrder);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PBytes doUnicode(TruffleString s, long elementSize, ByteOrder byteOrder) {
            TruffleString.Encoding encoding;
            if (elementSize == 4L) {
                encoding = byteOrder == ByteOrder.LITTLE_ENDIAN ? TruffleString.Encoding.UTF_32LE : TruffleString.Encoding.UTF_32BE;
            } else if (elementSize == 2L) {
                encoding = byteOrder == ByteOrder.LITTLE_ENDIAN ? TruffleString.Encoding.UTF_16LE : TruffleString.Encoding.UTF_16BE;
            } else {
                throw new RuntimeException("unsupported wchar size; was: " + elementSize);
            }
            return PythonObjectFactory.getUncached().createBytes(UnicodeAsWideCharNode.getBytes(s, encoding));
        }

        private static byte[] getBytes(TruffleString s, TruffleString.Encoding encoding) {
            TruffleString utf32String = s.switchEncodingUncached(encoding);
            int len = utf32String.byteLength(encoding);
            byte[] b = new byte[len];
            utf32String.copyToByteArrayUncached(0, b, 0, len, encoding);
            return b;
        }
    }
}

