/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.HandleStack;
import com.oracle.graal.python.builtins.objects.cext.common.LoadCExtException;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyBoxing;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCAccess;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCField;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeCache;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyContextSignatureType;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyMode;
import com.oracle.graal.python.builtins.objects.cext.hpy.jni.GraalHPyJNIContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.llvm.GraalHPyLLVMContext;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.call.CallTargetInvokeNode;
import com.oracle.graal.python.nodes.call.GenericInvokeNode;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonImageBuildOptions;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonSystemThreadTask;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.lang.invoke.VarHandle;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GraalHPyContext
extends CExtContext
implements TruffleObject {
    public static final int HPY_ABI_VERSION = 0;
    public static final int HPY_ABI_VERSION_MINOR = 0;
    public static final String HPY_ABI_TAG = "hpy0";
    private static final String J_HPY_INIT = "HPyInit_";
    private static final String J_HPY_MAJOR_VER_FUN = "get_required_hpy_major_version_";
    private static final String J_HPY_MINOR_VER_FUN = "get_required_hpy_minor_version_";
    private static final String LOGGER_HPY_NAME = "hpy";
    private static final String HPY_EXT = ".hpy";
    private static final TruffleLogger LOGGER = GraalHPyContext.getLogger(GraalHPyContext.class);
    public static final long SIZEOF_LONG = 8L;
    private static final long NATIVE_ARGUMENT_STACK_SIZE = 32768L;
    private static final Pattern SO_NAME_PATTERN = Pattern.compile(".*" + Pattern.quote(".hpy") + "(\\d+)(?:-[\\w-]+)?\\.so$");
    public static final int IMMUTABLE_HANDLE_COUNT = 256;
    private Object[] hpyHandleTable;
    private int nextHandle = 1;
    private Object[] hpyGlobalsTable = new Object[]{GraalHPyHandle.NULL_HANDLE_DELEGATE};
    private final HandleStack freeStack = new HandleStack(16);
    private final GraalHPyNativeContext backend;
    final boolean useNativeFastPaths;
    private HPyMode currentMode = HPyMode.MODE_UNIVERSAL;
    public static final int SINGLETON_HANDLE_NONE = 1;
    public static final int SINGLETON_HANDLE_NOT_IMPLEMENTED = 2;
    public static final int SINGLETON_HANDLE_ELIPSIS = 3;
    public final AtomicReference<GraalHPyHandleReference> references = new AtomicReference<Object>(null);
    private ReferenceQueue<Object> nativeSpaceReferenceQueue;
    @CompilerDirectives.CompilationFinal
    private RootCallTarget referenceCleanerCallTarget;
    private long nativeSpacePointers;
    private long nativeArgumentsStack = 0L;
    private long nativeArgumentStackTop = 0L;
    private final ScheduledExecutorService scheduler;

    public static TruffleLogger getLogger(Class<?> clazz) {
        return PythonLanguage.getLogger("hpy." + clazz.getSimpleName());
    }

    @CompilerDirectives.TruffleBoundary
    public static GraalHPyContext ensureHPyWasLoaded(Node node, PythonContext context, TruffleString name, TruffleString path) throws IOException, LoadCExtException.ApiInitException, LoadCExtException.ImportException {
        if (!context.hasHPyContext()) {
            CApiContext.ensureCapiWasLoaded(node, context, name, path);
            try {
                GraalHPyContext hPyContext = context.createHPyContext(GraalHPyLLVMContext.loadLLVMLibrary(context));
                assert (hPyContext == context.getHPyContext());
                return hPyContext;
            }
            catch (LoadCExtException.ApiInitException e) {
                throw e;
            }
            catch (Exception e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        return context.getHPyContext();
    }

    @CompilerDirectives.TruffleBoundary
    public static Object loadHPyModule(Node location, PythonContext context, TruffleString name, TruffleString path, Object spec, HPyMode mode) throws IOException, LoadCExtException.ApiInitException, LoadCExtException.ImportException {
        HPyABIVersion abiVersion;
        GraalHPyContext hpyUniversalContext = GraalHPyContext.ensureHPyWasLoaded(location, context, name, path);
        GraalHPyNativeContext backend = hpyUniversalContext.backend;
        Object llvmLibrary = backend.loadExtensionLibrary(location, context, name, path);
        String basename = GraalHPyContext.getBaseName(name).toJavaStringUncached();
        String hpyInitFuncName = J_HPY_INIT + basename;
        String hpyMajorVersionFuncName = J_HPY_MAJOR_VER_FUN + basename;
        String hpyMinorVersionFuncName = J_HPY_MINOR_VER_FUN + basename;
        try {
            abiVersion = backend.getHPyABIVersion(llvmLibrary, hpyMajorVersionFuncName, hpyMinorVersionFuncName);
        }
        catch (Exception e) {
            throw PRaiseNode.raiseUncached(location, PythonBuiltinClassType.RuntimeError, ErrorMessages.HPY_ERROR_LOADING_EXT_MODULE, path, hpyMajorVersionFuncName, hpyMinorVersionFuncName, e.getMessage());
        }
        if (abiVersion.major != 0 || abiVersion.minor > 0) {
            throw PRaiseNode.raiseUncached(location, PythonBuiltinClassType.RuntimeError, ErrorMessages.HPY_ABI_VERSION_ERROR, name, abiVersion.major, abiVersion.minor, 0, 0);
        }
        GraalHPyContext.validateABITag(location, basename, path.toJavaStringUncached(), abiVersion);
        HPyMode saved = hpyUniversalContext.currentMode;
        hpyUniversalContext.currentMode = mode;
        try {
            Object hpyModuleDefPtr = backend.initHPyModule(llvmLibrary, hpyInitFuncName, name, path, mode);
            assert (!(hpyModuleDefPtr instanceof PythonModule));
            if (InteropLibrary.getUncached().isNull(hpyModuleDefPtr)) {
                throw PRaiseNode.raiseUncached(location, PythonBuiltinClassType.RuntimeError, ErrorMessages.ERROR_LOADING_HPY_EXT_S_S, path, name);
            }
            Object module = GraalHPyNodesFactory.GraalHPyModuleCreateNodeGen.getUncached().execute(context.getHPyContext(), name, spec, hpyModuleDefPtr);
            if (module instanceof PythonModule) {
                PythonModule pythonModule = (PythonModule)module;
                GraalHPyNodesFactory.GraalHPyModuleExecNodeGen.getUncached().execute(location, context.getHPyContext(), pythonModule);
            }
            Object object = module;
            return object;
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw new LoadCExtException.ImportException(CExtContext.wrapJavaException(e, location), name, path, ErrorMessages.CANNOT_INITIALIZE_WITH, path, basename, "");
        }
        finally {
            hpyUniversalContext.currentMode = saved;
        }
    }

    private static void validateABITag(Node location, String shortname, String soname, HPyABIVersion abiVersion) {
        Matcher matcher = SO_NAME_PATTERN.matcher(soname);
        if (matcher.matches()) {
            String abiTagVersion = matcher.group(1);
            int abiTag = Integer.parseInt(abiTagVersion);
            if (abiTag != abiVersion.major) {
                throw PRaiseNode.raiseUncached(location, PythonBuiltinClassType.RuntimeError, ErrorMessages.HPY_ABI_TAG_MISMATCH, shortname, soname, abiTag, abiVersion.major, abiVersion.minor);
            }
            return;
        }
        throw PRaiseNode.raiseUncached(location, PythonBuiltinClassType.RuntimeError, ErrorMessages.HPY_NO_ABI_TAG, shortname, soname, abiVersion.major, abiVersion.minor);
    }

    public Object createArgumentsArray(Object[] args) {
        return this.backend.createArgumentsArray(args);
    }

    public void freeArgumentsArray(Object argsArray) {
        this.backend.freeArgumentsArray(argsArray);
    }

    public long createNativeArguments(Object[] delegate) {
        long arraySize;
        if (this.nativeArgumentsStack == 0L) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nativeArgumentsStack = this.getContext().getUnsafe().allocateMemory(32768L);
            this.nativeArgumentStackTop = this.nativeArgumentsStack + 32768L;
        }
        if (this.nativeArgumentsStack + (arraySize = (long)delegate.length * 8L) > this.nativeArgumentStackTop) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            String msg = String.format("overflow on native argument stack (requested size: %d bytes)", arraySize);
            LOGGER.severe(msg);
            throw new InternalError(msg);
        }
        long arrayPtr = this.nativeArgumentsStack;
        this.nativeArgumentsStack += arraySize;
        for (int i = 0; i < delegate.length; ++i) {
            Object element = delegate[i];
            CArrayWrappers.UNSAFE.putLong(arrayPtr + (long)i * 8L, this.pythonObjectAsBits(element));
        }
        return arrayPtr;
    }

    public void freeNativeArgumentsArray(int nargs) {
        this.freeNativeArgumentsUntil(this.nativeArgumentsStack - (long)nargs * 8L);
    }

    public void freeNativeArgumentsUntil(long basePtr) {
        assert (basePtr <= this.nativeArgumentsStack);
        for (long cur = basePtr; cur < this.nativeArgumentsStack; cur += 8L) {
            long h = CArrayWrappers.UNSAFE.getLong(cur);
            if (!GraalHPyBoxing.isBoxedHandle(h)) continue;
            this.releaseHPyHandleForObject(GraalHPyBoxing.unboxHandle(h));
        }
        this.nativeArgumentsStack = basePtr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GraalHPyContext(PythonContext context, Object hpyLibrary) throws LoadCExtException.ApiInitException {
        super(context, hpyLibrary, false);
        CompilerAsserts.neverPartOfCompilation();
        PythonLanguage language = context.getLanguage();
        int traceUpcallsInterval = language.getEngineOption(PythonOptions.HPyTraceUpcalls);
        Boolean shouldUseNativeFastPaths = language.getEngineOption(PythonOptions.HPyEnableJNIFastPaths);
        PythonOptions.HPyBackendMode backendMode = language.getEngineOption(PythonOptions.HPyBackend);
        this.nextHandle = 4;
        this.hpyHandleTable = new Object[512];
        this.hpyHandleTable[0] = GraalHPyHandle.NULL_HANDLE_DELEGATE;
        this.hpyHandleTable[1] = PNone.NONE;
        this.hpyHandleTable[2] = PNotImplemented.NOT_IMPLEMENTED;
        this.hpyHandleTable[3] = PEllipsis.INSTANCE;
        LOGGER.config("Using HPy backend:" + backendMode.name());
        if (backendMode == PythonOptions.HPyBackendMode.JNI) {
            if (PythonImageBuildOptions.WITHOUT_JNI) throw new LoadCExtException.ApiInitException(ErrorMessages.HPY_CANNOT_USE_JNI_BACKEND, new Object[0]);
            this.useNativeFastPaths = shouldUseNativeFastPaths;
            this.backend = new GraalHPyJNIContext(this, traceUpcallsInterval > 0);
        } else {
            if (backendMode == PythonOptions.HPyBackendMode.NFI) {
                throw new LoadCExtException.ApiInitException(ErrorMessages.HPY_NFI_NOT_YET_IMPLEMENTED, new Object[0]);
            }
            if (backendMode != PythonOptions.HPyBackendMode.LLVM) throw new LoadCExtException.ApiInitException(ErrorMessages.HPY_UNKNOWN_BACKEND, TruffleString.fromJavaStringUncached((String)backendMode.name(), (TruffleString.Encoding)PythonUtils.TS_ENCODING));
            this.useNativeFastPaths = false;
            this.backend = new GraalHPyLLVMContext(this, traceUpcallsInterval > 0);
        }
        this.backend.initNativeContext();
        this.nextHandle = 256;
        assert (this.getHPyHandleForObject(PNone.NONE) == 1);
        assert (this.getHPyHandleForObject(PEllipsis.INSTANCE) == 3);
        assert (this.getHPyHandleForObject(PNotImplemented.NOT_IMPLEMENTED) == 2);
        if (traceUpcallsInterval > 0) {
            this.scheduler = Executors.newScheduledThreadPool(1);
            this.startUpcallsDaemon(traceUpcallsInterval);
            return;
        } else {
            this.scheduler = null;
        }
    }

    private RootCallTarget getReferenceCleanerCallTarget() {
        if (this.referenceCleanerCallTarget == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            RootCallTarget localTarget = PythonUtils.getOrCreateCallTarget(new HPyNativeSpaceCleanerRootNode(this.getContext()));
            VarHandle.storeStoreFence();
            this.referenceCleanerCallTarget = localTarget;
        }
        return this.referenceCleanerCallTarget;
    }

    public void initHPyDebugContext() throws LoadCExtException.ApiInitException {
        this.backend.initHPyDebugContext();
    }

    public PythonModule getHPyDebugModule() throws LoadCExtException.ImportException {
        return this.backend.getHPyDebugModule();
    }

    public PythonModule getHPyTraceModule() throws LoadCExtException.ImportException {
        return this.backend.getHPyTraceModule();
    }

    HPyMode getCurrentMode() {
        return this.currentMode;
    }

    public GraalHPyNativeContext getBackend() {
        return this.backend;
    }

    public GraalHPyHandle createHandle(Object delegate) {
        return GraalHPyHandle.create(delegate);
    }

    public GraalHPyHandle createField(Object delegate, int idx) {
        return GraalHPyHandle.createField(delegate, idx);
    }

    public int createGlobal(Object delegate, int idx) {
        assert (!GilNode.getUncached().acquire(PythonContext.get(null))) : "Gil not held when creating global";
        int newIdx = idx <= 0 ? this.allocateHPyGlobal() : idx;
        this.hpyGlobalsTable[newIdx] = delegate;
        if (this.useNativeFastPaths) {
            this.mirrorGlobalNativeSpacePointerToNative(delegate, newIdx);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(PythonUtils.formatJString("allocating HPy global %d (object: %s)", newIdx, delegate));
        }
        return newIdx;
    }

    int getEndIndexOfGlobalTable() {
        for (int i = this.hpyGlobalsTable.length - 1; i > 0; --i) {
            if (this.hpyGlobalsTable[i] == null) continue;
            return i + 1;
        }
        return this.hpyGlobalsTable.length;
    }

    @CompilerDirectives.TruffleBoundary
    void initBatchGlobals(int startIdx, int nModuleGlobals) {
        if (nModuleGlobals == 0) {
            return;
        }
        int endIdx = startIdx + nModuleGlobals;
        int gtLen = this.hpyGlobalsTable.length;
        if (endIdx >= gtLen) {
            int newSize = endIdx + 1;
            LOGGER.fine(() -> PythonUtils.formatJString("resizing HPy globals table to %d", newSize));
            this.hpyGlobalsTable = Arrays.copyOf(this.hpyGlobalsTable, newSize);
            if (this.useNativeFastPaths) {
                this.reallocateNativeSpacePointersMirror(this.hpyHandleTable.length, gtLen);
            }
        }
        Arrays.fill(this.hpyGlobalsTable, startIdx, endIdx, GraalHPyHandle.NULL_HANDLE_DELEGATE);
        if (this.useNativeFastPaths) {
            GraalHPyNativeCache.initGlobalsNativeSpacePointer(this.nativeSpacePointers, this.hpyHandleTable.length, startIdx, nModuleGlobals);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private int allocateHPyGlobal() {
        int handle = 0;
        for (int i = 1; i < this.hpyGlobalsTable.length; ++i) {
            if (this.hpyGlobalsTable[i] != null) continue;
            handle = i;
            break;
        }
        if (handle == 0) {
            handle = this.hpyGlobalsTable.length;
            int newSize = Math.max(16, this.hpyGlobalsTable.length * 2);
            LOGGER.fine(() -> "resizing HPy globals table to " + newSize);
            this.hpyGlobalsTable = Arrays.copyOf(this.hpyGlobalsTable, newSize);
            if (this.useNativeFastPaths) {
                this.reallocateNativeSpacePointersMirror(this.hpyHandleTable.length, handle);
            }
        }
        return handle;
    }

    private int resizeHandleTable() {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.nextHandle == this.hpyHandleTable.length);
        int oldSize = this.hpyHandleTable.length;
        int newSize = Math.max(16, this.hpyHandleTable.length * 2);
        LOGGER.fine(() -> "resizing HPy handle table to " + newSize);
        this.hpyHandleTable = Arrays.copyOf(this.hpyHandleTable, newSize);
        if (this.useNativeFastPaths) {
            this.reallocateNativeSpacePointersMirror(oldSize, this.hpyGlobalsTable.length);
        }
        return this.nextHandle++;
    }

    public int getHPyHandleForObject(Object object) {
        assert (!(object instanceof GraalHPyHandle));
        int singletonHandle = GraalHPyContext.getHPyHandleForSingleton(object);
        if (singletonHandle != -1) {
            return singletonHandle;
        }
        return this.getHPyHandleForNonSingleton(object);
    }

    public static int getHPyHandleForSingleton(Object object) {
        assert (!(object instanceof GraalHPyHandle));
        return GetHPyHandleForSingleton.doGeneric(object);
    }

    public int getHPyContextHandle(Object object) {
        CompilerAsserts.neverPartOfCompilation();
        assert (GraalHPyContext.getHPyHandleForSingleton(object) == -1);
        assert (this.freeStack.getTop() == 0);
        assert (this.nextHandle < this.hpyHandleTable.length);
        if (this.nextHandle >= 256) {
            throw CompilerDirectives.shouldNotReachHere((String)"attempting to create context handle after initialization");
        }
        int i = this.nextHandle++;
        assert (this.hpyHandleTable[i] == null);
        this.hpyHandleTable[i] = object;
        return i;
    }

    public int getHPyHandleForNonSingleton(Object object) {
        assert (!(object instanceof GraalHPyHandle));
        int handle = this.freeStack.pop();
        if (handle == -1) {
            if (this.nextHandle < this.hpyHandleTable.length) {
                handle = this.nextHandle++;
            } else {
                CompilerDirectives.transferToInterpreter();
                handle = this.resizeHandleTable();
            }
        }
        assert (0 <= handle && handle < this.hpyHandleTable.length);
        assert (this.hpyHandleTable[handle] == null);
        this.hpyHandleTable[handle] = object;
        if (this.useNativeFastPaths) {
            this.mirrorNativeSpacePointerToNative(object, handle);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(PythonUtils.formatJString("allocating HPy handle %d (object: %s)", handle, object));
        }
        return handle;
    }

    public Object bitsAsPythonObject(long bits) {
        if (GraalHPyBoxing.isBoxedNullHandle(bits)) {
            return GraalHPyHandle.NULL_HANDLE_DELEGATE;
        }
        if (GraalHPyBoxing.isBoxedInt(bits)) {
            return GraalHPyBoxing.unboxInt(bits);
        }
        if (GraalHPyBoxing.isBoxedDouble(bits)) {
            return GraalHPyBoxing.unboxDouble(bits);
        }
        assert (GraalHPyBoxing.isBoxedHandle(bits));
        return this.getObjectForHPyHandle(GraalHPyBoxing.unboxHandle(bits));
    }

    public long pythonObjectAsBits(Object object) {
        if (GraalHPyBoxing.isBoxablePrimitive(object)) {
            if (object instanceof Integer) {
                return GraalHPyBoxing.boxInt((Integer)object);
            }
            assert (object instanceof Double);
            return GraalHPyBoxing.boxDouble((Double)object);
        }
        if (object == GraalHPyHandle.NULL_HANDLE_DELEGATE) {
            return 0L;
        }
        return this.getHPyHandleForObject(object);
    }

    @CompilerDirectives.TruffleBoundary
    private void mirrorNativeSpacePointerToNative(Object delegate, int handleID) {
        long l;
        assert (this.useNativeFastPaths);
        if (delegate instanceof PythonObject) {
            Object nativeSpace = GraalHPyNodes.HPyGetNativeSpacePointerNode.doPythonObject((PythonObject)delegate);
            try {
                l = nativeSpace instanceof Long ? ((Long)nativeSpace).longValue() : InteropLibrary.getUncached().asPointer(nativeSpace);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        } else {
            l = 0L;
        }
        GraalHPyNativeCache.putHandleNativeSpacePointer(this.nativeSpacePointers, handleID, l);
    }

    @CompilerDirectives.TruffleBoundary
    private void mirrorGlobalNativeSpacePointerToNative(Object delegate, int globalID) {
        long l;
        assert (this.useNativeFastPaths);
        if (delegate instanceof PythonObject) {
            Object nativeSpace = GraalHPyNodes.HPyGetNativeSpacePointerNode.doPythonObject((PythonObject)delegate);
            try {
                l = nativeSpace instanceof Long ? ((Long)nativeSpace).longValue() : InteropLibrary.getUncached().asPointer(nativeSpace);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        } else {
            l = 0L;
        }
        GraalHPyNativeCache.putGlobalNativeSpacePointer(this.nativeSpacePointers, this.hpyHandleTable.length, globalID, l);
    }

    @CompilerDirectives.TruffleBoundary
    private void reallocateNativeSpacePointersMirror(int oldHandleTabelSize, int oldGlobalsTableSize) {
        assert (this.useNativeFastPaths);
        this.nativeSpacePointers = GraalHPyNativeCache.reallocateNativeCache(this.nativeSpacePointers, oldHandleTabelSize, this.hpyHandleTable.length, oldGlobalsTableSize, this.hpyGlobalsTable.length);
        this.backend.setNativeCache(this.nativeSpacePointers);
    }

    @CompilerDirectives.TruffleBoundary
    void allocateNativeSpacePointersMirror() {
        long arrayPtr;
        this.nativeSpacePointers = arrayPtr = GraalHPyNativeCache.allocateNativeCache(this.hpyHandleTable.length, this.hpyGlobalsTable.length);
        for (int i = 1; i < this.hpyHandleTable.length; ++i) {
            Object delegate = this.hpyHandleTable[i];
            if (delegate == null) continue;
            this.mirrorNativeSpacePointerToNative(delegate, i);
        }
        this.backend.setNativeCache(arrayPtr);
    }

    public Object getObjectForHPyHandle(int handle) {
        assert (!GraalHPyBoxing.isBoxedInt(handle) && !GraalHPyBoxing.isBoxedDouble(handle)) : "trying to lookup boxed primitive";
        return this.hpyHandleTable[handle];
    }

    public Object getObjectForHPyGlobal(int handle) {
        assert (!GraalHPyBoxing.isBoxedInt(handle) && !GraalHPyBoxing.isBoxedDouble(handle)) : "trying to lookup boxed primitive";
        return this.hpyGlobalsTable[handle];
    }

    public boolean releaseHPyHandleForObject(int handle) {
        assert (handle != 0) : "NULL handle cannot be released";
        assert (this.hpyHandleTable[handle] != null) : PythonUtils.formatJString("releasing handle that has already been released: %d", handle);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(PythonUtils.formatJString("releasing HPy handle %d (object: %s)", handle, this.hpyHandleTable[handle]));
        }
        if (handle < 256) {
            return false;
        }
        this.hpyHandleTable[handle] = null;
        this.freeStack.push(handle);
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public void createHandleReference(Object pythonObject, Object dataPtr, Object destroyFunc) {
        GraalHPyHandleReference newHead = new GraalHPyHandleReference(pythonObject, this.ensureReferenceQueue(), dataPtr, destroyFunc);
        this.references.getAndAccumulate(newHead, (prev, x) -> {
            x.next = prev;
            return x;
        });
    }

    private ReferenceQueue<Object> ensureReferenceQueue() {
        if (this.nativeSpaceReferenceQueue == null) {
            ReferenceQueue<Object> referenceQueue = this.createReferenceQueue();
            this.nativeSpaceReferenceQueue = referenceQueue;
            return referenceQueue;
        }
        return this.nativeSpaceReferenceQueue;
    }

    @CompilerDirectives.TruffleBoundary
    private ReferenceQueue<Object> createReferenceQueue() {
        ReferenceQueue<Object> referenceQueue = new ReferenceQueue<Object>();
        PythonContext context = this.getContext();
        TruffleLanguage.Env env = context.getEnv();
        if (env.isCreateThreadAllowed()) {
            context.createSystemThread(new GraalHPyReferenceCleanerRunnable(referenceQueue)).start();
        } else {
            context.registerAsyncAction(() -> {
                Reference reference = null;
                if (PythonOptions.AUTOMATIC_ASYNC_ACTIONS) {
                    try {
                        reference = referenceQueue.remove();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    referenceQueue.poll();
                }
                ArrayList<GraalHPyHandleReference> refs = new ArrayList<GraalHPyHandleReference>();
                do {
                    if (!(reference instanceof GraalHPyHandleReference)) continue;
                    refs.add((GraalHPyHandleReference)reference);
                } while ((reference = referenceQueue.poll()) != null);
                if (!refs.isEmpty()) {
                    return new GraalHPyHandleReferenceCleanerAction(refs.toArray(new GraalHPyHandleReference[0]));
                }
                return null;
            });
        }
        return referenceQueue;
    }

    public int getCTypeSize(HPyContextSignatureType ctype) {
        return this.backend.getCTypeSize(ctype);
    }

    public int getCFieldOffset(GraalHPyCField ctype) {
        return this.backend.getCFieldOffset(ctype);
    }

    public Object nativeToInteropPointer(Object object) {
        return this.backend.nativeToInteropPointer(object);
    }

    public Object getNativeNull() {
        return this.backend.getNativeNull();
    }

    public void finalizeContext() {
        this.backend.finalizeNativeContext();
        if (this.nativeArgumentsStack != 0L) {
            CArrayWrappers.UNSAFE.freeMemory(this.nativeArgumentsStack);
            this.nativeArgumentsStack = 0L;
        }
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    private void startUpcallsDaemon(long interval) {
        this.scheduler.scheduleAtFixedRate(() -> {
            HPyUpcall[] upcalls = this.backend.getUpcalls();
            int[] counts = this.backend.getUpcallCounts();
            StringBuilder sb = new StringBuilder();
            sb.append("========= HPy context upcall counts (").append(this.backend.getName()).append(')');
            for (int i = 0; i < counts.length; ++i) {
                if (counts[i] == 0) continue;
                sb.append(String.format("  %40s[%3d]: %d\n", upcalls[i].getName(), i, counts[i]));
            }
            System.out.print(sb);
            System.out.flush();
        }, interval, interval, TimeUnit.MILLISECONDS);
    }

    @CompilerDirectives.ValueType
    public record HPyABIVersion(int major, int minor) {
    }

    private static final class HPyNativeSpaceCleanerRootNode
    extends PRootNode {
        private static final Signature SIGNATURE = new Signature(-1, false, -1, false, PythonUtils.tsArray("refs"), PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
        private static final TruffleLogger LOGGER = GraalHPyContext.getLogger(HPyNativeSpaceCleanerRootNode.class);
        @Node.Child
        private GraalHPyCAccess.BulkFreeHandleReferencesNode callBulkFree;
        private final LoopConditionProfile loopProfile = LoopConditionProfile.create();

        HPyNativeSpaceCleanerRootNode(PythonContext context) {
            super(context.getLanguage());
        }

        public Object execute(VirtualFrame frame) {
            GraalHPyHandleReference[] handleReferences = (GraalHPyHandleReference[])PArguments.getArgument((Frame)frame, 0);
            GraalHPyHandleReference refList = (GraalHPyHandleReference)PArguments.getArgument((Frame)frame, 1);
            GraalHPyHandleReference oldRefList = (GraalHPyHandleReference)PArguments.getArgument((Frame)frame, 2);
            long startTime = 0L;
            long middleTime = 0L;
            int n = handleReferences.length;
            boolean loggable = LOGGER.isLoggable(Level.FINE);
            if (loggable) {
                startTime = System.currentTimeMillis();
            }
            GraalHPyContext context = PythonContext.get((Node)this).getHPyContext();
            this.loopProfile.profileCounted((long)n);
            int i = 0;
            while (this.loopProfile.inject(i < n)) {
                handleReferences[i].cleaned = true;
                ++i;
            }
            GraalHPyHandleReference prev = null;
            GraalHPyHandleReference cur = refList;
            while (cur != null) {
                if (cur.cleaned) {
                    if (prev != null) {
                        prev.next = cur.next;
                    } else {
                        refList = cur.next;
                    }
                } else {
                    prev = cur;
                }
                cur = cur.next;
            }
            if (prev != null) {
                prev.next = oldRefList;
            } else {
                refList = oldRefList;
            }
            if (loggable) {
                middleTime = System.currentTimeMillis();
            }
            if (this.callBulkFree == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callBulkFree = (GraalHPyCAccess.BulkFreeHandleReferencesNode)this.insert(GraalHPyCAccess.BulkFreeHandleReferencesNode.create(context));
            }
            this.callBulkFree.execute(context, handleReferences);
            if (loggable) {
                long countDuration = middleTime - startTime;
                long duration = System.currentTimeMillis() - middleTime;
                LOGGER.fine(PythonUtils.formatJString("Cleaned references: %d", n));
                LOGGER.fine(PythonUtils.formatJString("Count duration: %d", countDuration));
                LOGGER.fine(PythonUtils.formatJString("Duration: %d", duration));
            }
            return refList;
        }

        @Override
        public Signature getSignature() {
            return SIGNATURE;
        }

        public String getName() {
            return "hpy_native_reference_cleaner";
        }

        public boolean isInternal() {
            return true;
        }

        @Override
        public boolean isPythonInternal() {
            return true;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class GetHPyHandleForSingleton
    extends Node {
        public abstract int execute(Object var1);

        @Specialization(guards={"isNoValue(x)"})
        static int doNoValue(PNone x) {
            return 0;
        }

        @Specialization(guards={"!isNoValue(x)"})
        static int doNone(PNone x) {
            return 1;
        }

        @Specialization
        static int doEllipsis(PEllipsis x) {
            return 3;
        }

        @Specialization
        static int doNotImplemented(PNotImplemented x) {
            return 2;
        }

        @Specialization(guards={"!isSingleton(delegate)"})
        static int doOthers(Object delegate) {
            return -1;
        }

        @Specialization(replaces={"doNoValue", "doNone", "doEllipsis", "doNotImplemented", "doOthers"})
        static int doGeneric(Object object) {
            if (object == PNone.NO_VALUE) {
                return 0;
            }
            if (object == PNone.NONE) {
                return 1;
            }
            if (object == PEllipsis.INSTANCE) {
                return 3;
            }
            if (object == PNotImplemented.NOT_IMPLEMENTED) {
                return 2;
            }
            return -1;
        }

        static boolean isSingleton(Object object) {
            return object == PNone.NONE || object == PEllipsis.INSTANCE || object == PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    public static final class GraalHPyHandleReference
    extends WeakReference<Object> {
        private final Object nativeSpace;
        private final Object destroyFunc;
        boolean cleaned;
        private GraalHPyHandleReference next;

        public GraalHPyHandleReference(Object referent, ReferenceQueue<Object> q, Object nativeSpace, Object destroyFunc) {
            super(referent, q);
            this.nativeSpace = nativeSpace;
            this.destroyFunc = destroyFunc;
        }

        public Object getNativeSpace() {
            return this.nativeSpace;
        }

        public Object getDestroyFunc() {
            return this.destroyFunc;
        }

        public GraalHPyHandleReference getNext() {
            return this.next;
        }

        public void setNext(GraalHPyHandleReference next) {
            this.next = next;
        }
    }

    static final class GraalHPyReferenceCleanerRunnable
    extends PythonSystemThreadTask {
        private static final TruffleLogger LOGGER = GraalHPyContext.getLogger(GraalHPyReferenceCleanerRunnable.class);
        private final ReferenceQueue<?> referenceQueue;
        private GraalHPyHandleReference cleanerList;

        GraalHPyReferenceCleanerRunnable(ReferenceQueue<?> referenceQueue) {
            super("HPy reference cleaner", LOGGER);
            this.referenceQueue = referenceQueue;
        }

        @Override
        public void doRun() {
            PythonContext pythonContext = PythonContext.get(null);
            PythonLanguage language = pythonContext.getLanguage();
            GraalHPyContext hPyContext = pythonContext.getHPyContext();
            RootCallTarget callTarget = hPyContext.getReferenceCleanerCallTarget();
            PDict dummyGlobals = pythonContext.factory().createDict();
            boolean isLoggable = LOGGER.isLoggable(Level.FINE);
            RootNode location = language.unavailableSafepointLocation;
            while (!pythonContext.getThreadState(language).isShuttingDown()) {
                GraalHPyHandleReference refList;
                Reference<?> reference = (Reference<?>)TruffleSafepoint.setBlockedThreadInterruptibleFunction((Node)location, ReferenceQueue::remove, this.referenceQueue);
                ArrayList<GraalHPyHandleReference> refs = new ArrayList<GraalHPyHandleReference>();
                do {
                    if (reference instanceof GraalHPyHandleReference) {
                        refs.add((GraalHPyHandleReference)reference);
                    }
                    reference = this.referenceQueue.poll();
                    TruffleSafepoint.poll((Node)location);
                } while (reference != null);
                if (isLoggable) {
                    LOGGER.fine(PythonUtils.formatJString("Collected references: %d", refs.size()));
                }
                int retries = 0;
                while ((refList = (GraalHPyHandleReference)hPyContext.references.getAndSet(null)) == null && retries++ < 3) {
                }
                if (refs.isEmpty()) continue;
                try {
                    Object[] arguments = PArguments.create(3);
                    PArguments.setGlobals(arguments, dummyGlobals);
                    PArguments.setException(arguments, (AbstractTruffleException)PException.NO_EXCEPTION);
                    PArguments.setCallerFrameInfo(arguments, PFrame.Reference.EMPTY);
                    PArguments.setArgument(arguments, 0, refs.toArray(new GraalHPyHandleReference[0]));
                    PArguments.setArgument(arguments, 1, refList);
                    PArguments.setArgument(arguments, 2, this.cleanerList);
                    this.cleanerList = (GraalHPyHandleReference)CallTargetInvokeNode.invokeUncached(callTarget, arguments);
                }
                catch (PException e) {
                    e.materializeMessage();
                    LOGGER.warning("HPy reference cleaner thread received a Python exception: " + String.valueOf((Object)e));
                }
            }
        }
    }

    public static interface HPyUpcall {
        public String getName();
    }

    private static final class GraalHPyHandleReferenceCleanerAction
    implements AsyncHandler.AsyncAction {
        private final GraalHPyHandleReference[] nativeObjectReferences;

        public GraalHPyHandleReferenceCleanerAction(GraalHPyHandleReference[] nativeObjectReferences) {
            this.nativeObjectReferences = nativeObjectReferences;
        }

        @Override
        public void execute(PythonContext context) {
            Object[] pArguments = PArguments.create(1);
            PArguments.setArgument(pArguments, 0, this.nativeObjectReferences);
            GenericInvokeNode.getUncached().execute(context.getHPyContext().getReferenceCleanerCallTarget(), pArguments);
        }
    }

    public static enum LLVMType {
        HPyFunc_noargs,
        HPyFunc_o,
        HPyFunc_varargs,
        HPyFunc_keywords,
        HPyFunc_unaryfunc,
        HPyFunc_binaryfunc,
        HPyFunc_ternaryfunc,
        HPyFunc_inquiry,
        HPyFunc_lenfunc,
        HPyFunc_ssizeargfunc,
        HPyFunc_ssizessizeargfunc,
        HPyFunc_ssizeobjargproc,
        HPyFunc_ssizessizeobjargproc,
        HPyFunc_objobjargproc,
        HPyFunc_freefunc,
        HPyFunc_getattrfunc,
        HPyFunc_getattrofunc,
        HPyFunc_setattrfunc,
        HPyFunc_setattrofunc,
        HPyFunc_reprfunc,
        HPyFunc_hashfunc,
        HPyFunc_richcmpfunc,
        HPyFunc_getiterfunc,
        HPyFunc_iternextfunc,
        HPyFunc_descrgetfunc,
        HPyFunc_descrsetfunc,
        HPyFunc_initproc,
        HPyFunc_getter,
        HPyFunc_setter,
        HPyFunc_objobjproc,
        HPyFunc_traverseproc,
        HPyFunc_destructor,
        HPyFunc_getbufferproc,
        HPyFunc_releasebufferproc,
        HPyFunc_destroyfunc,
        HPyModule_init,
        HPyModule_create;

    }
}

