/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.foreign;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.foreign.ForeignBooleanBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.foreign.ForeignBooleanBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotInquiry;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ForeignBoolean})
public final class ForeignBooleanBuiltins
extends PythonBuiltins {
    public static TpSlots SLOTS = ForeignBooleanBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ForeignBooleanBuiltinsFactory.getFactories();
    }

    @Builtins(value={@Builtin(name="__str__", minNumOfPositionalArgs=1), @Builtin(name="__repr__", minNumOfPositionalArgs=1)})
    @GenerateNodeFactory
    static abstract class StrNode
    extends PythonUnaryBuiltinNode {
        StrNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object str(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="3") InteropLibrary lib, @Cached GilNode gil, @Cached PyObjectStrAsTruffleStringNode strNode) {
            Boolean value;
            try {
                gil.release(true);
                try {
                    value = lib.asBoolean(object);
                }
                finally {
                    gil.acquire();
                }
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            return strNode.execute((Frame)frame, inliningTarget, value);
        }
    }

    @Builtin(name="__index__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IndexNode
    extends PythonUnaryBuiltinNode {
        IndexNode() {
        }

        @Specialization(limit="3")
        protected static int doIt(Object object, @CachedLibrary(value="object") InteropLibrary lib, @Cached GilNode gil) {
            gil.release(true);
            try {
                int n = PInt.intValue(lib.asBoolean(object));
                return n;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((String)"foreign value claims to be a boolean but isn't");
            }
            finally {
                gil.acquire();
            }
        }
    }

    @Slot(value=Slot.SlotKind.nb_bool)
    @GenerateUncached
    @GenerateNodeFactory
    static abstract class BoolNode
    extends TpSlotInquiry.NbBoolBuiltinNode {
        BoolNode() {
        }

        @Specialization(limit="getCallSiteInlineCacheMaxDepth()")
        static boolean bool(Object receiver, @CachedLibrary(value="receiver") InteropLibrary lib, @Cached GilNode gil) {
            gil.release(true);
            try {
                boolean bl = lib.asBoolean(receiver);
                return bl;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            finally {
                gil.acquire();
            }
        }
    }
}

