/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.function;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.compiler.CodeUnit;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.builtins.FunctionNodes;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@ExportLibrary(value=InteropLibrary.class)
public final class PFunction
extends PythonObject {
    private TruffleString name;
    private TruffleString qualname;
    private boolean forceSplitDirectCalls;
    private final Assumption codeStableAssumption;
    private final Assumption defaultsStableAssumption;
    private final PythonObject globals;
    @CompilerDirectives.CompilationFinal
    private boolean isBuiltin;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PCell[] closure;
    @CompilerDirectives.CompilationFinal
    private PCode finalCode;
    private PCode code;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private Object[] finalDefaultValues;
    private Object[] defaultValues;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private PKeyword[] finalKwDefaultValues;
    private PKeyword[] kwDefaultValues;
    private Object doc;

    public PFunction(PythonLanguage lang, TruffleString name, TruffleString qualname, PCode code, PythonObject globals, PCell[] closure) {
        this(lang, name, qualname, code, globals, PythonUtils.EMPTY_OBJECT_ARRAY, PKeyword.EMPTY_KEYWORDS, closure);
    }

    public PFunction(PythonLanguage lang, TruffleString name, TruffleString qualname, PCode code, PythonObject globals, Object[] defaultValues, PKeyword[] kwDefaultValues, PCell[] closure) {
        this(lang, name, qualname, code, globals, defaultValues, kwDefaultValues, closure, Truffle.getRuntime().createAssumption(), Truffle.getRuntime().createAssumption());
    }

    public PFunction(PythonLanguage lang, TruffleString name, TruffleString qualname, PCode code, PythonObject globals, Object[] defaultValues, PKeyword[] kwDefaultValues, PCell[] closure, Assumption codeStableAssumption, Assumption defaultsStableAssumption) {
        super((Object)PythonBuiltinClassType.PFunction, PythonBuiltinClassType.PFunction.getInstanceShape(lang));
        this.name = name;
        this.qualname = qualname;
        assert (code != null);
        this.code = this.finalCode = code;
        this.globals = globals;
        this.finalDefaultValues = defaultValues == null ? PythonUtils.EMPTY_OBJECT_ARRAY : defaultValues;
        this.defaultValues = this.finalDefaultValues;
        this.finalKwDefaultValues = kwDefaultValues == null ? PKeyword.EMPTY_KEYWORDS : kwDefaultValues;
        this.kwDefaultValues = this.finalKwDefaultValues;
        this.closure = closure;
        this.codeStableAssumption = codeStableAssumption;
        this.defaultsStableAssumption = defaultsStableAssumption;
        this.forceSplitDirectCalls = false;
    }

    public Assumption getCodeStableAssumption() {
        return this.codeStableAssumption;
    }

    public Assumption getDefaultsStableAssumption() {
        return this.defaultsStableAssumption;
    }

    public PythonObject getGlobals() {
        return this.globals;
    }

    public TruffleString getName() {
        return this.name;
    }

    public void setName(TruffleString name) {
        this.name = name;
    }

    public TruffleString getQualname() {
        return this.qualname;
    }

    public void setQualname(TruffleString qualname) {
        this.qualname = qualname;
    }

    public PCell[] getClosure() {
        return this.closure;
    }

    public boolean isBuiltin() {
        return this.isBuiltin;
    }

    public void setBuiltin(boolean builtin) {
        this.isBuiltin = builtin;
    }

    public void setForceSplitDirectCalls(boolean forceSplitDirectCalls) {
        this.forceSplitDirectCalls = forceSplitDirectCalls;
    }

    public boolean forceSplitDirectCalls() {
        return this.forceSplitDirectCalls;
    }

    public Object getDoc() {
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (this.doc == null ? 1 : 0) != 0)) {
            this.extractDoc();
        }
        return this.doc;
    }

    public void setDoc(Object doc) {
        this.doc = doc;
    }

    @CompilerDirectives.TruffleBoundary
    private void extractDoc() {
        CodeUnit co = this.getCode().getCodeUnit();
        this.doc = co != null && co.constants.length > 0 && PyUnicodeCheckNode.executeUncached(co.constants[0]) ? co.constants[0] : PNone.NONE;
    }

    @Override
    public final String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return String.format("PFunction %s at 0x%x", this.getQualname(), this.hashCode());
    }

    public PCode getCode() {
        if (CompilerDirectives.inCompiledCode() && CompilerDirectives.isPartialEvaluationConstant((Object)this) && this.getCodeStableAssumption().isValid()) {
            return this.finalCode;
        }
        return this.code;
    }

    @CompilerDirectives.TruffleBoundary
    public void setCode(PCode code) {
        this.codeStableAssumption.invalidate("code changed for function " + String.valueOf(this.getName()));
        assert (code != null) : "code cannot be null";
        this.finalCode = null;
        this.code = code;
    }

    public Object[] getDefaults() {
        if (CompilerDirectives.inCompiledCode() && CompilerDirectives.isPartialEvaluationConstant((Object)this) && this.defaultsStableAssumption.isValid()) {
            return this.finalDefaultValues;
        }
        return this.defaultValues;
    }

    @CompilerDirectives.TruffleBoundary
    public void setDefaults(Object[] defaults) {
        this.defaultsStableAssumption.invalidate("defaults changed for function " + String.valueOf(this.getName()));
        this.finalDefaultValues = null;
        this.defaultValues = defaults;
    }

    public PKeyword[] getKwDefaults() {
        if (CompilerDirectives.inCompiledCode() && CompilerDirectives.isPartialEvaluationConstant((Object)this) && this.defaultsStableAssumption.isValid()) {
            return this.finalKwDefaultValues;
        }
        return this.kwDefaultValues;
    }

    @CompilerDirectives.TruffleBoundary
    public void setKwDefaults(PKeyword[] defaults) {
        this.defaultsStableAssumption.invalidate("kw defaults changed for function " + String.valueOf(this.getName()));
        this.finalDefaultValues = null;
        this.kwDefaultValues = defaults;
    }

    @CompilerDirectives.TruffleBoundary
    String getSourceCode() {
        RootNode rootNode = FunctionNodes.GetCallTargetNode.getUncached().execute(this).getRootNode();
        SourceSection sourceSection = rootNode.getSourceSection();
        if (sourceSection != null) {
            return sourceSection.getCharacters().toString();
        }
        return null;
    }

    @ExportMessage
    boolean hasExecutableName() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    String getExecutableName(@Cached.Shared(value="gil") @Cached GilNode gil, @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
        boolean mustRelease = gil.acquire();
        try {
            String string = toJavaStringNode.execute((AbstractTruffleString)this.getName());
            return string;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public SourceSection getSourceLocation(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getCt") @Cached CodeNodes.GetCodeCallTargetNode getCt, @Cached.Shared(value="gil") @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            SourceSection result = this.getSourceLocationDirect(inliningTarget, getCt);
            if (result == null) {
                throw UnsupportedMessageException.create();
            }
            SourceSection sourceSection = result;
            return sourceSection;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private SourceSection getSourceLocationDirect(Node inliningTarget, CodeNodes.GetCodeCallTargetNode getCt) {
        RootNode rootNode = getCt.execute(inliningTarget, this.code).getRootNode();
        SourceSection result = rootNode instanceof PRootNode ? ((PRootNode)rootNode).getSourceSection() : PFunction.getForeignSourceSection(rootNode);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    private static SourceSection getForeignSourceSection(RootNode rootNode) {
        return rootNode.getSourceSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean hasSourceLocation(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getCt") @Cached CodeNodes.GetCodeCallTargetNode getCt, @Cached.Shared(value="gil") @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = this.getSourceLocationDirect(inliningTarget, getCt) != null;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }
}

