/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.itertools.ChainBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.PChain;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.lib.PyIterCheckNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PChain})
public final class ChainBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ChainBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Cached PythonObjectFactory factory) {
            return factory.createGenericAlias(cls, key);
        }
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(VirtualFrame frame, PChain self, Object state, @Bind(value="this") Node inliningTarget, @Cached TupleBuiltins.LenNode lenNode, @Cached TupleBuiltins.GetItemNode getItemNode, @Cached InlinedBranchProfile len2Profile, @Cached PyIterCheckNode iterCheckNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (!(state instanceof PTuple)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A, "state", "a length 1 or 2 tuple");
            }
            int len = (Integer)lenNode.execute(frame, state);
            if (len < 1 || len > 2) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A, "state", "a length 1 or 2 tuple");
            }
            Object source = getItemNode.execute(frame, state, 0);
            SetStateNode.checkIterator(inliningTarget, iterCheckNode, source, raiseNode);
            self.setSource(source);
            if (len == 2) {
                len2Profile.enter(inliningTarget);
                Object active = getItemNode.execute(frame, state, 1);
                SetStateNode.checkIterator(inliningTarget, iterCheckNode, active, raiseNode);
                self.setActive(active);
            }
            return PNone.NONE;
        }

        private static void checkIterator(Node inliningTarget, PyIterCheckNode iterCheckNode, Object obj, PRaiseNode.Lazy raiseNode) throws PException {
            if (!iterCheckNode.execute(inliningTarget, obj)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ARGUMENTS_MUST_BE_ITERATORS);
            }
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reducePos(PChain self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClass, @Cached InlinedConditionProfile hasSourceProfile, @Cached InlinedConditionProfile hasActiveProfile, @Cached PythonObjectFactory factory) {
            Object type = getClass.execute(inliningTarget, self);
            PTuple empty = factory.createTuple(PythonUtils.EMPTY_OBJECT_ARRAY);
            if (hasSourceProfile.profile(inliningTarget, self.getSource() != PNone.NONE)) {
                if (hasActiveProfile.profile(inliningTarget, self.getActive() != PNone.NONE)) {
                    PTuple tuple = factory.createTuple(new Object[]{self.getSource(), self.getActive()});
                    return factory.createTuple(new Object[]{type, empty, tuple});
                }
                PTuple tuple = factory.createTuple(new Object[]{self.getSource()});
                return factory.createTuple(new Object[]{type, empty, tuple});
            }
            return factory.createTuple(new Object[]{type, empty});
        }
    }

    @Builtin(name="from_iterable", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class FromIterNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object fromIter(VirtualFrame frame, Object cls, Object arg, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached PythonObjectFactory factory) {
            PChain instance = factory.createChain((Object)PythonBuiltinClassType.PChain);
            instance.setSource(getIter.execute((Frame)frame, inliningTarget, arg));
            instance.setActive(PNone.NONE);
            return instance;
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object next(VirtualFrame frame, PChain self, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached BuiltinFunctions.NextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isStopIterationProfile, @Cached InlinedBranchProfile nextExceptioProfile, @Cached InlinedLoopConditionProfile loopProfile, @Cached PRaiseNode.Lazy raiseNode) {
            while (loopProfile.profile(inliningTarget, self.getSource() != PNone.NONE)) {
                if (self.getActive() == PNone.NONE) {
                    try {
                        Object next = nextNode.execute(frame, self.getSource(), PNone.NO_VALUE);
                        Object iter = getIter.execute((Frame)frame, inliningTarget, next);
                        self.setActive(iter);
                    }
                    catch (PException e) {
                        nextExceptioProfile.enter(inliningTarget);
                        self.setSource(PNone.NONE);
                        throw e;
                    }
                }
                try {
                    return nextNode.execute(frame, self.getActive(), PNone.NO_VALUE);
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, isStopIterationProfile);
                    self.setActive(PNone.NONE);
                }
            }
            throw raiseNode.get(inliningTarget).raiseStopIteration();
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PChain self) {
            return self;
        }
    }
}

