/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.method;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.function.BuiltinFunctionBuiltins;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.method.BuiltinFunctionOrMethodBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.builtins.FunctionNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBuiltinFunctionOrMethod})
public final class BuiltinFunctionOrMethodBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BuiltinFunctionOrMethodBuiltinsFactory.getFactories();
    }

    @Builtin(name="__signature__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class SignatureNode
    extends PythonUnaryBuiltinNode {
        SignatureNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object doIt(Object fun, @Bind(value="this") Node inliningTarget) {
            Signature signature = FunctionNodes.GetSignatureNode.executeUncached(fun);
            if (signature.isHidden()) {
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.AttributeError, ErrorMessages.HAS_NO_ATTR, fun, SpecialAttributeNames.T__SIGNATURE__);
            }
            return BuiltinFunctionBuiltins.SignatureNode.createInspectSignature(signature, true);
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        static boolean isBuiltinFunction(PBuiltinMethod self) {
            return self.getSelf() == PNone.NO_VALUE || self.getSelf() instanceof PythonModule;
        }

        static boolean isBuiltinFunction(PMethod self) {
            return self.getSelf() == PNone.NO_VALUE || self.getSelf() instanceof PythonModule && self.getFunction() instanceof PFunction && ((PFunction)self.getFunction()).isBuiltin();
        }

        @Specialization(guards={"isBuiltinFunction(self)"})
        static TruffleString reprBuiltinFunction(VirtualFrame frame, PMethod self, @Cached.Shared @Cached(value="createGetAttributeNode()") GetAttributeNode getNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<built-in function %s>", getNameNode.executeObject(frame, self.getFunction()));
        }

        @Specialization(guards={"isBuiltinFunction(self)"})
        static TruffleString reprBuiltinFunction(VirtualFrame frame, PBuiltinMethod self, @Cached.Shared @Cached(value="createGetAttributeNode()") GetAttributeNode getNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return simpleTruffleStringFormatNode.format("<built-in function %s>", getNameNode.executeObject(frame, self.getFunction()));
        }

        @Specialization(guards={"!isBuiltinFunction(self)"})
        static TruffleString reprBuiltinMethod(VirtualFrame frame, PBuiltinMethod self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached(value="createGetAttributeNode()") GetAttributeNode getNameNode, @Cached.Shared @Cached TypeNodes.GetNameNode getTypeNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            TruffleString typeName = getTypeNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, self.getSelf()));
            return simpleTruffleStringFormatNode.format("<built-in method %s of %s object at 0x%s>", getNameNode.executeObject(frame, self.getFunction()), typeName, PythonAbstractObject.systemHashCodeAsHexString(self.getSelf()));
        }

        @Specialization(guards={"!isBuiltinFunction(self)"})
        static TruffleString reprBuiltinMethod(VirtualFrame frame, PMethod self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached(value="createGetAttributeNode()") GetAttributeNode getNameNode, @Cached.Shared @Cached TypeNodes.GetNameNode getTypeNameNode, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            TruffleString typeName = getTypeNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, self.getSelf()));
            return simpleTruffleStringFormatNode.format("<built-in method %s of %s object at 0x%s>", getNameNode.executeObject(frame, self.getFunction()), typeName, PythonAbstractObject.systemHashCodeAsHexString(self.getSelf()));
        }

        @NeverDefault
        protected static GetAttributeNode createGetAttributeNode() {
            return GetAttributeNode.create(SpecialAttributeNames.T___NAME__);
        }
    }
}

