/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;

public abstract class GetNextNode
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Object var2);

    public Object execute(Object iterator) {
        return this.execute(null, iterator);
    }

    public abstract boolean executeBoolean(VirtualFrame var1, Object var2) throws UnexpectedResultException;

    public abstract int executeInt(VirtualFrame var1, Object var2) throws UnexpectedResultException;

    public abstract long executeLong(VirtualFrame var1, Object var2) throws UnexpectedResultException;

    public abstract double executeDouble(VirtualFrame var1, Object var2) throws UnexpectedResultException;

    @NeverDefault
    public static GetNextNode create() {
        return new GetNextCached();
    }

    public static GetNextNode getUncached() {
        return GetNextUncached.INSTANCE;
    }

    private static final class GetNextCached
    extends GetNextNode {
        @Node.Child
        private LookupAndCallUnaryNode nextCall = LookupAndCallUnaryNode.create(SpecialMethodSlot.Next, () -> new LookupAndCallUnaryNode.NoAttributeHandler(){
            @Node.Child
            private PRaiseNode raiseNode = PRaiseNode.create();

            @Override
            public Object execute(Object receiver) {
                throw this.raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_NOT_ITERABLE, receiver);
            }
        });

        private GetNextCached() {
        }

        @Override
        public Object execute(Frame frame, Object iterator) {
            return this.nextCall.executeObject((VirtualFrame)frame, iterator);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frame, Object iterator) throws UnexpectedResultException {
            return PGuards.expectBoolean(this.nextCall.executeObject(frame, iterator));
        }

        @Override
        public int executeInt(VirtualFrame frame, Object iterator) throws UnexpectedResultException {
            return PGuards.expectInteger(this.nextCall.executeObject(frame, iterator));
        }

        @Override
        public long executeLong(VirtualFrame frame, Object iterator) throws UnexpectedResultException {
            return PGuards.expectLong(this.nextCall.executeObject(frame, iterator));
        }

        @Override
        public double executeDouble(VirtualFrame frame, Object iterator) throws UnexpectedResultException {
            return PGuards.expectDouble(this.nextCall.executeObject(frame, iterator));
        }
    }

    private static final class GetNextUncached
    extends GetNextNode {
        static final GetNextUncached INSTANCE = new GetNextUncached();

        private GetNextUncached() {
        }

        @Override
        public Object execute(Frame frame, Object iterator) {
            return this.executeImpl(iterator);
        }

        @CompilerDirectives.TruffleBoundary
        private Object executeImpl(Object iterator) {
            Object nextMethod = LookupSpecialMethodSlotNode.getUncached(SpecialMethodSlot.Next).execute(null, GetClassNode.executeUncached(iterator), iterator);
            if (nextMethod == PNone.NO_VALUE) {
                throw PRaiseNode.getUncached().raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, iterator, SpecialMethodNames.T___NEXT__);
            }
            return CallUnaryMethodNode.getUncached().executeObject(nextMethod, iterator);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frame, Object iterator) throws UnexpectedResultException {
            Object value = this.execute((Frame)frame, iterator);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw new UnexpectedResultException(value);
        }

        @Override
        public int executeInt(VirtualFrame frame, Object iterator) throws UnexpectedResultException {
            Object value = this.execute((Frame)frame, iterator);
            if (value instanceof Integer) {
                return (Integer)value;
            }
            throw new UnexpectedResultException(value);
        }

        @Override
        public long executeLong(VirtualFrame frame, Object iterator) throws UnexpectedResultException {
            Object value = this.execute((Frame)frame, iterator);
            if (value instanceof Long) {
                return (Long)value;
            }
            throw new UnexpectedResultException(value);
        }

        @Override
        public double executeDouble(VirtualFrame frame, Object iterator) throws UnexpectedResultException {
            Object value = this.execute((Frame)frame, iterator);
            if (value instanceof Double) {
                return (Double)value;
            }
            throw new UnexpectedResultException(value);
        }
    }
}

