/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.arrow.vector;

import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.arrow.ArrowSchema;
import com.oracle.graal.python.nodes.arrow.vector.GetFormatFromVectorNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.arrow.ArrowVectorSupport;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import sun.misc.Unsafe;

@GenerateCached(value=false)
@GenerateInline
public abstract class VectorToArrowSchemaNode
extends PNodeWithContext {
    public abstract ArrowSchema execute(Node var1, Object var2);

    @Specialization(guards={"arrowVectorSupport.isFixedWidthVector(vector)"})
    static ArrowSchema doIntVector(Node inliningTarget, Object vector, @Bind(value="getContext(inliningTarget)") PythonContext ctx, @Bind(value="ctx.arrowVectorSupport") ArrowVectorSupport arrowVectorSupport, @Cached GetFormatFromVectorNode formatNode) {
        Object hostVector = ctx.getEnv().asHostObject(vector);
        Unsafe unsafe = ctx.getUnsafe();
        ArrowSchema.Snapshot snapshot = new ArrowSchema.Snapshot();
        snapshot.format = unsafe.allocateMemory(2L);
        unsafe.putByte(snapshot.format, formatNode.execute(inliningTarget, hostVector));
        unsafe.putByte(snapshot.format + 1L, (byte)0);
        snapshot.release = ctx.arrowSupport.getArrowSchemaReleaseCallback();
        return ArrowSchema.allocateFromSnapshot(snapshot);
    }

    @Fallback
    static ArrowSchema doError(Node inliningTarget, Object object) {
        throw CompilerDirectives.shouldNotReachHere();
    }
}

