/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.nodes.builtins.FunctionNodes;
import com.oracle.graal.python.nodes.call.BoundDescriptor;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.GenericInvokeNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNodeGen;
import com.oracle.graal.python.nodes.call.special.CallReversibleMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@GenerateUncached
public abstract class CallBinaryMethodNode
extends CallReversibleMethodNode {
    @NeverDefault
    public static CallBinaryMethodNode create() {
        return CallBinaryMethodNodeGen.create();
    }

    public static CallBinaryMethodNode getUncached() {
        return CallBinaryMethodNodeGen.getUncached();
    }

    public abstract boolean executeBool(Frame var1, Object var2, Object var3, Object var4) throws UnexpectedResultException;

    public abstract int executeInt(Frame var1, Object var2, Object var3, Object var4) throws UnexpectedResultException;

    public abstract long executeLong(Frame var1, Object var2, Object var3, Object var4) throws UnexpectedResultException;

    public abstract Object executeObject(Frame var1, Object var2, Object var3, Object var4);

    public final Object executeObject(Object callable, Object arg1, Object arg2) {
        return this.executeObject(null, callable, arg1, arg2);
    }

    @Specialization(guards={"cachedInfo == info", "node != null"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callBinarySpecialMethodSlotInlined(VirtualFrame frame, BuiltinMethodDescriptor.BinaryBuiltinDescriptor info, Object arg1, Object arg2, @Cached(value="info") BuiltinMethodDescriptor.BinaryBuiltinDescriptor cachedInfo, @Cached(value="getBuiltin(cachedInfo)") PythonBinaryBuiltinNode node) {
        if (cachedInfo.isReverseOperation()) {
            return node.execute(frame, arg2, arg1);
        }
        return node.execute(frame, arg1, arg2);
    }

    protected static boolean hasAllowedArgsNum(BuiltinMethodDescriptor descr) {
        return descr.minNumOfPositionalArgs() <= 2;
    }

    @Specialization(guards={"cachedInfo == info", "node != null"}, limit="getCallSiteInlineCacheMaxDepth()")
    Object callTernarySpecialMethodSlotInlined(VirtualFrame frame, BuiltinMethodDescriptor.TernaryBuiltinDescriptor info, Object arg1, Object arg2, @Cached(value="info") BuiltinMethodDescriptor.TernaryBuiltinDescriptor cachedInfo, @Cached(value="hasAllowedArgsNum(cachedInfo)") boolean hasValidArgsNum, @Cached(value="getBuiltin(cachedInfo)") PythonTernaryBuiltinNode node) {
        this.raiseInvalidArgsNumUncached(hasValidArgsNum, cachedInfo);
        if (cachedInfo.isReverseOperation()) {
            return node.execute(frame, arg2, arg1, PNone.NO_VALUE);
        }
        return node.execute(frame, arg1, arg2, PNone.NO_VALUE);
    }

    protected static boolean isBinaryOrTernaryBuiltinDescriptor(Object value) {
        return value instanceof BuiltinMethodDescriptor.BinaryBuiltinDescriptor || value instanceof BuiltinMethodDescriptor.TernaryBuiltinDescriptor;
    }

    @Specialization(guards={"isBinaryOrTernaryBuiltinDescriptor(info)"}, replaces={"callBinarySpecialMethodSlotInlined", "callTernarySpecialMethodSlotInlined"})
    @HostCompilerDirectives.InliningCutoff
    Object callSpecialMethodSlotCallTarget(VirtualFrame frame, BuiltinMethodDescriptor info, Object arg1, Object arg2, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile invalidArgsProfile, @Cached GenericInvokeNode invokeNode2) {
        this.raiseInvalidArgsNumUncached(invalidArgsProfile.profile(inliningTarget, CallBinaryMethodNode.hasAllowedArgsNum(info)), info);
        RootCallTarget callTarget = PythonLanguage.get(this).getDescriptorCallTarget(info);
        Object[] arguments = PArguments.create(2);
        PArguments.setArgument(arguments, 0, arg1);
        PArguments.setArgument(arguments, 1, arg2);
        return invokeNode2.execute(frame, callTarget, arguments);
    }

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callObjectSingleContext(VirtualFrame frame, PBuiltinFunction func, Object arg1, Object arg2, @Cached(value="func") PBuiltinFunction cachedFunc, @Cached(value="isForReverseBinaryOperation(func.getCallTarget())") boolean isReverse, @Cached(value="getBuiltin(frame, func, 2)") PythonBuiltinBaseNode builtinNode) {
        if (isReverse) {
            return CallBinaryMethodNode.callBinaryBuiltin(frame, builtinNode, arg2, arg1);
        }
        return CallBinaryMethodNode.callBinaryBuiltin(frame, builtinNode, arg1, arg2);
    }

    @Specialization(guards={"func.getCallTarget() == ct", "builtinNode != null"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callObject(VirtualFrame frame, PBuiltinFunction func, Object arg1, Object arg2, @Cached(value="func.getCallTarget()") RootCallTarget ct, @Cached(value="isForReverseBinaryOperation(func.getCallTarget())") boolean isReverse, @Cached(value="getBuiltin(frame, func, 2)") PythonBuiltinBaseNode builtinNode) {
        if (isReverse) {
            return CallBinaryMethodNode.callBinaryBuiltin(frame, builtinNode, arg2, arg1);
        }
        return CallBinaryMethodNode.callBinaryBuiltin(frame, builtinNode, arg1, arg2);
    }

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null", "!takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callMethodSingleContext(VirtualFrame frame, PBuiltinMethod func, Object arg1, Object arg2, @Cached(value="func") PBuiltinMethod cachedFunc, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 2)") PythonBuiltinBaseNode builtinNode) {
        return CallBinaryMethodNode.callBinaryBuiltin(frame, builtinNode, arg1, arg2);
    }

    @Specialization(guards={"builtinNode != null", "getCallTarget(func, getCt) == ct", "!takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callMethod(VirtualFrame frame, PBuiltinMethod func, Object arg1, Object arg2, @Cached.Shared @Cached FunctionNodes.GetCallTargetNode getCt, @Cached(value="getCallTarget(func, getCt)") RootCallTarget ct, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 2)") PythonBuiltinBaseNode builtinNode) {
        return CallBinaryMethodNode.callBinaryBuiltin(frame, builtinNode, arg1, arg2);
    }

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null", "takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callMethodSingleContextSelf(VirtualFrame frame, PBuiltinMethod func, Object arg1, Object arg2, @Cached(value="func", weak=true) PBuiltinMethod cachedFunc, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 3)") PythonBuiltinBaseNode builtinNode) {
        return CallBinaryMethodNode.callTernaryBuiltin(frame, builtinNode, cachedFunc.getSelf(), arg1, arg2);
    }

    @Specialization(guards={"builtinNode != null", "getCallTarget(func, getCt) == ct", "takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    static Object callMethodSelf(VirtualFrame frame, PBuiltinMethod func, Object arg1, Object arg2, @Cached.Shared @Cached FunctionNodes.GetCallTargetNode getCt, @Cached(value="getCallTarget(func, getCt)") RootCallTarget ct, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 3)") PythonBuiltinBaseNode builtinNode) {
        return CallBinaryMethodNode.callTernaryBuiltin(frame, builtinNode, func.getSelf(), arg1, arg2);
    }

    @Specialization(guards={"!isBinaryOrTernaryBuiltinDescriptor(func)"}, replaces={"callObjectSingleContext", "callObject", "callMethodSingleContext", "callMethod", "callMethodSingleContextSelf", "callMethodSelf"})
    @HostCompilerDirectives.InliningCutoff
    @ReportPolymorphism.Megamorphic
    static Object call(VirtualFrame frame, Object func, Object arg1, Object arg2, @Bind(value="this") Node inliningTarget, @Cached CallNode callNode, @Cached.Exclusive @Cached InlinedConditionProfile isBoundProfile) {
        if (isBoundProfile.profile(inliningTarget, func instanceof BoundDescriptor)) {
            return callNode.execute((Frame)frame, ((BoundDescriptor)func).descriptor, new Object[]{arg2}, PKeyword.EMPTY_KEYWORDS);
        }
        return callNode.execute((Frame)frame, func, new Object[]{arg1, arg2}, PKeyword.EMPTY_KEYWORDS);
    }
}

