/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.expression;

import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.expression.CoerceToBooleanNode;
import com.oracle.graal.python.nodes.expression.ContainsNodeGen;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;

@GenerateInline(value=false)
public abstract class ContainsNode
extends BinaryOpNode {
    @NeverDefault
    public static ContainsNode create() {
        return ContainsNodeGen.create();
    }

    @NeverDefault
    public static LookupAndCallBinaryNode createCallNode() {
        return LookupAndCallBinaryNode.create(SpecialMethodSlot.Contains);
    }

    @Specialization(rewriteOn={UnexpectedResultException.class})
    public static boolean doBoolean(VirtualFrame frame, boolean item, Object iter, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CoerceToBooleanNode.YesNode castBool, @Cached.Shared(value="callNode") @Cached(value="createCallNode()") LookupAndCallBinaryNode callNode, @Cached.Shared(value="errorProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached.Shared(value="nextNode") @Cached GetNextNode nextNode) throws UnexpectedResultException {
        Object result = callNode.executeObject(frame, iter, item);
        if (result == PNotImplemented.NOT_IMPLEMENTED) {
            Object iterator = getIter.execute((Frame)frame, inliningTarget, iter);
            return ContainsNode.sequenceContains(frame, iterator, item, eqNode, nextNode, inliningTarget, errorProfile);
        }
        return castBool.executeBoolean(frame, inliningTarget, result);
    }

    @Specialization(rewriteOn={UnexpectedResultException.class})
    public static boolean doInt(VirtualFrame frame, int item, Object iter, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CoerceToBooleanNode.YesNode castBool, @Cached.Shared(value="callNode") @Cached(value="createCallNode()") LookupAndCallBinaryNode callNode, @Cached.Shared(value="errorProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached.Shared(value="nextNode") @Cached GetNextNode nextNode) throws UnexpectedResultException {
        Object result = callNode.executeObject(frame, iter, item);
        if (result == PNotImplemented.NOT_IMPLEMENTED) {
            return ContainsNode.sequenceContains(frame, getIter.execute((Frame)frame, inliningTarget, iter), item, eqNode, nextNode, inliningTarget, errorProfile);
        }
        return castBool.executeBoolean(frame, inliningTarget, result);
    }

    @Specialization(rewriteOn={UnexpectedResultException.class})
    public static boolean doLong(VirtualFrame frame, long item, Object iter, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CoerceToBooleanNode.YesNode castBool, @Cached.Shared(value="callNode") @Cached(value="createCallNode()") LookupAndCallBinaryNode callNode, @Cached.Shared(value="errorProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached.Shared(value="nextNode") @Cached GetNextNode nextNode) throws UnexpectedResultException {
        Object result = callNode.executeObject(frame, iter, item);
        if (result == PNotImplemented.NOT_IMPLEMENTED) {
            return ContainsNode.sequenceContains(frame, getIter.execute((Frame)frame, inliningTarget, iter), item, eqNode, nextNode, inliningTarget, errorProfile);
        }
        return castBool.executeBoolean(frame, inliningTarget, result);
    }

    @Specialization(rewriteOn={UnexpectedResultException.class})
    public static boolean doDouble(VirtualFrame frame, double item, Object iter, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CoerceToBooleanNode.YesNode castBool, @Cached.Shared(value="callNode") @Cached(value="createCallNode()") LookupAndCallBinaryNode callNode, @Cached.Shared(value="errorProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached.Shared(value="nextNode") @Cached GetNextNode nextNode) throws UnexpectedResultException {
        Object result = callNode.executeObject(frame, iter, item);
        if (result == PNotImplemented.NOT_IMPLEMENTED) {
            return ContainsNode.sequenceContains(frame, getIter.execute((Frame)frame, inliningTarget, iter), item, eqNode, nextNode, inliningTarget, errorProfile);
        }
        return castBool.executeBoolean(frame, inliningTarget, result);
    }

    @Specialization
    public static boolean doGeneric(VirtualFrame frame, Object item, Object iter, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CoerceToBooleanNode.YesNode castBool, @Cached.Shared(value="callNode") @Cached(value="createCallNode()") LookupAndCallBinaryNode callNode, @Cached.Shared(value="errorProfile") @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Cached.Shared(value="eqNode") @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached.Shared(value="nextNode") @Cached GetNextNode nextNode) {
        Object result = callNode.executeObject(frame, iter, item);
        if (result == PNotImplemented.NOT_IMPLEMENTED) {
            return ContainsNode.sequenceContainsObject(frame, getIter.execute((Frame)frame, inliningTarget, iter), item, eqNode, nextNode, inliningTarget, errorProfile);
        }
        return castBool.executeBoolean(frame, inliningTarget, result);
    }

    private static void handleUnexpectedResult(VirtualFrame frame, Object iterator, Object item, UnexpectedResultException e, PyObjectRichCompareBool.EqNode eqNode, GetNextNode nextNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) throws UnexpectedResultException {
        Object result = e.getResult();
        result = eqNode.compare((Frame)frame, inliningTarget, result, item) ? Boolean.valueOf(true) : Boolean.valueOf(ContainsNode.sequenceContainsObject(frame, iterator, item, eqNode, nextNode, inliningTarget, errorProfile));
        throw new UnexpectedResultException(result);
    }

    private static boolean sequenceContains(VirtualFrame frame, Object iterator, boolean item, PyObjectRichCompareBool.EqNode eqNode, GetNextNode nextNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) throws UnexpectedResultException {
        while (true) {
            try {
                while (nextNode.executeBoolean(frame, iterator) != item) {
                }
                return true;
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                return false;
            }
            catch (UnexpectedResultException e) {
                ContainsNode.handleUnexpectedResult(frame, iterator, item, e, eqNode, nextNode, inliningTarget, errorProfile);
                continue;
            }
            break;
        }
    }

    private static boolean sequenceContains(VirtualFrame frame, Object iterator, int item, PyObjectRichCompareBool.EqNode eqNode, GetNextNode nextNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) throws UnexpectedResultException {
        while (true) {
            try {
                while (nextNode.executeInt(frame, iterator) != item) {
                }
                return true;
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                return false;
            }
            catch (UnexpectedResultException e) {
                ContainsNode.handleUnexpectedResult(frame, iterator, item, e, eqNode, nextNode, inliningTarget, errorProfile);
                continue;
            }
            break;
        }
    }

    private static boolean sequenceContains(VirtualFrame frame, Object iterator, long item, PyObjectRichCompareBool.EqNode eqNode, GetNextNode nextNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) throws UnexpectedResultException {
        while (true) {
            try {
                while (nextNode.executeLong(frame, iterator) != item) {
                }
                return true;
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                return false;
            }
            catch (UnexpectedResultException e) {
                ContainsNode.handleUnexpectedResult(frame, iterator, item, e, eqNode, nextNode, inliningTarget, errorProfile);
                continue;
            }
            break;
        }
    }

    private static boolean sequenceContains(VirtualFrame frame, Object iterator, double item, PyObjectRichCompareBool.EqNode eqNode, GetNextNode nextNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) throws UnexpectedResultException {
        while (true) {
            try {
                while (nextNode.executeDouble(frame, iterator) != item) {
                }
                return true;
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                return false;
            }
            catch (UnexpectedResultException e) {
                ContainsNode.handleUnexpectedResult(frame, iterator, item, e, eqNode, nextNode, inliningTarget, errorProfile);
                continue;
            }
            break;
        }
    }

    private static boolean sequenceContainsObject(VirtualFrame frame, Object iterator, Object item, PyObjectRichCompareBool.EqNode eqNode, GetNextNode nextNode, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
        try {
            while (!eqNode.compare((Frame)frame, inliningTarget, nextNode.execute((Frame)frame, iterator), item)) {
            }
            return true;
        }
        catch (PException e) {
            e.expectStopIteration(inliningTarget, errorProfile);
            return false;
        }
    }
}

