/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.frame;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.frame.AccessNameNode;
import com.oracle.graal.python.nodes.frame.ReadFromLocalsNode;
import com.oracle.graal.python.nodes.frame.ReadGlobalOrBuiltinNode;
import com.oracle.graal.python.nodes.frame.ReadNameNodeGen;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
public abstract class ReadNameNode
extends PNodeWithContext
implements AccessNameNode {
    public final Object execute(VirtualFrame frame, TruffleString attributeId) {
        CompilerAsserts.partialEvaluationConstant((Object)attributeId);
        return this.executeImpl(frame, attributeId);
    }

    public abstract Object executeImpl(VirtualFrame var1, TruffleString var2);

    public static ReadNameNode create() {
        return ReadNameNodeGen.create();
    }

    private static Object readGlobalsIfKeyError(VirtualFrame frame, Node inliningTarget, TruffleString attributeId, ReadGlobalOrBuiltinNode readGlobalNode, PException e, BuiltinClassProfiles.IsBuiltinObjectProfile keyError) {
        e.expect(inliningTarget, PythonBuiltinClassType.KeyError, keyError);
        return readGlobalNode.execute(frame, attributeId);
    }

    protected static HashingStorage getStorage(VirtualFrame frame) {
        return ((PDict)PArguments.getSpecialArgument((Frame)frame)).getDictStorage();
    }

    @Specialization(guards={"!hasLocals(frame)"})
    protected static Object readFromLocals(VirtualFrame frame, TruffleString attributeId, @Cached.Exclusive @Cached ReadGlobalOrBuiltinNode readGlobalNode) {
        return readGlobalNode.execute(frame, attributeId);
    }

    @Specialization(guards={"hasLocals(frame)"})
    protected static Object readFromLocalsDict(VirtualFrame frame, TruffleString attributeId, @Bind(value="this") Node inliningTarget, @Cached ReadGlobalOrBuiltinNode.Lazy readGlobalOrBuiltinNode, @Cached ReadFromLocalsNode readFromLocals) {
        Object result = readFromLocals.execute(frame, inliningTarget, PArguments.getSpecialArgument((Frame)frame), attributeId);
        if (result == PNone.NO_VALUE) {
            return readGlobalOrBuiltinNode.get(inliningTarget).execute(frame, attributeId);
        }
        return result;
    }
}

