/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins.clinic;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.JavaBooleanConverterNodeGen;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

public abstract class JavaBooleanConverterNode
extends ArgumentCastNode {
    protected final boolean defaultValue;
    protected final boolean useDefaultForNone;

    protected JavaBooleanConverterNode(boolean defaultValue, boolean useDefaultForNone) {
        this.defaultValue = defaultValue;
        this.useDefaultForNone = useDefaultForNone;
    }

    @Specialization(guards={"!useDefaultForNone", "isNoValue(none)"})
    boolean doNoValue(PNone none) {
        return this.defaultValue;
    }

    @Specialization(guards={"!useDefaultForNone", "isNone(none)"})
    static boolean doNone(PNone none) {
        return false;
    }

    @Specialization(guards={"useDefaultForNone"})
    boolean doNoValueAndNone(PNone none) {
        return this.defaultValue;
    }

    @Specialization
    static boolean doBoolean(boolean b) {
        return b;
    }

    @Specialization
    static boolean doInt(int i) {
        return i != 0;
    }

    @Specialization(guards={"!isPNone(value)"})
    static Object doOthers(VirtualFrame frame, Object value, @Bind(value="this") Node inliningTarget, @Cached PyObjectIsTrueNode isTrueNode) {
        return isTrueNode.execute((Frame)frame, inliningTarget, value);
    }

    @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Boolean})
    @NeverDefault
    public static JavaBooleanConverterNode create(@ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone, @ClinicConverterFactory.DefaultValue boolean defaultValue) {
        if (!defaultValue) {
            return JavaBooleanConverterNodeGen.create(false, true);
        }
        return JavaBooleanConverterNodeGen.create(defaultValue, useDefaultForNone);
    }

    @ClinicConverterFactory(shortCircuitPrimitive={ArgumentClinic.PrimitiveType.Boolean})
    @NeverDefault
    public static JavaBooleanConverterNode create(@ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone) {
        assert (!useDefaultForNone) : "defaultValue must be provided if useDefaultForNone is true";
        return JavaBooleanConverterNode.create(false, false);
    }
}

