/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.statement;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.module.ModuleBuiltins;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyDictGetItem;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromPythonObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.object.GetDictFromGlobalsNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNodeFactory;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;

public abstract class AbstractImportNode
extends PNodeWithContext {
    public static final TruffleString T__FIND_AND_LOAD = PythonUtils.tsLiteral("_find_and_load");

    public static PythonModule importModule(TruffleString name) {
        PythonContext context = PythonContext.get(null);
        Object builtinImport = context.getBuiltins().getAttribute(BuiltinNames.T___IMPORT__);
        if (builtinImport == PNone.NO_VALUE) {
            throw PConstructAndRaiseNode.getUncached().raiseImportError(null, ErrorMessages.IMPORT_NOT_FOUND, new Object[0]);
        }
        PTuple fromList = context.factory().createTuple(PythonUtils.EMPTY_TRUFFLESTRING_ARRAY);
        CallNode.executeUncached(builtinImport, name, PNone.NONE, PNone.NONE, fromList, 0);
        PythonModule sysModule = context.lookupBuiltinModule(BuiltinNames.T_SYS);
        Object modules = sysModule.getAttribute(BuiltinNames.T_MODULES);
        if (modules == PNone.NO_VALUE) {
            throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.UNABLE_TO_GET_S, "sys.modules");
        }
        Object module = PyObjectGetItem.executeUncached(modules, name);
        if (module instanceof PythonModule) {
            PythonModule pythonModule = (PythonModule)module;
            return pythonModule;
        }
        throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.NotImplementedError, ErrorMessages.PUTTING_NON_MODULE_OBJECTS_IN_SYS_MODULES_IS_NOT_SUPPORTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object importModule(VirtualFrame frame, TruffleString name, Object globals, TruffleString[] fromList, int level, ImportName importNameNode) {
        PythonModule builtinModule;
        PythonContext context = this.getContext();
        if (!context.isInitialized() && (builtinModule = context.lookupBuiltinModule(name)) != null) {
            return builtinModule;
        }
        if (this.emulateJython()) {
            if (fromList.length > 0) {
                context.pushCurrentImport(StringUtils.cat(name, StringLiterals.T_DOT, fromList[0]));
            } else {
                context.pushCurrentImport(name);
            }
        }
        try {
            Object object = importNameNode.execute((Frame)frame, context, context.getBuiltins(), name, globals, fromList, level);
            return object;
        }
        finally {
            if (this.emulateJython()) {
                context.popCurrentImport();
            }
        }
    }

    protected boolean emulateJython() {
        return PythonLanguage.get(this).getEngineOption(PythonOptions.EmulateJython);
    }

    @GenerateUncached
    public static abstract class ImportName
    extends Node {
        public abstract Object execute(Frame var1, PythonContext var2, PythonModule var3, TruffleString var4, Object var5, TruffleString[] var6, int var7);

        @Specialization
        static Object importName(VirtualFrame frame, PythonContext context, PythonModule builtins, TruffleString name, Object globals, TruffleString[] fromList, int level, @Cached ReadAttributeFromPythonObjectNode readAttrNode, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile importFuncProfile, @Cached PConstructAndRaiseNode.Lazy raiseNode, @Cached CallNode importCallNode, @Cached GetDictFromGlobalsNode getDictNode, @Cached PythonObjectFactory factory, @Cached PyImportImportModuleLevelObject importModuleLevel) {
            Object importFunc = readAttrNode.execute(builtins, BuiltinNames.T___IMPORT__, (Object)null);
            if (importFunc == null) {
                throw raiseNode.get(inliningTarget).raiseImportError((Frame)frame, ErrorMessages.IMPORT_NOT_FOUND, new Object[0]);
            }
            if (importFuncProfile.profile(inliningTarget, context.importFunc() != importFunc)) {
                Object globalsArg = globals instanceof PNone ? globals : getDictNode.execute(inliningTarget, globals);
                return importCallNode.execute((Frame)frame, importFunc, name, globalsArg, PNone.NONE, factory.createTuple(fromList), level);
            }
            return importModuleLevel.execute((Frame)frame, context, name, globals, fromList, level);
        }

        public static ImportName getUncached() {
            return AbstractImportNodeFactory.ImportNameNodeGen.getUncached();
        }
    }

    @GenerateUncached
    static abstract class FindAndLoad
    extends Node {
        FindAndLoad() {
        }

        protected abstract Object execute(Frame var1, PythonContext var2, TruffleString var3);

        @Specialization
        static Object findAndLoad(VirtualFrame frame, PythonContext context, TruffleString absName, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callFindAndLoad) {
            return callFindAndLoad.execute((Frame)frame, inliningTarget, context.getImportlib(), T__FIND_AND_LOAD, absName, context.importFunc());
        }
    }

    @GenerateUncached
    static abstract class ResolveName
    extends Node {
        private static final byte PKG_IS_HERE = 1;
        private static final byte PKG_IS_NULL = 1;
        private static final byte SPEC_IS_STH = 1;
        private static final byte NO_SPEC_PKG = 1;
        private static final byte CANNOT_CAST = 1;
        private static final byte GOT_NO_NAME = 1;
        public static final TruffleString T_PARENT = PythonUtils.tsLiteral("parent");

        ResolveName() {
        }

        protected static byte[] uncachedByte() {
            return new byte[]{-128};
        }

        @NeverDefault
        protected static byte[] singleByte() {
            return new byte[1];
        }

        abstract TruffleString execute(Frame var1, TruffleString var2, Object var3, int var4);

        @Specialization
        TruffleString resolveName(VirtualFrame frame, TruffleString name, Object globals, int level, @Bind(value="this") Node inliningTarget, @Cached GetDictFromGlobalsNode getDictNode, @Cached PyDictGetItem getPackageOrNameNode, @Cached PyDictGetItem getSpecNode, @Cached PyObjectGetAttr getParent, @Cached CastToTruffleStringNode castPackageNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached TruffleString.LastIndexOfCodePointNode lastIndexOfCodePointNode, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached(value="singleByte()", uncached="uncachedByte()", dimensions=1) byte[] branchStates) {
            int lastDotIdx;
            TruffleString pkgString;
            PDict globalsDict = getDictNode.execute(inliningTarget, globals);
            Object pkg = getPackageOrNameNode.execute((Frame)frame, inliningTarget, globalsDict, SpecialAttributeNames.T___PACKAGE__);
            Object spec = getSpecNode.execute((Frame)frame, inliningTarget, globalsDict, SpecialAttributeNames.T___SPEC__);
            if (pkg == PNone.NONE) {
                pkg = null;
            }
            if (pkg != null) {
                if ((branchStates[0] & 1) == 0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    branchStates[0] = (byte)(branchStates[0] | 1);
                }
                try {
                    pkgString = castPackageNode.execute(inliningTarget, pkg);
                }
                catch (CannotCastException e) {
                    if ((branchStates[0] & 1) == 0) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        branchStates[0] = (byte)(branchStates[0] | 1);
                    }
                    throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.TypeError, ErrorMessages.PACKAGE_MUST_BE_A_STRING);
                }
                if (spec != null && spec != PNone.NONE && (branchStates[0] & 1) == 0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    branchStates[0] = (byte)(branchStates[0] | 1);
                }
            } else {
                if (spec != null && spec != PNone.NONE) {
                    if ((branchStates[0] & 1) == 0) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        branchStates[0] = (byte)(branchStates[0] | 1);
                    }
                    pkg = getParent.execute((Frame)frame, inliningTarget, spec, T_PARENT);
                    try {
                        pkgString = castPackageNode.execute(inliningTarget, pkg);
                    }
                    catch (CannotCastException e) {
                        if ((branchStates[0] & 1) == 0) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            branchStates[0] = (byte)(branchStates[0] | 1);
                        }
                        throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.TypeError, ErrorMessages.SPEC_PARENT_MUST_BE_A_STRING);
                    }
                }
                if ((branchStates[0] & 1) == 0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    branchStates[0] = (byte)(branchStates[0] | 1);
                }
                if ((pkg = getPackageOrNameNode.execute((Frame)frame, inliningTarget, globalsDict, SpecialAttributeNames.T___NAME__)) == null) {
                    if ((branchStates[0] & 1) == 0) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        branchStates[0] = (byte)(branchStates[0] | 1);
                    }
                    throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.KeyError, ErrorMessages.NAME_NOT_IN_GLOBALS);
                }
                try {
                    pkgString = castPackageNode.execute(inliningTarget, pkg);
                }
                catch (CannotCastException e) {
                    if ((branchStates[0] & 1) == 0) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        branchStates[0] = (byte)(branchStates[0] | 1);
                    }
                    throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.TypeError, ErrorMessages.NAME_MUST_BE_A_STRING);
                }
                Object path = getPackageOrNameNode.execute((Frame)frame, inliningTarget, globalsDict, SpecialAttributeNames.T___PATH__);
                if (path == null) {
                    int dotIdx = indexOfCodePointNode.execute((AbstractTruffleString)pkgString, 46, 0, codePointLengthNode.execute((AbstractTruffleString)pkgString, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING);
                    if (dotIdx < 0) {
                        throw ResolveName.noParentError(frame);
                    }
                    pkgString = substringNode.execute((AbstractTruffleString)pkgString, 0, dotIdx, PythonUtils.TS_ENCODING, true);
                }
            }
            if ((lastDotIdx = codePointLengthNode.execute((AbstractTruffleString)pkgString, PythonUtils.TS_ENCODING)) == 0) {
                throw ResolveName.noParentError(frame);
            }
            for (int levelUp = 1; levelUp < level; ++levelUp) {
                if ((lastDotIdx = lastIndexOfCodePointNode.execute((AbstractTruffleString)pkgString, 46, lastDotIdx, 0, PythonUtils.TS_ENCODING)) >= 0) continue;
                throw PConstructAndRaiseNode.getUncached().raiseImportError((Frame)frame, ErrorMessages.ATTEMPTED_RELATIVE_IMPORT_BEYOND_TOPLEVEL, new Object[0]);
            }
            TruffleString base = substringNode.execute((AbstractTruffleString)pkgString, 0, lastDotIdx, PythonUtils.TS_ENCODING, true);
            if (name.isEmpty()) {
                return base;
            }
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)(base.byteLength(PythonUtils.TS_ENCODING) + PythonUtils.tsbCapacity(1) + name.byteLength(PythonUtils.TS_ENCODING)));
            appendStringNode.execute(sb, (AbstractTruffleString)base);
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_DOT);
            appendStringNode.execute(sb, (AbstractTruffleString)name);
            return toStringNode.execute(sb);
        }

        private static RuntimeException noParentError(VirtualFrame frame) {
            throw PConstructAndRaiseNode.getUncached().raiseImportError((Frame)frame, ErrorMessages.ATTEMPTED_RELATIVE_IMPORT_BEYOND_TOPLEVEL, new Object[0]);
        }
    }

    @GenerateUncached
    static abstract class EnsureInitializedNode
    extends Node {
        public static final TruffleString T_LOCK_UNLOCK_MODULE = PythonUtils.tsLiteral("_lock_unlock_module");

        EnsureInitializedNode() {
        }

        protected abstract void execute(Frame var1, PythonContext var2, Object var3, TruffleString var4);

        @Specialization
        static void ensureInitialized(VirtualFrame frame, PythonContext context, Object mod, TruffleString name, @Bind(value="this") Node inliningTarget, @Cached PyModuleIsInitializing isInitializing, @Cached PyObjectCallMethodObjArgs callLockUnlock) {
            if (isInitializing.execute((Frame)frame, mod)) {
                callLockUnlock.execute((Frame)frame, inliningTarget, context.getImportlib(), T_LOCK_UNLOCK_MODULE, name);
            }
        }
    }

    @GenerateUncached
    public static abstract class PyModuleIsInitializing
    extends Node {
        public abstract boolean execute(Frame var1, Object var2);

        @Specialization
        static boolean isInitializing(VirtualFrame frame, Object mod, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile hasSpec, @Cached PyObjectLookupAttr getSpecNode, @Cached PyObjectLookupAttr getInitNode, @Cached PyObjectIsTrueNode isTrue) {
            try {
                Object spec = getSpecNode.execute((Frame)frame, inliningTarget, mod, SpecialAttributeNames.T___SPEC__);
                if (hasSpec.profile(inliningTarget, spec != PNone.NO_VALUE)) {
                    Object initializing = getInitNode.execute((Frame)frame, inliningTarget, spec, ModuleBuiltins.T__INITIALIZING);
                    return isTrue.execute((Frame)frame, inliningTarget, initializing);
                }
                return false;
            }
            catch (PException e) {
                return false;
            }
        }

        public static PyModuleIsInitializing getUncached() {
            return AbstractImportNodeFactory.PyModuleIsInitializingNodeGen.getUncached();
        }
    }

    @GenerateUncached
    public static abstract class PyImportImportModuleLevelObject
    extends Node {
        public static final TruffleString T__HANDLE_FROMLIST = PythonUtils.tsLiteral("_handle_fromlist");

        public abstract Object execute(Frame var1, PythonContext var2, TruffleString var3, Object var4, TruffleString[] var5, int var6);

        @Specialization(guards={"level < 0"})
        Object levelLtZero(VirtualFrame frame, PythonContext context, TruffleString name, Object globals, TruffleString[] fromList, int level) {
            throw PRaiseNode.raiseUncached((Node)this, PythonBuiltinClassType.TypeError, ErrorMessages.LEVEL_MUST_BE_AT_LEAST_ZERO);
        }

        protected static boolean containsDot(TruffleString name, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.IndexOfCodePointNode indexOfCodePointNode) {
            return indexOfCodePointNode.execute((AbstractTruffleString)name, 46, 0, codePointLengthNode.execute((AbstractTruffleString)name, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) >= 0;
        }

        @Specialization(guards={"level == 0", "fromList.length == 0", "!containsDot(name, codePointLengthNode, indexOfCodePointNode)"}, limit="1")
        public static Object levelZeroNoFromlist(VirtualFrame frame, PythonContext context, TruffleString name, Object globals, TruffleString[] fromList, int level, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached PyDictGetItem getModuleNode, @Cached.Exclusive @Cached EnsureInitializedNode ensureInitialized, @Cached.Exclusive @Cached FindAndLoad findAndLoad, @Cached.Exclusive @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Exclusive @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode) {
            TruffleString absName = name;
            if (name.isEmpty()) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.EMPTY_MOD_NAME);
            }
            PDict sysModules = context.getSysModules();
            Object mod = getModuleNode.execute((Frame)frame, inliningTarget, sysModules, absName);
            if (mod != null && mod != PNone.NONE) {
                ensureInitialized.execute((Frame)frame, context, mod, absName);
            } else {
                mod = findAndLoad.execute((Frame)frame, context, absName);
            }
            return mod;
        }

        @Specialization(guards={"level >= 0"}, replaces={"levelZeroNoFromlist"})
        static Object genericImport(VirtualFrame frame, PythonContext context, TruffleString name, Object globals, TruffleString[] fromList, int level, @Bind(value="this") Node inliningTarget, @Cached ResolveName resolveName, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached PyDictGetItem getModuleNode, @Cached.Exclusive @Cached EnsureInitializedNode ensureInitialized, @Cached PyObjectLookupAttr getPathNode, @Cached PyObjectCallMethodObjArgs callHandleFromlist, @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached FindAndLoad findAndLoad, @Cached InlinedConditionProfile recursiveCase, @Cached.Exclusive @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Exclusive @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached TruffleString.SubstringNode substringNode) {
            TruffleString absName;
            if (level > 0) {
                absName = resolveName.execute((Frame)frame, name, globals, level);
            } else {
                if (name.isEmpty()) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.EMPTY_MOD_NAME);
                }
                absName = name;
            }
            PDict sysModules = context.getSysModules();
            Object mod = getModuleNode.execute((Frame)frame, inliningTarget, sysModules, absName);
            if (mod != null && mod != PNone.NONE) {
                ensureInitialized.execute((Frame)frame, context, mod, absName);
            } else {
                mod = findAndLoad.execute((Frame)frame, context, absName);
            }
            if (fromList.length == 0) {
                int nameLength = codePointLengthNode.execute((AbstractTruffleString)name, PythonUtils.TS_ENCODING);
                if (level == 0 || nameLength > 0) {
                    int dotIndex = indexOfCodePointNode.execute((AbstractTruffleString)name, 46, 0, nameLength, PythonUtils.TS_ENCODING);
                    if (dotIndex < 0) {
                        return mod;
                    }
                    if (level == 0) {
                        Object front = new ModuleFront(substringNode.execute((AbstractTruffleString)name, 0, dotIndex, PythonUtils.TS_ENCODING, true));
                        while (recursiveCase.profile(inliningTarget, (front = PyImportImportModuleLevelObject.genericImportRecursion(frame, inliningTarget, context, (ModuleFront)front, raiseNode, getModuleNode, ensureInitialized, findAndLoad, codePointLengthNode, indexOfCodePointNode, substringNode)) instanceof ModuleFront)) {
                        }
                        return front;
                    }
                    int cutoff = nameLength - dotIndex;
                    TruffleString toReturn = substringNode.execute((AbstractTruffleString)absName, 0, codePointLengthNode.execute((AbstractTruffleString)absName, PythonUtils.TS_ENCODING) - cutoff, PythonUtils.TS_ENCODING, true);
                    Object finalModule = getModuleNode.execute((Frame)frame, inliningTarget, sysModules, toReturn);
                    if (finalModule == null) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.KeyError, ErrorMessages.S_NOT_IN_SYS_MODS, toReturn);
                    }
                    return finalModule;
                }
                return mod;
            }
            Object path = getPathNode.execute((Frame)frame, inliningTarget, mod, SpecialAttributeNames.T___PATH__);
            if (path != PNone.NO_VALUE) {
                return callHandleFromlist.execute((Frame)frame, inliningTarget, context.getImportlib(), T__HANDLE_FROMLIST, mod, factory.createTuple(fromList), context.importFunc());
            }
            return mod;
        }

        static Object genericImportRecursion(VirtualFrame frame, Node inliningTarget, PythonContext context, ModuleFront front, PRaiseNode.Lazy raiseNode, PyDictGetItem getModuleNode, EnsureInitializedNode ensureInitialized, FindAndLoad findAndLoad, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.IndexOfCodePointNode indexOfCodePointNode, TruffleString.SubstringNode substringNode) {
            TruffleString absName = front.front;
            if (absName.isEmpty()) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.EMPTY_MOD_NAME);
            }
            PDict sysModules = context.getSysModules();
            Object mod = getModuleNode.execute((Frame)frame, inliningTarget, sysModules, absName);
            if (mod != null && mod != PNone.NONE) {
                ensureInitialized.execute((Frame)frame, context, mod, absName);
            } else {
                mod = findAndLoad.execute((Frame)frame, context, absName);
            }
            int dotIndex = indexOfCodePointNode.execute((AbstractTruffleString)absName, 46, 0, codePointLengthNode.execute((AbstractTruffleString)absName, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING);
            if (dotIndex < 0) {
                return mod;
            }
            front.front = substringNode.execute((AbstractTruffleString)absName, 0, dotIndex, PythonUtils.TS_ENCODING, true);
            return front;
        }

        @CompilerDirectives.ValueType
        private static final class ModuleFront {
            private TruffleString front;

            private ModuleFront(TruffleString front) {
                this.front = front;
            }
        }
    }
}

